<?php

namespace App\Http\Controllers;

use DateTime;
use EloquentBuilder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Exports\TradersExport;
use App\Http\Controllers\Controller;
use App\Trader;
use App\TraderType;
use App\TraderContract;
use App\ContractDetail;
use App\BuyerContractDetail;
use App\Produce;
use App\ProduceItem;
use App\ProduceUnit;
use App\Region;
use App\County;
use App\User;
use App\TraderContact;
use App\TraderMember;
use App\TraderNetwork;
use App\TraderSetting;
use App\Input;
use App\InputItem;
use App\InputUnit;
use DB;

class VerificationController extends Controller
{
    public function __construct() {
	    $this->middleware('auth',['except' => ['showRegistrationForm','storeNoAuthTrader','store']]);
    }

    public function export(Request $request) {
        return new TradersExport($request);
    }

    /**
     * Display a listing of the traders.
     *
     * @return Illuminate\View\View
     */
    public function index(Request $request)
    {
        $traders = EloquentBuilder::to(Trader::class, $request->all())->where('status','=',0)->get();
        $trader_types = TraderType::all();
        $dashboard['verified_traders'] = Trader::where('status',0)->count();
        $regions = Region::all();
        $counties = County::all();

        return view('verification.index', compact('traders', 'trader_types', 'regions', 'counties','dashboard'));
    }
    public function agentFos(Request $request)
    {
        $agent = Auth::user()->userAgent;
        $trader = [];
        foreach($agent as $traderobj)
        {
            $traderid = $traderobj->trader_id;
            array_push($trader,$traderid);
        }
        $traders = Trader::whereIn('id',$trader)->get();

        return view('traders.agents-fos', compact('traders'));
    }

    /**
     * Show the form for creating a new trader.
     *
     * @return Illuminate\View\View
     */
    public function create(Request $request)
    {
        $tradertypes = TraderType::pluck('name','id')->all();
        //$regions = Region::pluck('name','id')->all();
        $trader_types = TraderType::all();
        $regions = Region::all();

        // if($request->ajax()){
        //     $return_array = compact('tradertypes','regions','trader_types');
        //     return json_encode($return_array);
        // }

        return view('traders.create', compact('tradertypes','regions','trader_types'));
    }

    /**
     * Store a new trader in the storage.
     *
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        //create the use account and get the id
        $user_id = $this->storeUser($request);
        if($user_id) {
            $trader = $this->storeTrader($user_id, $request);
            if($trader) {
                if(Auth::user() == null) {
                    return redirect()->route('show-login-form')
                        ->with('success_message', 'Trader was successfully created.');
                } else {
                    return redirect()->route('traders.index')
                        ->with('success_message', 'Trader was successfully created.');
                }
            }
        } else {
            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        }
    }

    public function storeUser(Request $request) {
        $request->validate([            
            'organisation_name' => 'required',
            'trader_type'=>'required',
            'region' => 'required', 
            'county'=>'required',
            'ward' => 'required', 
            'email'=>'required',
            'user_email'=>'required',
            'phone' => 'required', 
            'postal_address'=>'required',
            'user_username' => 'required', 
            'user_password'=>'required',            
            'user_firstname' => 'required', 
            'user_lastname'=>'required',
            'user_phone'=>'required',
        ]);
        //set the username and the password
        $admin_user['username'] = $request->user_username;
        $admin_user['username_canonical'] = $request->user_username;
        $admin_user['password'] = Hash::make($request->user_password);
        $admin_user['firstname'] = $request->user_firstname;
        $admin_user['lastname'] = $request->user_lastname;
        $admin_user['email'] = $request->user_email;
        $admin_user['email_canonical'] = $request->user_email;
        $admin_user['phone'] = $request->user_phone;
        $admin_user['locked'] = 0;
        $admin_user['enabled'] = 1;
        $admin_user['user_id'] = 0;
        $admin_user['expired'] = 0;
        $admin_user['address'] = null;
        $admin_user['credentials_expired'] = 0;
        $admin_user['salt'] = Hash::make("password");
        $admin_user['roles'] = serialize([]);
        $admin_user['registration_date'] = new DateTime();
        $admin_user['active'] = 0;
        $admin_user['status'] = 6;
        $admin_user['official_code'] = 'anonymous';
        $admin_user['language'] = 'english';

            //create the use account and get the id
        $user_id = User::create($admin_user)->id;
        if($user_id) return $user_id;
        else return false;
    }

    public function storeTrader($user_id, $request) {
        //create the corresponding organization details
        $trader['organisation_name'] = $request->organisation_name;
        $trader['type_id'] = $request->trader_type;
        // $trader['preferred_regions'] = serialize($request->preferred_regions);
        $trader['region_id'] = $request->region;
        $trader['county_id'] = $request->county;
        $trader['ward'] = $request->ward;
        $trader['email'] = $request->email;
        $trader['phone'] = $request->phone;
        $trader['postal_address'] = $request->postal_address;
        $trader['user_id'] = $user_id;

        //store the data of the trader and get the trader id
        $new_trader = Trader::create($trader);
        if($new_trader) return $new_trader;
        else return false;
    }

    /**
     * Display the specified trader.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function show($id) {
        $trader = Trader::findOrFail($id)->load('trader_type');

        $trader_contacts = TraderContact::where('trader_id', $id)->get();
        $trader_members = TraderMember::where('trader_id', $id)->get()->load('user');
        $trader_contracts = TraderContract::where('trader_id', $id)->get();
        $trader_networks = TraderNetwork::where('trader_id', $id)->get()->load('trader', 'region', 'county', 'agrodealer');
        $produce_items = ProduceItem::where('trader_id', $id)->get();
        $input_items = InputItem::where('trader_id', $id)->get();

        $produces = Produce::all();
        $inputs = Input::all();
        $produce_units = ProduceUnit::all();
        $input_units = InputUnit::all();
        $regions = Region::all();
        $counties = County::all();

        return view('traders.show', compact('trader_members', 'trader_contracts', 'trader_contacts', 'trader_networks', 'produce_items', 'input_items', 'trader', 'produces', 'inputs', 'produce_units', 'input_units', 'regions', 'counties'));
    }

    public function profile()
    {
        $user_id = Auth::user()->id;
        $user = User::findOrFail($user_id);

        $trader = $user->getRelatedTrader();
        $id = $trader->id;

        $trader = Trader::findOrFail($id)->load('trader_type');
        $trader_members = TraderMember::where('trader_id', $id)->get()->load('user');
        $trader_contracts = TraderContract::where('trader_id', $id)->get();
        $trader_contacts = TraderContact::where('trader_id', $id)->get();
        $produce_items = ProduceItem::where('trader_id', $id)->get();
        $trader_networks = TraderNetwork::where('trader_id', $id)->get()->load('trader', 'region', 'county', 'agrodealer');
        $input_items = InputItem::where('trader_id', $id)->get();

        $produces = Produce::all();
        $inputs = Input::all();
        $produce_units = ProduceUnit::all();
        $input_units = InputUnit::all();
        $regions = Region::all();
        $counties = County::all();
        $users = User::all();

        // return view('traders.index', compact('trader_members', 'produce_items', 'input_items', 'trader_contracts', 'trader_contacts', 'trader', 'users', 'produces', 'inputs', 'produce_units', 'input_units'));
        return view('traders.profile', compact('trader_members', 'trader_contracts', 'trader_contacts', 'trader_networks', 'produce_items', 'input_items', 'trader', 'users', 'produces', 'inputs', 'produce_units', 'input_units', 'regions', 'counties'));
    }

    /**
     * Show the form for editing the specified trader.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function edit($id)
    {
        $trader = Trader::findOrFail($id);
        // $tradertypes = TraderType::pluck('name','id')->all();
        $trader_types = TraderType::all();

        $regions = Region::all();
        $counties = County::all();

        return view('traders.edit', compact('trader','trader_types','tradertypes','regions','counties'));
    }

    /**
     * Update the specified trader in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        $updated_trader = $this->updateTrader($id, $request);
        if($updated_trader) {
            return redirect()->back()
                ->with('success_message', 'Trader updated successfully.');
        } else {
            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        }
    }

    public function updateTrader($id, $request) {
        //get the trader organisation data
        $data['organisation_name'] = $request->organisation_name;
        $data['type_id'] = $request->type_id;
        // $data['preferred_regions'] = serialize($request->preferred_regions);
        $data['region_id'] = $request->region_id;
        $data['county_id'] = $request->county_id;
        $data['ward'] = $request->ward;
        $data['email'] = $request->email;
        $data['phone'] = $request->phone;
        $data['postal_address'] = $request->postal_address;

        $trader = Trader::findOrFail($id);
        $updated_trader = $trader->update($data);

        if($updated_trader) return $updated_trader;
        else return false;
    }

    /**
     * Remove the specified trader from the storage.
     *
     * @param int $id
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        $trader = Trader::findOrFail($id);
        //get user_id in trader
        $admin_user = $trader->user_id;
        $deleted_trader = $trader->delete();
        if($deleted_trader) {
            //delete the admin_user
            $admin_user = User::findOrFail($admin_user);
            $deleted_user = $admin_user->delete();

            if($deleted_user) {
                return redirect()->route('traders.index')
                    ->with('success_message', 'Trader Account was successfully deleted.');
            }
        } else {
            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        }
    }

    //show trader registration form
    public function showRegistrationForm() {
        
        $regions = DB::table('regions')->get();
        $counties = DB::table('counties')->get();
        $trader_types = DB::table('trader_type')->get();
        return view('auth.register', compact('regions','counties','trader_types'));
    }


    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request\Request $request
     * @return array
     */
    /*protected function getData(Request $request)
    {
        $rules = [
            'organization_name' => 'nullable|string|min:0|max:255',
            'postal_address' => 'nullable|string|min:0|max:255',
            //'regions' => 'nullable|string|min:0|max:255',
            //'email' => 'required|string|min:0|max:255',
            //'phone' => 'required|string|min:0|max:255',
            postal_address' => 'nullable|string|min:0|max:255',
            'physical_address' => 'nullable|string|min:0|max:255',
            'contact_one_name' => 'nullable|string|min:0|max:255',
            'contact_one_email' => 'nullable|string|min:0|max:255',
            'contact_one_phone' => 'nullable|string|min:0|max:255',
            'contact_two_name' => 'nullable|string|min:0|max:255',
            'contact_two_email' => 'nullable|string|min:0|max:255',
            'contact_two_phone' => 'nullable|string|min:0|max:255',
            'contact_three_name' => 'nullable|string|min:0|max:255',
            'contact_three_email' => 'nullable|string|min:0|max:255',
            'contact_three_phone' => 'nullable|string|min:0|max:255',
            'tonnage_per_year' => 'nullable|numeric|min:-999999.99|max:999999.99',
            'special_terms' => 'nullable',
            'destination_markets' => 'nullable|string|min:0|max:255',
            'trader_type_id' => 'required',
            'region_id' => 'required',
            'latitude' => 'nullable|string|min:0|max:255',
            'longitude' => 'nullable|string|min:0|max:255',


        ];

        $data = $request->validate($rules);

        return $data;
    }*/

    //add contract for the trader
    public function addContract(Request $request){
        $tradercontract['trader_id']=$request->trader_id;
        $tradercontract['contract_name']=$request->contract_name;
        $tradercontract['tonnage']=$request->trader_tonnage;
        $tradercontract['produce']=$request->trader_produce;

        if( $request->hasFile('contractinput') )
        {
            $file = $request->file('contractinput');
            $destinationPath = public_path().'/trader-contracts';
            $fileName = $file->getClientOriginalName();
            $upload_success = $file->move($destinationPath, $fileName);
            $tradercontract['contract_file'] = $fileName;
        }
        //add the record to the model

        $contract=TraderContract::create($tradercontract);
        if($contract){
            return redirect()->route('traders.index')
            ->with('success_message', 'Trader Contract was successfully added.');

        }

    }

    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request)
    {
        if($request->id) {
            $trader_updated = $this->updateTrader($request->id, $request);
            if($trader_updated) {
                $trader = Trader::where('id', $request->id)->first();
                return response()->json($trader->load('user'));
            }

        } else {
            $user_id = $this->storeUser($request);
            if($user_id) {
                $trader = $this->storeTrader($user_id, $request);
                // TODO: Add User as TraderContact after registration
                return response()->json($trader->load('user', 'trader_type', 'region', 'county'));
            }
        }

        return response()->json(['errors'=> 'Unexpected error occurred while trying to process your request']);
    }

    //no auth store new trader
    public function storeNoAuthTrader(Request $request)
    {
        if($request->id) {
            $trader_updated = $this->updateTrader($request->id, $request);
            if($trader_updated) {
                $trader = Trader::where('id', $request->id)->first();
                return response()->json($trader->load('user'));
            }

        } else {
            $user_id = $this->storeUser($request);
            if($user_id) {
                $trader = $this->storeTrader($user_id, $request);
                // TODO: Add User as TraderContact after registration
                return response()->json($trader->load('user', 'trader_type', 'region', 'county'));
            }
        }

        return response()->json(['errors'=> 'Unexpected error occurred while trying to process your request']);
    }

    public function storeSettings(Request $request)
    {
        $settings = TraderSetting::updateOrCreate(
            ['id' => $request->id],
            ['trader_id' => $request->trader_id, 'locked' => $request->locked, 'credit_limit' => $request->credit_limit]
        );

        if($settings) {
            $notification = array(
                'message' => 'Organisation settings updated successfully!',
                'alert' => 'success', // success, error, info, warning
            );

            return response()->json(['settings' => $settings, 'notification' => $notification]);
        }

        return response()->json(['errors' => 'Organisation settings update failed.']);
    }

    /**
     * Show the form for editing the specified trader.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $trader = Trader::findOrFail($id);
        return response()->json($trader->load('user'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        $trader = Trader::where('id', $id)->delete();
        return response()->json($trader);
    }

    public function getContractsAjax($id) {
        $trader = Trader::with('contracts')->findOrFail($id);

        if(isset($trader)) {
            $items = collect();
            $trader->each(function($q) use(&$items) {
                $items = $items->concat($q->contracts->load('produce','produce_unit'));
            });

            return response()->json($items);
        }

        return response()->json(['errors'=> 'No contract details found.']);
    }
    public function getItemsAjax($id) {
        $trader = Trader::with('inputitem')->findOrFail($id);

        if(isset($trader)) {
            $items = collect();
            $trader->each(function($q) use(&$items) {
                $items = $items->concat($q->inputitem->load('input','input_unit'));
            });

            return response()->json($items);
        }

        return response()->json(['errors'=> 'No contract details found.']);
    }


    //fosettings

    public function fosettings($id){
        $traderid=$id;
        $trader = Trader::findOrFail($id)->first();
        //retrieve the settings of this trader,if they dont exist initialize credit limit and lock to zero
        $fosettings= TraderSetting::where('trader_id',$id)->exists();
        $new_settings['locked']=0.00;
        $new_settings['trader_id']=$id;
        $new_settings['credit_limit']=0.00;
        $mysettings=array();
        if($fosettings){
            //return the record
            $mysettings= TraderSetting::where('trader_id',$id)->get();
        }
        else{
            //create the record with 0 values
         $new_fo_settings = TraderSetting::create($new_settings)->id;

         if($new_fo_settings){
           //return the record
           $mysettings= TraderSetting::where('trader_id',$new_fo_settings)->get();
         }
         else{
            //return the record
           $mysettings= TraderSetting::where('trader_id',$new_fo_settings)->get();
         }

        }

         return view('fo_settings.show', compact('mysettings','traderid','trader'));

    }

    public function savefolockedsettings(Request $request,$id){
        //update the locked property with new value
        $lockedrecord=TraderSetting::find($id);
        $lockedrecord->update(['locked'=>$request->locked]);
        //redirect back to the settings page
        return redirect('/fosettings'.'/'.$lockedrecord->trader_id)
        ->with('success_message', 'Lock Settings was successfully updated.');
    }
    public function savecreditlimitsettings(Request $request, $id){

         //update the locked property with new value
         $lockedrecord=TraderSetting::find($id);
         $lockedrecord->update(['credit_limit'=>$request->credit_limit]);
         //redirect back to the settings page
         return redirect('/fosettings'.'/'.$lockedrecord->trader_id)
         ->with('success_message', 'Credit Limit Settings was successfully updated.');
    }

    public function getAgroDealersAjax($id, Request $request) {
        $trader = Trader::findOrFail($id);
        if(isset($trader)) {
            if($request->type == 'last-mile') {
                $agrodealers = Trader::where('county_id', $request->location_id)->whereHas(
                    'trader_type', function($q) {
                        $q->where('name', 'Agrodealer');
                    }
                )->get();
            } elseif($request->type == 'regional') {
                $agrodealers = Trader::where('region_id', $request->location_id)->whereHas(
                    'trader_type', function($q) {
                        $q->where('name', 'Agrodealer');
                    }
                )->get();
            } else {
                $agrodealers = Trader::whereHas(
                    'trader_type', function($q) {
                        $q->where('name', 'Agrodealer');
                    }
                )->get();
            }

            return response()->json($agrodealers);
        }

        return response()->json(['errors'=> 'No agrodealers found.']);
    }
    
    public function verifyAccount($traderid){
        $trader = Trader::findOrFail($traderid);
        $data['status']=1;
        $updated_trader = $trader->update($data);
        
        
    }

}
