<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Trader;
use App\User;
use App\TraderMember;
use App\Vehicle;
use Auth;
class VehicleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
	{
	    $this->middleware('auth');
	}
    public function index()
    {
        //
        $user_id = Auth::user()->id;
        $user = User::findOrFail($user_id);
        $trader = $user->getRelatedTrader();
        $vehicles = Vehicle::where('trader_id',$trader->id)->get();
        return view('vehicles.index', compact('vehicles','trader'))->with('i');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        Vehicle::create($request->all());
        return redirect()->back()->
        with('success', 'Vehicle Added Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $vehicle = Vehicle::find($id);
        $vehicle->model = $request->get('model');
        $vehicle->make = $request->get('make');
        $vehicle->plate = $request->get('plate');
        $vehicle->tonnage = $request->get('tonnage');
        $vehicle->status = $request->get('status');
        $vehicle->save();
        return redirect()->back()
        ->with('success','Vehicle Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $vehicle = Vehicle::find($id);
        $vehicle->delete();
            return redirect()->back()
        ->with("success","Vehicle Ddeleted Successfully!");
    }
}
