<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Trader;
use App\User;
use App\TraderMember;
use App\TraderType;
use App\Credits;
use App\CreditClearing;
use App\UserWallet;
use Auth;

class UserCreditsController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
           //
           $id = Auth::user()->id;
           $user = User::find($id);
           $trader = $user->getRelatedTrader();
           
           $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        if(Auth::user()->isAdmin())
        {
            $tradertype = TraderType::where('name',"Farmer Organisation")->pluck('id');
            $traders = Trader::all()->where('status',1)->where('type_id',$tradertype[0]);
            return view('farmer-credits.index', compact('traders','dashboard'));
        }
        else
        {
            $farmers = TraderMember::all()->where('trader_id',$trader->id);
            return view('farmer-credits.index', compact('farmers','dashboard'));
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        if(isset($_POST['pay']))
        {
            CreditClearing::create($request->all());
            $id = $request->get('credit_id');
            $amount = $request->get('amount');
            $balance = $request->get('balance');

            $credits = Credits::find($id);
            $credits->balance = $balance - $amount;
            if($balance == $amount)
            {
                if(Auth::user()->isAdmin())
                {
                $credits->cleared = "2";
                }
                else
                {
                    $credits->cleared = "1";
                }
            }
            $credits->save();
            return redirect()->back()
            ->with('success', "Payment made succesfully");

        }
        else if(isset($_POST['confirm']))
        {
            $id = $request->get('credit_id');
            $confirm = Credits::find($id);
            $confirm->cleared = "2";
            $confirm->save();
            return redirect()->back()
            ->with('success', "Confirmed succesfully");
        } 
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        if(Auth::user()->isAdmin())
        {
            $trader = Trader::all()->where('id',$id);
            $farmers = TraderMember::all()->where('trader_id',$id);
            
            $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
            return view('farmer-credits.details', compact('farmers','trader','dashboard'));
        }
        else
        {
            $user = User::all()->where('id',$id);
            $credits = Credits::all()->where('user_id',$id);
            
            $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
            return view('farmer-credits.details', compact('user','credits','dashboard'));
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $user = User::all()->where('id',$id);
        $credits = Credits::all()->where('user_id',$id);
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('farmer-credits.edit', compact('user','credits','dashboard'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
