<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use DateTime;
use Carbon\Carbon;
use EloquentBuilder;
use App\Agent;
use App\User;
use App\UserWallet;
use App\Administrator;
use App\Trader;
use App\TraderMember;
use App\inputOrders;
use App\inputOrderItems;
use App\ProduceCollection;
use App\FarmerProfile;
use App\Charts\UserChart;
use App\Charts\TraderChart;
use App\Charts\TraderTypeChart;
use App\Charts\AgentDash;
use App\Delivery;
use App\DeliveryRequests;
use App\Exports\UsersExport;
use App\FarmerProduceAggregation;
use App\InputItem;
use App\Invoice;
use App\ProduceItem;
use App\TraderContract;
use App\TraderNetwork;
use App\Driver;
use App\Vehicle;
use App\CropSetting;
use App\SeasonProduce;
use App\Season;
use App\Livestock;

class UserController extends Controller
{
    public function export(Request $request) {
        return new UsersExport($request);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index() {
        //$this->authorize('viewAny', User::class);
        $users = User::all();
        $traders=TraderMember::all();
                
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('users.index', compact('users','traders','dashboard'));
    }

    
    public function assignorganization() {
        //$this->authorize('viewAny', User::class);
        $users = User::where('id',1)->get();
        $traders=TraderMember::all();
                
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('users.assignorganization', compact('users','traders','dashboard'));
    }



    public function create() {

        return view('users.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        $request->validate([
            'username' => 'required',
            'password' => 'required|confirmed|min:6',
            'firstname' => 'required',
            'lastname' => 'required',
            'email' => 'required',
            'phone' => 'required',
        ]);

        $user['username'] = $request->user_username;
        $user['username_canonical'] = $request->user_username;
        $user['password'] = Hash::make($request->user_password);
        $user['firstname'] = $request->user_firstname;
        $user['lastname'] = $request->user_lastname;
        $user['email'] = $request->user_email;
        $user['email_canonical'] = $request->user_email;
        $user['phone'] = $request->user_phone;
        $user['locked'] = 0;
        $user['enabled'] = 1;
        $user['user_id'] = 0;
        $user['expired'] = 0;
        $user['address'] = null;
        $user['credentials_expired'] = 0;
        $user['salt'] = Hash::make("password");
        $user['roles'] = serialize([]);
        $user['registration_date'] = new DateTime();
        $user['active'] = 1;
        $user['status'] = 6;
        $user['official_code'] = 'anonymous';
        $user['language'] = 'english';

        // $user_id = User::create($user)->id;
        // if($user_id) return $user_id;
        // else return false;

        $this->fill($user);

        if ($this->save()) {
            return redirect()->route('users.index')->with('success', 'User created.');
        } else {
            return redirect()->back()->with('failure', 'Create failed.');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
        $user = User::with('farmer_profile')->findOrFail($id);
        // $this->authorize('view', $user);
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('users.show', compact('user','dashboard'));
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\UserWallet  $user
     * @return \Illuminate\Http\Response
     */
    public function showWallet($id) {

        $user = User::find($id);

        $user_wallet = $user->wallet();
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('users.wallet', compact('user', 'user_wallet','dashboard'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit(User $user) {
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('users.edit', compact('user','dashboard'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, User $user) {
        $request->validate([
            'username' => 'required',
            'password' => 'required|confirmed|min:6',
            'firstname' => 'required',
            'lastname' => 'required',
            'email' => 'required',
            'phone' => 'required',
        ]);

        if ($user->update($request->all())) {
            return redirect()->route('users.index')->with('success', 'User updated.');
        } else {
            return redirect()->back()->with('failure', 'Update failed.');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy(User $user) {
        if ($user->delete()) {
            return redirect()->route('users.index')->with('success', 'User deleted.');
        } else {
            return redirect()->route('users.index')->with('failure', 'Delete failed.');
        }
    }

    public function dashboard() {
       if(Auth::user()->isAdmin()) {
            $user_type = 'Twalisha Agent';
            $dashboard = $this->getAdminDashboard();
        }  
        elseif(Auth::user()->getRelatedTrader() == '')
        {
            // $type = TraderMember::where('user_id',Auth::user()->id)->first();
            // $typer = $type['type'];
            // if($typer == 'agent')
            /* {
                 $user_type = 'agent';
                 $dashboard = $this->getAgentDashboard();
                
           }*/
            $type = Agent::where('user_id',Auth::user()->id)->first();
            
            if($type)
            {
                $user_type = 'agent';
                $dashboard = $this->getAgentDashboard();
                
            }
        }
        elseif(Auth::user()->getRelatedTrader()->isFarmerOrganisation()) {
            $user_type = 'Farmer Organisation';
            $dashboard = $this->getFarmerOrganisationDashboard();
        } elseif(Auth::user()->getRelatedTrader()->isBulkBuyer()) {
            $user_type = 'BTCotton Buyer';
            $dashboard = $this->getBulkBuyerDashboard();
        } elseif(Auth::user()->getRelatedTrader()->isBulkSeller()) {
            $user_type = 'BTCotton Seller';
            $dashboard = $this->getBulkSellerDashboard();

        } elseif(Auth::user()->getRelatedTrader()->isAgroDealer()) {
            $user_type = 'Agrodealer';
            $dashboard = $this->getAgrodealerDashboard();
        } elseif(Auth::user()->getRelatedTrader()->isTransporter()) {
            $user_type = 'Transporter';
            $dashboard = $this->getTransporterDashboard();
        }
        elseif(Auth::user()->getRelatedTrader()->isAgent()) {
            $user_type = 'Expert';
            $dashboard = $this->getAgentDashboard();
        }
            
            
        // }

        return view('dashboard', compact('dashboard', 'user_type'));
        return $user_type;
    }

    public function getAdminDashboard() {
        $all_traders = Trader::all();
        $traders_last_week = $all_traders->where('created_at', '>', Carbon::now()->subDays(7))->count();
        $traders_last_month = $all_traders->where('created_at', '>', Carbon::now()->subMonth())->count();
        $traders_last_three_months = $all_traders->where('created_at', '>', Carbon::now()->subMonths(3))->count();

        $counts = collect([]);
        //notification_traders(unverified)
        $verified_traders = Trader::where('status','=',0)->count();

        $callback = function($query) { $query->where('name', '=', 'Farmer Organisation'); };
        $fo_count = Trader::whereHas('trader_type', $callback)->count();
        $counts = $counts->merge(['fo' => $fo_count]);

        $callback = function($query) { $query->where('name', '=', 'Bulk Buyer'); };
        $bb_count = Trader::whereHas('trader_type', $callback)->count();
        $counts = $counts->merge(['bb' => $bb_count]);

        $callback = function($query) { $query->where('name', '=', 'Bulk Seller'); };
        $bs_count = Trader::whereHas('trader_type', $callback)->count();
        $counts = $counts->merge(['bs' => $bs_count]);

        $callback = function($query) { $query->where('name', '=', 'Agrodealer'); };
        $ad_count = Trader::whereHas('trader_type', $callback)->count();
        $counts = $counts->merge(['ad' => $ad_count]);

        $callback = function($query) { $query->where('name', '=', 'Transporter'); };
        $t_count = Trader::whereHas('trader_type', $callback)->count();
        $counts = $counts->merge(['t' => $t_count]);

        $statistics = collect([]);

        $all_users = User::all();
        $users['count'] = $all_users->count();
        $users['last_week'] = $all_users->where('registration_date', '>', Carbon::now()->subDays(7))->count();
        $statistics = $statistics->merge(['users' =>$users]);

        $traders['count'] = $all_traders->count();
        $traders['last_week'] = $traders_last_week;
        $statistics = $statistics->merge(['traders' =>$traders]);

        $produce_orders['count'] = ProduceCollection::all()->count();
        $produce_orders['pending'] = ProduceCollection::where('status', 0)->count();
        $statistics = $statistics->merge(['produce_orders' =>$produce_orders]);

        $input_orders['count'] = inputOrders::all()->count();
        $input_orders['pending'] = inputOrders::where('approved', 0)->count();
        $statistics = $statistics->merge(['input_orders' =>$input_orders]);

        $trader_chart = new TraderChart;
        $trader_chart->labels(['Last Week', 'Last Month', 'Last 3 Months']);
        $trader_chart->dataset('Registered Organisations', 'bar', [$traders_last_week, $traders_last_month, $traders_last_three_months]);

        $borderColors = [ "rgba(255, 99, 132, 1.0)", "rgba(22,160,133, 1.0)", "rgba(255, 205, 86, 1.0)", "rgba(51,105,232, 1.0)", "rgba(244,67,54, 1.0)", "rgba(34,198,246, 1.0)", "rgba(153, 102, 255, 1.0)", "rgba(255, 159, 64, 1.0)", "rgba(233,30,99, 1.0)", "rgba(205,220,57, 1.0)" ];
        $fillColors = [ "rgba(255, 99, 132, 0.2)", "rgba(22,160,133, 0.2)", "rgba(255, 205, 86, 0.2)", "rgba(51,105,232, 0.2)", "rgba(244,67,54, 0.2)", "rgba(34,198,246, 0.2)", "rgba(153, 102, 255, 0.2)", "rgba(255, 159, 64, 0.2)", "rgba(233,30,99, 0.2)", "rgba(205,220,57, 0.2)" ];

        $trader_type_chart = new TraderTypeChart;
        $trader_type_chart->minimalist(true);
        $trader_type_chart->labels(['Farmer Organisations', 'Bulk Buyers', 'Input Sellers', 'Agrodealers', 'Transporters']);
        $trader_type_chart->dataset('Organisation Types', 'doughnut', [$counts['fo'], $counts['bb'], $counts['bs'], $counts['ad'], $counts['t']])
            ->color($borderColors)
            ->backgroundcolor($fillColors);

        return ['counts' => $counts, 'statistics' => $statistics, 'trader_chart' => $trader_chart, 'trader_type_chart' => $trader_type_chart,'verified_traders'=>$verified_traders];
    }

    public function getFarmerOrganisationDashboard() {
        $statistics = collect([]);

        $trader = Auth::user()->getRelatedTrader();
        $trader_id = $trader->id;

        $all_members = TraderMember::where('trader_id', $trader_id)->get();
        $members['count'] = $all_members->count();
        $members['last_week'] = $all_members->where('created_at', '>', Carbon::now()->subDays(7))->count();
        $statistics = $statistics->merge(['members' => $members]);

        $all_produce_items = ProduceItem::where('trader_id', $trader_id)->get();
        $produce_items['count'] = $all_produce_items->count();
        $produce_items['last_week'] = $all_produce_items->where('created_at', '>', Carbon::now()->subDays(7))->count();
        $statistics = $statistics->merge(['produce_items' => $produce_items]);

        $farmer_ids = $trader->users->pluck('id');
        $all_produce_aggregations = FarmerProduceAggregation::whereIn('farmer_id', $farmer_ids)->get();
        $produce_aggregations['count'] = $all_produce_aggregations->count();
        $produce_aggregations['pending'] = $all_produce_aggregations->where('approved', '=', 0)->count();
        $statistics = $statistics->merge(['produce_aggregations' => $produce_aggregations]);

        $all_input_orders = inputOrders::where('trader_id', $trader_id)->get();
        $input_orders['count'] = $all_input_orders->count();
        $input_orders['pending'] = $all_input_orders->where('approved', '=', 0)->count();
        $statistics = $statistics->merge(['input_orders' => $input_orders]);

        return ['statistics' => $statistics];
    }
    public function getAgentDashboard() {
        return "hello";
        $statistics = collect([]);

        $agent = Auth::user()->userAgent;
        
        $trader = [];
        foreach($agent as $traderobj)
        {
            $traderid = $traderobj->trader_id;
            array_push($trader,$traderid);
        }
        $fotraders = Trader::whereIn('id',$trader)->get();
        
        //get business plans count
        $plans = CropSetting::where('cost_of_production','!=','')->count();
        $statistics = $statistics->merge(['plans' => $plans]);
        //get seasons produce count
        $all_produce_items = ProduceItem::whereIn('trader_id', $trader)->pluck('id');
        $produce=SeasonProduce::whereIn('produce_item_id',$all_produce_items)->with('seasonproduceProduce.produce')->count();
        $statistics = $statistics->merge(['produce' => $produce]);
        //get livestock inspection count
        $allmembers=TraderMember::whereIn('trader_id',$trader)->pluck('user_id');
        $allfarmers=User::whereIn('id',$allmembers)->whereHas('farmer_profile', function($query){
            $query->select('id');
        })->get()->pluck('farmer_profile.id');
        $livestock =  Livestock::whereIn('farmer_id',$allfarmers)->with('livestockChild')->count();
        $statistics = $statistics->merge(['livestock' => $livestock]);

        //get active farmers count         
        $activefarmers=User::whereIn('id',$allmembers)->whereHas('farmer_profile', function($query){
            $query->select('id');
        })->count();
        $statistics = $statistics->merge(['activefarmers' => $activefarmers]);
        //get my produceitems
         $produceitems = ProduceItem::whereIn('trader_id', $trader)->with('produce')->get();
        //  $statistics = $statistics->merge([]);
       
        //get seasons
        $seasons = Season::whereIn('farmer_id',$allfarmers)->get();
        $statistics = $statistics->merge(['seasons' => $seasons]);
         //get eloquent filtered results
         $query = SeasonProduce::whereIn('produce_item_id',$all_produce_items)->with('seasonproduceProduce.produce');
         $seasonproduces = EloquentBuilder::to($query, request()->all())->get();
         $statistics = $statistics->merge(['seasonproduces' => $seasonproduces]);
        //  chart
        //get eloquent filtered results
        $querychart = SeasonProduce::whereIn('produce_item_id',$all_produce_items)->with('seasonproduceProduce.produce');
        $fo = EloquentBuilder::to($querychart, request()->all())->pluck('produce_item_id');
        $seasonproduceschart = EloquentBuilder::to($querychart, request()->all())->count();
        
        $borderColors = [ "rgba(255, 99, 132, 1.0)", "rgba(22,160,133, 1.0)", "rgba(255, 205, 86, 1.0)", "rgba(51,105,232, 1.0)", "rgba(244,67,54, 1.0)", "rgba(34,198,246, 1.0)", "rgba(153, 102, 255, 1.0)", "rgba(255, 159, 64, 1.0)", "rgba(233,30,99, 1.0)", "rgba(205,220,57, 1.0)" ];
        $fillColors = [ "rgba(255, 99, 132, 0.2)", "rgba(22,160,133, 0.2)", "rgba(255, 205, 86, 0.2)", "rgba(51,105,232, 0.2)", "rgba(244,67,54, 0.2)", "rgba(34,198,246, 0.2)", "rgba(153, 102, 255, 0.2)", "rgba(255, 159, 64, 0.2)", "rgba(233,30,99, 0.2)", "rgba(205,220,57, 0.2)" ];

        $producechart = new AgentDash;
        $producechart->minimalist(false);
        $producechart->labels(['Farmer Organisations', 'Seasons Produce']);
        $producechart->dataset('Seasons Produce', 'bar', [$fo[0], $seasonproduceschart])
            ->color($borderColors)
            ->backgroundcolor($fillColors);
        // end chart
        return ['statistics' => $statistics,'produceitems' => $produceitems,'fotraders' => $fotraders,'producechart' => $producechart];
    }

    public function getBulkBuyerDashboard() {
        $statistics = collect([]);

        $trader = Auth::user()->getRelatedTrader();
        $trader_id = $trader->id;

        $all_contracts = TraderContract::where('trader_id', $trader_id)->where('active', 1)->get();
        $contracts['count'] = $all_contracts->count();
        $statistics = $statistics->merge(['contracts' => $contracts]);

        $all_produce_collections = ProduceCollection::whereHas('contract_detail', function($query) use($trader_id) {
            $query->whereHas('contract', function($query) use($trader_id) {
                $query->where('trader_id', $trader_id);
            });
        })->get();
        $produce_collections['count'] = $all_produce_collections->count();
        $produce_collections['pending'] = $all_produce_collections->where('status', '=', 0)->count();
        $statistics = $statistics->merge(['produce_collections' => $produce_collections]);

        $produce_collection_ids = $all_produce_collections->pluck('id');
        $delivery_requests = DeliveryRequests::whereIn('produce_collection_id', $produce_collection_ids)->get();
        $deliveries['count'] = $delivery_requests->count();
        $deliveries['accepted'] = $delivery_requests->where('status', 1)->count();
        $statistics = $statistics->merge(['deliveries' => $deliveries]);

        $all_invoices = Invoice::where('directed_to', $trader_id)->get();
        $invoices['count'] = $all_invoices->count();
        $invoices['pending'] = $all_invoices->where('status', 0)->count();
        $statistics = $statistics->merge(['invoices' => $invoices]);

        return ['statistics' => $statistics];
    }

    public function getBulkSellerDashboard() {
        $statistics = collect([]);

        $trader = Auth::user()->getRelatedTrader();
        $trader_id = $trader->id;

        $all_input_items = InputItem::where('trader_id', $trader_id)->get();
        $input_items['count'] = $all_input_items->count();
        $input_items['last_week'] = $all_input_items->where('created_at', '>', Carbon::now()->subDays(7))->count();
        $statistics = $statistics->merge(['input_items' => $input_items]);

        $all_networks = TraderNetwork::where('trader_id', $trader_id)->get();
        $networks['count'] = $all_networks->count();
        $networks['last_mile'] = $all_networks->where('type', '=', 'last-mile')->count();
        $statistics = $statistics->merge(['networks' => $networks]);

        $all_input_orders = inputOrders::whereHas('orderItems', function($query) use($trader_id) {
            $query->whereHas('input', function($query) use($trader_id) {
                $query->where('trader_id', $trader_id);
            });
        })->get();
        $input_orders['count'] = $all_input_orders->count();
        $input_orders['pending'] = $all_input_orders->where('approved', '=', 1)->count();
        $statistics = $statistics->merge(['input_orders' => $input_orders]);

        $seller_items = inputOrderItems::where('directed_to', $trader_id)->pluck('id');
        $all_invoices = Invoice::whereIn('input_item_id', $seller_items)->where('type', 'input')->get();
        $invoices['count'] = $all_invoices->count();
        $invoices['pending'] = $all_invoices->where('status', '=', 0)->count();
        $statistics = $statistics->merge(['invoices' => $invoices]);

        return ['statistics' => $statistics];
    }

    public function getAgrodealerDashboard() {
        $statistics = collect([]);

        $trader = Auth::user()->getRelatedTrader();
        $trader_id = $trader->id;

        $agrodealer_items = inputOrderItems::where('directed_to', $trader_id)->get();
        $agrodealer_items_ids = $agrodealer_items->pluck('id');
        $agrodealer_items_order_ids = $agrodealer_items->pluck('order_id');

        $all_input_orders = inputOrders::whereIn('id', $agrodealer_items_order_ids)->where('approved', ">", 0)->get();
        $input_orders['count'] = $all_input_orders->count();
        $input_orders['pending'] = $all_input_orders->where('approved', '=', 1)->count();
        $statistics = $statistics->merge(['input_orders' => $input_orders]);

        $all_invoices = Invoice::whereIn('input_item_id', $agrodealer_items_ids)->where('type', 'input')->get();
        $invoices['count'] = $all_invoices->count();
        $invoices['pending'] = $all_invoices->where('status', '=', 0)->count();
        $statistics = $statistics->merge(['invoices' => $invoices]);

        return ['statistics' => $statistics];
    }

    public function getTransporterDashboard() {
        $statistics = collect([]);

        $trader = Auth::user()->getRelatedTrader();
        $trader_id = $trader->id;

        $all_drivers = Driver::where('trader_id', $trader_id)->get();
        $drivers['count'] = $all_drivers->count();
        $drivers['available'] = $all_drivers->where('status', '=', 0)->count();
        $statistics = $statistics->merge(['drivers' => $drivers]);

        $all_vehicles = Vehicle::where('trader_id', $trader_id)->get();
        $vehicles['count'] = $all_vehicles->count();
        $vehicles['available'] = $all_vehicles->where('status', '=', 0)->count();
        $statistics = $statistics->merge(['vehicles' => $vehicles]);

        $all_requests = DeliveryRequests::where('transporter_id', $trader_id)->get();
        $requests['count'] = $all_requests->count();
        $requests['pending'] = $all_requests->where('status', '=', 0)->count();
        $statistics = $statistics->merge(['requests' => $requests]);

        $all_deliveries = Delivery::whereHas('deliveryRequests', function($query) use($trader_id) {
            $query->where('transporter_id', $trader_id);
        })->where('status', '=', 1)->get();
        $on_transit['count'] = $all_deliveries->count();
        $statistics = $statistics->merge(['on_transit' => $on_transit]);

        return ['statistics' => $statistics];
    }

    public function showLoginForm() {
        return view('auth.login');
    }

    public function login(Request $request) {
        //find the user by the provided username
        $user = User::whereUsername($request->username)->first();
        if (is_null($user)) {
            return redirect()->route('login')->with('failure', 'Invalid username or password');
        }

        if (password_verify($request->password, $user->password)) {
            if (!$user->active) {
                return redirect()->route('login')->with('failure', 'Your account has a pending approval.');
            } else {
                Auth::login($user);
                return redirect()->route('dashboard');
            }
        }

        return redirect()->route('login')->with('failure', 'Invalid username or password');
    }

    public function logout() {
        Auth::logout();
        return redirect()->route('show-login-form');
    }

    public function profile($id) {
        $farmer_profile = FarmerProfile::where('user_id', $id)->get();
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('users.profile', compact('farmer_profile','dashboard'));
    }

    public function getUserAjax($id) {
        $user = User::select(['firstname','lastname','email','phone', 'username'])->findOrFail($id);
        return response()->json($user);
    }

    public function editProfile($id) {
        //$this->authorize('update', $product);
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        $user = User::findOrFail($id);
        if ($user) {
            $farmer_profile = FarmerProfile::where('user_id', $id)->first();
            return view('users.profile', compact('user','farmer_profile','dashboard'));
        }
    }

    public function updateProfile($id, Request $request) {
        $user = User::findOrFail($id);

        $request->validate([
            'firstname' => 'required',
            'lastname' => 'required',
            'email' => 'required',
            'phone' => 'required',
        ]);

        $updated_user['firstname'] = $request->firstname;
        $updated_user['lastname'] = $request->lastname;
        $updated_user['email'] = $request->email;
        $updated_user['phone'] = $request->phone;
        $updated_user['address'] = $request->address;

        // $user_id = User::create($user)->id;
        // if($user_id) return $user_id;
        // else return false;

        if ($user->update($updated_user)) {
            $farmer_profile = FarmerProfile::where('user_id', $id);

            $updated_profile['middlename'] = $request->middlename;
            $updated_profile['national_id'] = $request->national_id;
            $updated_profile['mpesa_number'] = $request->mpesa_number;
            $updated_profile['education_level'] = $request->education_level;
            $updated_profile['acreage'] = $request->acreage;
            $updated_profile['acreage_farmed'] = $request->acreage_farmed;
            $updated_profile['input_spending'] = $request->input_spending;
            $updated_profile['preferred_learning_language'] = $request->preferred_learning_language;
            $updated_profile['preferred_agrodealer'] = $request->preferred_agrodealer;
            $updated_profile['preferred_inputs'] = $request->preferred_inputs;
            $updated_profile['computer_access'] = $request->computer_access;
            $updated_profile['computer_access_location'] = $request->computer_access_location;
            $updated_profile['internet_access'] = $request->internet_access;
            $updated_profile['internet_access_location'] = $request->internet_access_location;
            $updated_profile['credit_history'] = $request->credit_history;
            $updated_profile['credit_history_outstanding'] = $request->credit_history_outstanding;
            $updated_profile['credit_history_outstanding_details'] = $request->credit_history_outstanding_details;

            $farmer_profile->update($updated_profile);
            $farmer_profile = FarmerProfile::updateOrCreate(
                ['user_id' => $id], $updated_profile
            );

            return redirect()->route('profile', $user->id)->with('success', 'User updated.');
        } else {
            return redirect()->back()->with('failure', 'Update failed.');
        }
    }

     
    public function deleteUserAjax($id)
    {
       /// return $id;
       $user = User::find($id);
       $user->delete();
           return redirect()->back()
       ->with("success","User Ddeleted Successfully!");
    }

}
