<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Log;
use Auth;
use App\User;
use App\InputCategory;
use App\Input;
use App\inputOrders;
use App\TraderMember;
use App\inputOrderItems;
use App\Trader;
use App\InputItem;
use App\SessionLevel;
use App\FarmerSessionLevel;
use App\TemporaryUssd;
use App\FarmerProfile;
use App\UserWallet;
use App\UserWalletTransaction;

class USSDController extends Controller
{
      //check accountbalance
    public function customerbalanceUssd(Request $request)
    {
       // Reads the variables sent via POST from our gateway
        $sessionId   = $request->sessionId;
        $serviceCode = $request->serviceCode;
        $phoneNumber = $request->phoneNumber;
        $text        = $request->text;
        
        
      $textArray=explode('*', $text);
	  $userResponse=trim(end($textArray));
	    
	  $newphone="0".substr($phoneNumber,4);
	  
	  $itemselected=array();
      $orderid=array();
     
      $item=array();
             
	  
	  //verify that the user exists
      $user = self::getUser($phoneNumber);
      
      if (self::user_is_starting($text)) {
          
           //start the ussd service
           if($user){
               
                //cancel any incomplete order of this trader
                $traderid=self::getFarmerTrader($user['id']);
                //update the level to 1
                $newlevel=1;
                self::updateFarmerSession($newphone,$newlevel,$sessionId,$user['id']);
                //show the main menu
                self::customermainMenu($user['firstname']);
                
                
           }
           else{
               
               //give a message that the agrodealer does not exist
               
                self::stop_start_service();
               
               
           }
          
        }
        //start the section of if the text has some value
        else{
             
             $currenttext=self::currentText($text);
             //get the levels
             $levels=self::getFarmerLevels($newphone);
        
                   switch($levels){
                     case 1:
                          if($currenttext=="1"){
                              $currentorder=self::getFarmerCurrentOrder($user['id']);
                              if(!empty($currentorder)){
                                  $orderamount=$currentorder['amount'];
                                  $ordertrader=$currentorder['trader'];
                                  
                                    $response="CON Your current order by Agrodealer(".$ordertrader.") is worth Ksh. ".$orderamount.".Select:\n";
                                    $response.="1. Approve Order \n";
                                    $response.="2. Decline Order \n";
                                    $response.="0. Main Menu \n";
                                    
                                    //update level to 2
                                     $newlevel=2;
                                     self::updateFarmerSession($newphone,$newlevel,$sessionId,$user['id']);
                                  
                              }
                              else{
                                   //update level to 2
                                   $newlevel=3;
                                   self::updateFarmerSession($newphone,$newlevel,$sessionId,$user['id']);
                                   $response="CON Your Don't have any order to process:\n";
                                   $response.="0. Main Menu \n";
                              }
                             
                              self::getResponse($response);
                             
                           }
                          elseif($currenttext=="2"){
                               //get the account balance of the agrodealer
                               $balance=self::getFarmerBalance($user['id']);
                               $response="CON Your Balance is Kshs. ".$balance." \n";
                                $response.="0. Main Menu \n";
                                
                                $newlevel=3;
                                self::updateFarmerSession($newphone,$newlevel,$sessionId,$user['id']);
                                self::getResponse($response); 
                           }
                          elseif($currenttext=="3"){
                              $response="END Thank you using Twalisha.Bye. \n";
                              self::getResponse($response); 
                           }
                           
                         break;
                     case 2:
                         if($currenttext=="1"){
                              $currentorder=self::getFarmerCurrentOrder($user['id']);
                              $orderid=$currentorder['orderid'];
                              $orderamount=$currentorder['amount'];
                              
                              self::farmerConfirmOrder($orderid,$currenttext);
                              //send message
                              $response="END Your Have successfully confirmed the order of Kshs. ".$orderamount." \n";
                               $newlevel=1;
                              self::updateFarmerSession($newphone,$newlevel,$sessionId,$user['id']);
                              self::getResponse($response); 
                              
                            
                         }
                         elseif($currenttext=="2"){
                            
                              $currentorder=self::getFarmerCurrentOrder($user['id']);
                              $orderid=$currentorder['orderid'];
                              $orderamount=$currentorder['amount'];
                              
                              self::farmerConfirmOrder($orderid,0);
                              //send message
                              $response="END Your Have successfully Cancelled your order of  Kshs. ".$orderamount." \n";
                               $newlevel=1;
                               self::updateFarmerSession($newphone,$newlevel,$sessionId,$user['id']);
                              self::getResponse($response);  
                         }
                         elseif($currenttext=="0"){
                            
                             $newlevel=1;
                             self::updateFarmerSession($newphone,$newlevel,$sessionId,$user['id']);
                             //show the main menu
                             self::customermainMenu($user['firstname']); 
                         }
                         break;
                      case 3:
                         if($currenttext=="0"){
                            $newlevel=1;
                            self::updateFarmerSession($newphone,$newlevel,$sessionId,$user['id']);
                            //show the main menu
                            self::customermainMenu($user['firstname']);
                            
                                          
                            
                         }
                         
                         break;
                     default:
                         $response="END You are not loggedin \n";
                         self::getResponse($response);
             
             }
             
             
        }
    
    }
    
    //update the inputitems for the farmer order
    public function farmerConfirmOrder($orderid,$response){
        
         $orderitemupdate=inputOrderItems::where('order_id',$orderid)->update(['order_item_status'=>$response]);
    }
    
    //get the current order of the farmer
    
    public function getFarmerCurrentOrder($userid){
        
        $inputorderitems=inputOrderItems::where('farmer_id',$userid)->where('approved',0)->where('order_item_status',NULL)->get();
        if(count($inputorderitems)>0){
           //pluck orderid to get the agrodealer
        $orderid=$inputorderitems[0]['order_id'];
        $order=inputOrders::where('id',$orderid)->first();
        //getTraderdetails
        $trader=Trader::where('id',$order['trader_id'])->where('type_id',4)->first();
        $orderamount=collect($inputorderitems)->sum('price');
        $orderdetails['trader']=$trader['organisation_name'];
        $orderdetails['amount']=$orderamount;
        $orderdetails['orderid']=$orderid; 
        }
        else{
            
            $orderdetails=array();
        }
        
        
        
        return $orderdetails;
        
    }
    
     //check accountbalance
    public function balanceUssd(Request $request)
    {
       // Reads the variables sent via POST from our gateway
        $sessionId   = $request->sessionId;
        $serviceCode = $request->serviceCode;
        $phoneNumber = $request->phoneNumber;
        $text        = $request->text;
        
        
      $textArray=explode('*', $text);
	  $userResponse=trim(end($textArray));
	    
	  $newphone="0".substr($phoneNumber,4);
	  
	  $itemselected=array();
      $orderid=array();
     
      $item=array();
             
	  
	  //verify that the user exists
      $user = self::getUser($phoneNumber);
      
      if (self::user_is_starting($text)) {
          
           //start the ussd service
           if($user){
               
                //cancel any incomplete order of this trader
                $traderid=self::getTrader($user['id']);
                self::cancelIncompleteOrder($traderid,$sessionId);
                
                //update the level to 1
                $newlevel=1;
                self::updateSession($newphone,$newlevel,$sessionId,$user['id']);
                //show the main menu
                self::mainMenu($user['firstname']);
                
                
           }
           else{
               
               //give a message that the agrodealer does not exist
               
                self::stop_start_service();
               
               
           }
          
        }
        //start the section of if the text has some value
        else{
             
             $currenttext=self::currentText($text);
             //get the levels
             $levels=self::getLevels($newphone);
        
                   switch($levels){
                     case 1:
                          if($currenttext=="1"){
                              $newlevel=2;
                              self::updateSession($newphone,$newlevel,$sessionId,$user['id']);
                              self::reOrder($user['id'],$newphone,$newlevel,$sessionId);
                           }
                          elseif($currenttext=="2"){
                            //get the account balance of the agrodealer
                            $balance=self::getDealerBalance($user['id']);
                            $response="END Your Balance is Kshs. ".$balance." \n";
                            self::getResponse($response);  
                           }
                          elseif($currenttext=="3"){
                             $response="END Thank you using Twalisha.Bye. \n";
                              
                             self::getResponse($response); 
                           }
                           
                         break;
                     case 2:
                         
                         if($currenttext=="0"){
                             //show the main menu
                             //update the level to 1
                             $newlevel=1;
                             self::updateSession($newphone,$newlevel,$sessionId,$user['id']);
                             self::mainMenu($user['firstname']);
                         }
                         elseif($currenttext!="0"){
                              //create the main order if it does not exist
                              $initialorder=self::createMainOrder($user['id']);
                            
                              //get the name of the product using the id from inputitems
                              $selecteditem=InputItem::where('id',$currenttext)->first();
                              
                              $newlevel=3;
                              self::updateSession($newphone,$newlevel,$sessionId,$user['id']);
                              
                              $object['item_id']=$selecteditem['id'];
                              $object['price']=$selecteditem['price_per_unit'];
                              $object['order_id']=$initialorder;
                              $object['session_id']=$sessionId;
                              $object['session_level']=$newlevel;
                              
                              //create a temporaly record with the sessionid
                              $temp=TemporaryUssd::create($object);
                              
                              //prompt for the quantity
                              $response="CON Enter the ".$selecteditem['name']." units to purchase \n";
                              
                              self::getResponse($response);
                              
                         }
                          
                           
                         break;
                     case 3:
                         //get the temporary record of the sessionid at level3for this trader
                         $temporaryitem=TemporaryUssd::where('session_level',3)->where('session_id',$sessionId)->orderBy('id', 'desc')->first();;
                         //List the purchased items and request if they want to purchase another item
                         $trader=self::getTrader($user['id']);
                         //check if the item exists
                         $orderitem=self::orderItem($temporaryitem['session_id'],$temporaryitem['order_id'],$temporaryitem['item_id'],$trader,$currenttext,$temporaryitem['price']);
                            if($orderitem){
                                $orderedinputitem=InputItem::where('id',$temporaryitem['item_id'])->first();
                                 
                                $response="CON You have successfully added ".$orderedinputitem['name']." \n";
                                $response.="1. Add another input item \n";
                                $response.="2. Cancel the order \n";
                                $response.="3. Process the order \n";
                                $response.="0. Main Menu \n";
                                     
                                //update to level 4
                                $newlevel=4;
                                self::updateSession($newphone,$newlevel,$sessionId,$user['id']);
                                self::getResponse($response); 
                                
                             }
                             else{
                                $response="CON You cannot order the same item twice, finish the transaction first or \n";
                                $response.="1. Add another input item \n";
                                $response.="2. Cancel the order \n";
                                $response.="3. Process the order \n";
                                $response.="0. Main Menu \n";
                             }
                        break;
                        case 4:
                         
                         if($currenttext=="1"){
                              //go back to case 2
                              $newlevel=2;
                              self::updateSession($newphone,$newlevel,$sessionId,$user['id']);
                              self::reOrder($user['id'],$newphone,$newlevel,$sessionId);
                         }  
                         elseif($currenttext=="2"){
                               $response="CON Are you sure you want to cancel?\n";
                               $response.="1. Yes \n";
                               $response.="2. No \n";
                               
                               //update to level 5
                                $newlevel=5;
                                self::updateSession($newphone,$newlevel,$sessionId,$user['id']);
                                self::getResponse($response); 
                             
                         }  
                         elseif($currenttext=="3"){
                             $traderid=self::getTrader($user['id']);
                             $orderitems=self::completeOrder($traderid);
                             
                             $amount=collect($orderitems)->sum('price');
                           
                             $item="You have ordered items worth Ksh.".$amount;
                             
                             $response="CON ".$item.".Are you sure you want to complete the order?.\n";
                             $response.="1. Yes \n";
                             $response.="2. No \n";
                             $response.="3. Add more items \n";
                             $response.="4. Main Menu\n";
                               
                             //update to level 6
                             $newlevel=6;
                             self::updateSession($newphone,$newlevel,$sessionId,$user['id']);
                             self::getResponse($response); 
                         }
                         elseif($currenttext=="0"){
                              
                              self::mainMenu($user['firstname']);
                         }
                          
                        break;
                         case 5:
                         
                         if($currenttext=="1"){
                              
                              //cancel the entire order and go to the main menu
                              $trader=self::getTrader($user['id']);
                              self::cancelOrder($trader,$sessionId);
                                  //go back to case 0
                                  $newlevel=1;
                                  self::updateSession($newphone,$newlevel,$sessionId,$user['id']);
                                  self::mainMenu($user['firstname']);
                              
                         }  
                         elseif($currenttext=="2"){
                              //return to the case of adding more items to the cart
                              //go back to case 2
                              $newlevel=2;
                              self::updateSession($newphone,$newlevel,$sessionId,$user['id']);
                              self::reOrder($user['id'],$newphone,$newlevel,$sessionId);
                         }  
                        break;
                         case 6:
                         
                         if($currenttext=="1"){
                              
                            $response="CON Enter the farmer phone(e.g.0700111222) \n";
                            //send an sms to the farmer
                            
                            
                            //////set the process to the 7th step
                            $newlevel=7;
                            self::updateSession($newphone,$newlevel,$sessionId,$user['id']);
                            self::getResponse($response);
                              
                         }  
                         elseif($currenttext=="2"){
                             //cancel the entire order and go to the main menu
                              $trader=self::getTrader($user['id']);
                              self::cancelOrder($trader,$sessionId);
                                  //go back to case 0
                                  $newlevel=1;
                              self::updateSession($newphone,$newlevel,$sessionId,$user['id']);
                              self::mainMenu($user['firstname']);
                         }  
                         
                         elseif($currenttext=="3"){
                             //return to the case of adding more items to the cart
                              //go back to case 2
                              $newlevel=2;
                              self::updateSession($newphone,$newlevel,$sessionId,$user['id']);
                              self::reOrder($user['id'],$newphone,$newlevel,$sessionId);
                         }  
                         elseif($currenttext=="4"){
                            self::mainMenu($user['firstname']);
                         } 
                         
                        break;
                        case 7:
                         //check the farmer details based on the phone number given
                         $farmer=self::getFarmer($currenttext);
                         //update the input items with the correct farmer details now that we have them
                         self::updateInputItems($currenttext,$sessionId,$user['id']);
                         
                         $response="CON Farmer Name is ".$farmer['middlename'].".National ID: ".$farmer['national_id'].".Kindly have the farmer confirm the order via USSD.Do you approve?. \n";
                         $response.="1. Yes\n";
                         $response.="2. No\n";
                         
                         //get to the final step
                         $newlevel=8;
                         self::updateSession($newphone,$newlevel,$sessionId,$user['id']);
                         
                         self::getResponse($response);
                        break;
                        case 8:
                         //if 1 for yes
                         if($currenttext=="1"){
                            self::finishTransaction($user['id']);
                            $response="CON You have finished the transaction.Thank you for using Twalisha \n";
                            $response.="0. Main Menu\n";
                             //update the level to mainmenu
                            $newlevel=9;
                            self::updateSession($newphone,$newlevel,$sessionId,$user['id']);
                            //self::mainMenu($user['firstname']);
                            
                            self::getResponse($response);
                         }
                         elseif($currenttext=="2"){
                            $response="CON You have Canceled the transaction.Thank you,Twalisha \n";
                            //self::mainMenu($user['firstname']);
                            self::getResponse($response);
                         }
                        break;
                        case 9:
                         //if 0 go to the main page
                         if($currenttext=="0"){
                             //update the level to 1
                            $newlevel=1;
                            self::updateSession($newphone,$newlevel,$sessionId,$user['id']);
                            self::mainMenu($user['firstname']);
                         }
                        break;
                         
                     default:
                         $response="END You are not loggedin \n";
                         self::getResponse($response);
             
             }
             
             
        }
    
    }
    //get the agrodealer accountbalance
    public function getDealerBalance($userid){
        //get the trader wallet and credit it
        $traderid=self::getTrader2($userid);
        $agrodealerwallet=UserWallet::where('user_id',$traderid)->first();
        $agrodealerwalletid=$agrodealerwallet['id'];
        $agrodealerwalletbalance=$agrodealerwallet['balance'];
        
        
        return $agrodealerwalletbalance;
    }
    
      //get the agrodealer accountbalance
    public function getFarmerBalance($userid){
        //get the trader wallet and credit it
        $traderid=self::getFarmerTrader($userid);
        $farmerwallet=UserWallet::where('user_id',$traderid)->first();
        $farmerwalletid=$farmerwallet['id'];
        $farmerwalletbalance=$farmerwallet['balance'];
        
        
        return $farmerwalletbalance;
    }
    //complete the transaction --deduct the amount from the farmer and add to the agrodealer
    public function finishTransaction($userid){
        
        //get the trader wallet and credit it
        $traderid=self::getTrader($userid);
        $agrodealerwallet=UserWallet::where('user_id',$traderid)->first();
        $agrodealerwalletid=$agrodealerwallet['id'];
        
        $agrodealerwalletbalance=$agrodealerwallet['balance'];
         $agrodealerfloatbalance=$agrodealerwallet['float_bal'];
        
        //get the inputitems for this trader at this stage for transaction description
        $inputorderitems=inputOrderItems::where('directed_to',$traderid)->orderBy('id', 'desc')->first();
        //orderid
        $orderid=$inputorderitems['order_id'];
        
        $farmerid=$inputorderitems['farmer_id'];
        
       
        
        //get the farmerwallet
        $farmerwallet=UserWallet::where('user_id',$traderid)->first();
        $farmerwalletid=$farmerwallet['id'];
        
        $inputorderitemss=inputOrderItems::where('directed_to',$traderid)->where('order_id',$orderid)->orderBy('id', 'desc')->get();
        
        $inputorderitemsfarmer=inputOrderItems::where('directed_to',$traderid)->where('order_id',$orderid)->orderBy('id', 'desc')->first(); 
        //amount
        $orderitems=self::completeOrder($traderid);
                             
        $amount=collect($orderitems)->sum('price');
        
        //add the transaction first before crediting the wallet
        $dealerbalance=$agrodealerwalletbalance;
        $newbalance= $dealerbalance+$amount;
        $newfloatbalance= $agrodealerfloatbalance+$amount;
        $agrotransaction['amount']=$amount;
        $hash="jdjdjdjjd";
        $type="deposit";
        $allitems=json_encode($inputorderitemss);
        
        
    
        $agrodealerdeposittransaction=UserWalletTransaction::create(
        ['amount'=>$amount,
        'hash'=>$hash,
        'type'=>$type,
        'meta'=>$allitems,
        'user_wallet_id'=>$agrodealerwallet['id']
        ]);
        
        //update wallet by the said amount
        $agroupdate=UserWallet::where('user_id',$traderid)->update(['balance'=>$newbalance,'float_bal'=>$newfloatbalance]);
        //if updated, send an sms
        if($agroupdate){
        }
        //get the farmer
        $farmerid=$inputorderitemsfarmer['farmer_id'];
        //get the farmer wallet and debit it
        $farmerwallet=UserWallet::where('user_id',$farmerid)->first();
        $farmerwalletid=$farmerwallet['id'];
        $farmerwalletbalance=$farmerwallet['balance'];
        $farmerfloatbalance=$farmerwallet['float_bal'];
        $farmerbalance=$farmerwalletbalance;
        $newfarmerbalance= $farmerbalance-$amount;
        $farmertransaction['amount']=$amount;
        $hash="kdjdjd";
        $farmertransaction['hash']=$hash;
        $farmertransaction['type']="withdrawal";
        $farmertransaction['meta']=json_encode($inputorderitemss);
        $farmertransaction['user_wallet_id']=$farmerwalletid;
        
        $farmerwithdrawaltransaction=UserWalletTransaction::create($farmertransaction);
        $farmerupdate= UserWallet::where('user_id',$farmerid)->update(['balance'=>$newfarmerbalance,'float_bal'=>$farmerfloatbalance]);
        //if updated, send an sms
        if($farmerupdate){
             
             //update the order approval to 4
             inputOrders::where('id',$orderid)->update(['approved'=>4]);
             
             //update the statuses of the inputorderitems
             inputOrderItems::where('order_id',$orderid)->update(['approved'=>4]);
        }
    }
    //update the inputitems farmerowner
    public function updateInputItems($phone,$sessionId,$userid){
        
        //get the farmer
        $farmer=self::getFarmer($phone);
        //get
        $farmerid=$farmer['user_id'];
        //get the order
        $temporaryitem=TemporaryUssd::where('session_level',3)->where('session_id',$sessionId)->orderBy('id', 'desc')->first();
        $orderid=$temporaryitem['order_id'];
        //List the purchased items and request if they want to purchase another item
        $traderid=self::getTrader($userid);
        //update the input items of this order with the farmerid and a newstatus of the orderitems
        $orderitemupdate=inputOrderItems::where('order_id',$orderid)->where('directed_to',$traderid)->update(['farmer_id'=>$farmerid]);
    }
    //get the farmer details
    public function getFarmer($phone){
        $user=User::where('phone',$phone)->first();
        //get traderfarmer
        $farmer=FarmerProfile::where('user_id',$user['id'])->first();
        return $farmer;
    }
    //get the complete order for processing
    public function completeOrder($traderid){
        //get the orderitems
        $order=inputOrders::where('trader_id',$traderid)->where('approved',0)->orderBy('id', 'desc')->first();
        $orderid=$order['id'];
        $orderitems=inputOrderItems::where('order_id',$orderid)->get();
       
        return $orderitems;
        
    }
    //cancel old incomplete order
     public function cancelIncompleteOrder($traderid,$sessionid){
        
        $status=0;
        
        $order=inputOrders::where('trader_id',$traderid)->where('approved',0)->orderBy('id', 'desc')->first();
        $orderid=$order['id'];
        //first delete the orderitems
        $orderitems=inputOrderItems::where('order_id',$orderid)->delete();
        if($orderitems){
            //delete the temporary records as well
            $deleteitems=TemporaryUssd::where('order_id',$orderid)->where('session_id','!=',$sessionid)->delete(); 
            if($deleteitems){
                //now delete the order
                 $del_order=inputOrders::where('trader_id',$traderid)->where('approved',0)->delete();
                 if($del_order){
                     $status=1;
                 }
                 else{
                     $status=0;
                 }
            }
        }
    }
    //cancel the order
    public function cancelOrder($traderid,$sessionid){
        
        $status=0;
        
        $order=inputOrders::where('trader_id',$traderid)->where('approved',0)->orderBy('id', 'desc')->first();
        $orderid=$order['id'];
        //first delete the orderitems
        $orderitems=inputOrderItems::where('order_id',$orderid)->delete();
        if($orderitems){
            //delete the temporary records as well
            $deleteitems=TemporaryUssd::where('order_id',$orderid)->where('session_id',$sessionid)->delete(); 
            if($deleteitems){
                //now delete the order
                 $del_order=inputOrders::where('trader_id',$traderid)->where('approved',0)->delete();
                 if($del_order){
                     $status=1;
                 }
                 else{
                     $status=0;
                 }
            }
        }
    }
    //create the initial order
    public function createMainOrder($user){
        //add the trader
        $trader_id=self::getTrader($user);
        //check if the trader has an order which is not complete
        $checkorder=inputOrders::where('trader_id',$trader_id)->where('approved',0)->first();
        if($checkorder){
            $mainorder=$checkorder['id'];
        }
        else
        {
             $order['trader_id']=$trader_id;
             $order['approved']=0;
             $order['total']=0.00;
             $mainorder=inputOrders::create($order)->id;
             
             
        }
         return $mainorder;
    }
    //add an item associated with an order of the trader
    public function orderItem($sessionId,$orderid,$inputitemid,$trader,$quantity,$eachprice){
        
        $orderitem['approval']=0;
        $orderitem['order_id']=$orderid;
        $orderitem['directed_to']=$trader;
        $orderitem['farmer_id']=1;
        $orderitem['input_item_id']=$inputitemid;
        $orderitem['expected_date']=date('Y-m-d H:i:s');
        $orderitem['financing']="wallet";
        $orderitem['description']="n/a";
        $orderitem['quantity']=$quantity;
        $orderitem['price']=$quantity*$eachprice;
       
        //check if the items exist
             $order=inputOrderItems::create($orderitem);
            
            if($order){
                return true;
            }
            else{
                return false;
            } 
        
       
       
    }
    //get input items
    public function reOrder($userid,$newphone,$newlevel,$sessionId){
    
        
        $cats=self::getInputItems($userid);
                          if(!empty($cats)){
                                //display the input available
                               $response="CON Select an Input\n";
                               foreach($cats as $cat){
                                 $response.=$cat['id'].". ".$cat['name']."(@Kshs. ".$cat['price_per_unit'].") \n";  
                               }
                                $response.="0. Return to Main Menu \n"; 
                               //update the selection to level2
                               $newlevel=2;
                               self::updateSession($newphone,$newlevel,$sessionId,$userid);
                               
                               self::getResponse($response);
                           }
                           else{
                               $response="CON You don't have Input Items\n";
                               $response.="0. Return to Main Menu \n"; 
                                 //update the level to 1
                                $newlevel=2;
                                self::updateSession($newphone,$newlevel,$sessionId,$userid);
                                
                                self::getResponse($response);
                           }
    }
    
    //get user
    public function getUser($phone){
        
      $newphone="0".substr($phone,4);
      $user = User::where('phone', $newphone)->first();
      
      return $user;
    }
    //show the main menu
    public function mainMenu($user){
        
        $response="CON Welcome ".$user." to Twalisha Agrodealer POS.Select to proceed \n";
        $response.="1. Place Farmer order \n";
        $response.="2. Account Balance \n";
        $response.="3. Logout \n";
        
        self::getResponse($response);
    }
    //get the customer menu
     public function customermainMenu($user){
        
        $response="CON Welcome ".$user." to Twalisha Farmer POS.Select to proceed \n";
        $response.="1. Complete order \n";
        $response.="2. Account Balance \n";
        $response.="3. Logout \n";
        
        self::getResponse($response);
    }
   
    public function user_is_starting($text)
    {
        if (strlen($text) > 0) {
            return FALSE;
        } else {
            return TRUE;
        }
    }
    
    public function getResponse($response){
        
        header('Content-type: text/plain');
        echo $response;
        
    }
    
    public function stop_start_service(){
     $response="END You are not registered for the service \n";
     self::getResponse($response);
        
    }
    //farmer session level
    public function updateFarmerSession($phone,$sessionlevel,$sessionid,$userid){
        //check if the session exists
        $session=FarmerSessionLevel::where('phone',$phone)->first();
        
        if($session){
              FarmerSessionLevel::where('phone',$phone)->update(['session_id'=>$sessionid,'level'=>$sessionlevel]);
        }
        else{
              FarmerSessionLevel::create(['session_id'=>$sessionid,'level'=>$sessionlevel,'phone'=>$phone,'farmer_id'=>$userid]);
        }
      
    }
    
    public function updateSession($phone,$sessionlevel,$sessionid,$userid){
        
       $session=SessionLevel::where('phone',$phone)->first();
        
        if($session){
              SessionLevel::where('phone',$phone)->update(['session_id'=>$sessionid,'level'=>$sessionlevel]);
        }
        else{
              SessionLevel::create(['session_id'=>$sessionid,'level'=>$sessionlevel,'phone'=>$phone,'farmer_id'=>$userid]);
        }
    }
    
    //return the user access levels
    public function getLevels($phone){
        
       $level=SessionLevel::where('phone',$phone)->first();
       
       return $level['level'];
    }
    
    //returns the farmer's access levels
    public function getFarmerLevels($phone){
        
        $farmerlevel=FarmerSessionLevel::where('phone',$phone)->first();
       
        return $farmerlevel['level'];
    }
    
    //get input categories
    public function getCategories(){
       
        //get the inputs category
        $inputcategory=InputCategory::all();
        
        $categoryarray=array();
        
        foreach($inputcategory as $input){
            array_push($categoryarray,$input->id.". ".$input->name);
        }
        
        return $categoryarray;
    }
    //get the input items of the agrodealer
    public function getInputItems($user){
        
        //get trader
        $trader=self::getTrader($user);
        //get the inputs
           // $inputs=Input::all();
        //get all the inputs items
        $inputitems=InputItem::where('trader_id',$trader)->get();
        $inputitemss=array();
        foreach($inputitems as $inputitem){
         
                  //return the item
                  $returneditem['id']=$inputitem->id;
                  $returneditem['name']=$inputitem->name;
                  $returneditem['price']=$inputitem->price_per_unit;
                  //push the item into the array
                  array_push($inputitemss,$inputitem);
             
        }
        
        return $inputitemss;
        
    }
    //get trader
    public function getTrader($user){
        $trader=Trader::where('user_id',$user)->where('type_id',4)->first();
        return $trader['id'];
    }
    //get Traderidbalance
    public function getTrader2($user){
        $trader=Trader::where('user_id',$user)->where('type_id',4)->first();
       
        return $trader['user_id'];
    }
    
    public function getFarmerTrader($user){
        //$trader=Trader::where('user_id',$user)->where('type_id',1)->first();
        $trader=FarmerProfile::where('user_id',$user)->first();
        return $trader['user_id'];
    }
    
    //get latestvalue
    public function currentText($text){
        
            //get the latest text to consider
            $message = '';
           
            $result = explode("*", $text);
            
            if (empty($result)) {
                $message = $text;
            }else {
                end($result);
                // move the internal pointer to the end of the array
                $message = current($result);
                
            }
            
            return $message;
            
    }
    
    
}
