<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Trader;
use App\User;
use App\TraderMember;
use App\Vehicle;
use App\Driver;
use App\inputOrders;
use App\inputOrderItems;
use App\ProduceItem;
use App\ProduceOrder;
use App\ProduceOrderItem;
use App\Delivery;
use App\DeliveryRequests;
use Auth;
use App\DeliveryAcknowledgement;

class TransitController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
	{
	    $this->middleware('auth');
	}
    public function index()
    {
        //
        
        $user_id = Auth::user()->id;
        $user = User::findOrFail($user_id);
        $trader = $user->getRelatedTrader();
        $vehicles = Vehicle::where('trader_id',$trader->id)->get();
        $drivers = Driver::where('trader_id',$trader->id)->pluck('id');
        $deliveries = Delivery::whereIn('driver_id',$drivers)->where('status',1)->get();
        
                //dd($deliveries);  
        return view('on-transit.index', compact('deliveries','vehicles','drivers'))->with('i');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
