<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\TrainingModule;
use App\Trader;

class TrainingModuleController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */


    public function index(Request $request)
    {
        $trainingmodules = TrainingModule::paginate(env('LIST_SIZE', 10));
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('trainingmodules.index', compact('trainingmodules','dashboard'));
    }


    public function store(Request $request)
    {
     
        $user = new TrainingModule();     
        $user->module_name = $request->module_name;
        $user->status = '1';
 
        $user->save();  
        return back()->with('success','Added succesfully');
    }

    
    public function update(Request $request)
    {
        $user = TrainingModule::findOrFail($request->trainingmodule_id);   
        $user->module_name = $request->module_name;
        $user->status = '1';
 
        $user->save();  
        return back()->with('success','Updated succesfully');
    }


    public function destroy($id )
    {
        
       // return $request->id['shop_id'];
     ///$request;     return Favourite::find($id)->delete();
        $user = TrainingModule::findOrFail($id);
        $user->delete();
        return back()->with('success','Deleted succesfully');
    }



}
