<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Trainingstopics;
use App\TrainingModule;
use App\Trader;
use App\TraderMember;
use Auth;
use App\Chat;
use DB;
use App\County;
use App\User;   
use App\Expert_Audios;
use App\Exports\MapExport;
use EloquentBuilder;
use App\Charts\RegionChart;
use Log;
use App\Http\Resources\County as CountyResource;
class TrainingController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth',['except' => ['btfarmermap','getCounties']]);
	}
    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */


    public function index(Request $request)
    {
        $trainingtopics = Trainingstopics::with('tainingsmodule')->paginate(env('LIST_SIZE', 10));
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('trainings.index', compact('trainingtopics','dashboard'));
    }
    
    public function btfarmermap()
    {
        

        return view('btcottonLocation.map');

    }


    public function chartscript(Request $request)
    {
        $trainingtopics = Trainingstopics::with('tainingsmodule')->paginate(env('LIST_SIZE', 10));
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        $selectedtrader=Trainingstopics::with('tainingsmodule')->paginate(env('LIST_SIZE', 10));
        return view('vuexy.chart.index', compact('trainingtopics','dashboard','selectedtrader'));
    }
    
    public function getCounties(){
        //get all the trader counties
        $traders = Trader::distinct('county_id')->pluck('county_id');
        
        $counties = County::whereIn('id',$traders)->orderBy('id', 'DESC')->get();
      
        $geoJSONdata = $counties->map(function ($county) {
            return [
                'type'       => 'Feature',
                'properties' => new CountyResource($county),
                'geometry'   => [
                    'type'        => 'Point',
                    'coordinates' => [
                        $county->longitude,
                        $county->latitude,
                    ],
                ],
            ];
        });

        return response()->json([
            'type'     => 'FeatureCollection',
            'features' => $geoJSONdata,
        ]);

    }


    
    public function module_names()
    {
        //  $shops = TrainingModule::all();
          $shops = TrainingModule::all();
        return $shops;
    }

    

    public function store(Request $request)
    {
     
        $user = new Trainingstopics();       
        $user->trainingmodule_id = '1';
        $user->text = $request->text;
        $user->video_link = $request->video_link;
        $user->status = $request->status;
        $user->posted_by = auth()->user()->fullname;
    
 
        $user->save();  
        return back()->with('success','Added succesfully');
    }

    
    public function update(Request $request)
    {
        $user = Trainingstopics::findOrFail($request->trainingtopic_id);   
        $user->trainingmodule_id = '1';
        $user->text = $request->text;
        $user->video_link = $request->video_link;
        $user->status = $request->status;
        $user->posted_by = auth()->user()->fullname;
 
        $user->save();  
        return back()->with('success','Updated succesfully');
    }


    public function destroy($id )
    {

        
       // return $request->id['shop_id'];
       // return $request;     return Favourite::find($id)->delete();
        $user = Trainingstopics::findOrFail( $id );
        $user->delete();
        return back()->with('success','Deleted succesfully');
    }

public function ChatMain($catid){
        $user=Auth::user()->id;
        //get the related chat for this expert
        $expert_chats=Chat::where('expert_id',$user)->get();
        $categoryname = DB::table('trading_chat_categories')->where('id',$catid)->get();
        $catname=$categoryname[0]->name;
         //get the last farmerid
        $getlatestfarmerid=Chat::where('role','=','agent')->orderby('id','desc')->get();
        $lastfarmerid= $getlatestfarmerid[0]->farmer_id;
        $farmerorganisationid=$getlatestfarmerid[0]->farmer_org_id;
        //get the farmer ids
        $farmers=User::whereIn('id',$expert_chats->pluck('farmer_id'))->get();

    


        $people =$farmers;
        //get the 
        return view('trainings.chat_main',compact('people','expert_chats','catid','lastfarmerid','farmerorganisationid','catname'));
    }
    public function testChat(){
        $user=Auth::user()->id;
        //get the related chat for this expert
        $expert_chats=Chat::where('expert_id',$user)->get();
        $categoryname = DB::table('trading_chat_categories')->where('id','1')->get();
        $catname=$categoryname[0]->name;
         //get the last farmerid
        $getlatestfarmerid=Chat::where('role','=','agent')->orderby('id','desc')->get();
        $lastfarmerid= $getlatestfarmerid[0]->farmer_id;
        $farmerorganisationid=$getlatestfarmerid[0]->farmer_org_id;
        //get the farmer ids
        $farmers=User::whereIn('id',$expert_chats->pluck('farmer_id'))->get();

    


        $people =$farmers;
        //get the 
        return view('trainings.chat_index',compact('people','expert_chats','catid','lastfarmerid','farmerorganisationid','catname'));
    }
    
    
    public function getLastestTest(){
       $getlatestfarmerid=$chatcategories =DB::table('trading_chat_categories')->where('id','1')->get();
       return $getlatestfarmerid[0]->name;
    
    }

    public function testChat2(){       

        return view('trainings.chat_index2');
    } 

    public function getAllChat(){
        $user=Auth::user()->id;
        //get the related chat for this expert
        $expert_chats=Chat::where('expert_id',$user)->get();
        //get the farmer ids
        $farmers=User::whereIn('id',$expert_chats->pluck('farmer_id'))->get();

    


        $people =$farmers;

        $chat_data['expert_chats'] =$expert_chats;
        $chat_data['farmers'] =$people;

        return $chat_data;

    }
    public function sendMessageData(Request $request){
        $message=$request->message;
        //get the farmer organisation of the the requested farmerid
        $org=TraderMember::where('user_id',$request->farmer_id)->first();
       $chat= Chat::create(['expert_id' =>$request->expert_id,
                             'farmer_id'=>$request->farmer_id,
                             'farmer_org_id'=>$org->trader_id,
                             'message'=>$message,
                             'message_type'=>'text',
                             'status'=>1,
                             'chat_to'=>$request->farmer_id,
                             'chat_from'=>$request->expert_id
                            ]);

        $saved_data =Chat::where('id',$chat->id)->first();

        Log::info($request->all()); 
        return response()->json($request->all());
    }

    public function getChatData(){
        $user=Auth::user()->id;
        //get the related chat for this expert
        $expert_chats=Chat::where('expert_id',$user)->get();
        //get the farmer ids
        $farmers=User::whereIn('id',$expert_chats->pluck('farmer_id'))->get();
        $people =$farmers;

        $all_data['people']=$people;
        $all_data['chats']=$expert_chats;
        //get the 
        return response()->json($all_data);
    }
    
         public function storeChat(Request $request){

       
        try{
            
            $appurl = "http://btcotton.spin.mobisky.biz";
            //return $appurl;
            if($request->message=='' && !empty($request->file('attachments'))){

                $chat_id_array=[];
                $mime_type="";  
                $filename="";            
                if ($request->hasfile('attachments')) {

                    foreach($request->file('attachments') as $file){
                        
                        $destinationPath = 'public/chatfiles/'; // upload path
                        $file_name = date('YmdHis') . "." . $file->getClientOriginalExtension();
                        $filename=$file_name;
                        $mime_type=$file->getClientMimeType();                        

                        $file->move($destinationPath, $file_name);
                        $file_path =  $appurl.'/'.'public/'.$destinationPath.$file_name;

                        $chat = new Chat();
                        $chat->farmer_id = $request->farmer_id;
                        $chat->farmer_org_id = $request->farmer_org_id;
                        $chat->message = '';
                        $chat->chat_category= $request ->category_id;
                        $chat->expert_id =$request->farmer_org_id;
                        $chat->file_url =$file_path;
                        $chat->mime_type=$mime_type;
                        $chat->message_type='file';
                        $chat->file_name=$filename;
                        $chat->role=$request->role;
                        
                        $chat->status =1; 
                        $chat->save();

                        //get the id
                        $chat_id = $chat->id;
                        array_push($chat_id_array,$chat_id);
                        
                  
                    }
                
                }
                //get the details of the chats
               $chat_details = Chat::whereIn('id',$chat_id_array)->get();
            
               $chat_simple =[];

               foreach($chat_details as $chat_detail){
                   $chat_id=$chat_detail->id;
                   $message=$chat_detail->message;
                   $role =$chat_detail->role;

                   $attachments = (Object)[
                    'file_url'=>$chat->file_url,
                    'mime'=>$mime_type,
                    'filename'=>$filename

                   ];

                   $senderid= $chat_detail->farmer_id;
                   $sender_details = User::where('id',$senderid)->first();
                  
                   $sender = (Object)[
                    'id'=>$senderid,
                    'name'=>$sender_details['firstname'].' '.$sender_details['lastname'],
                    'avatar'=>$sender_details['picture_uri'],
                   ];

                   $receiverid= $chat_detail->expert_id;
                   $receiver_details = User::where('id',$receiverid)->first();

                   $receiver = (Object)[
                    'id'=>$receiverid,
                    'name'=>$receiver_details['firstname'].' '.$sender_details['lastname'],
                    'avatar'=>$receiver_details['picture_uri'],
                   ];
                   $created_at = $chat_detail->created_at;
                   
                   $complete_chat_object = (Object)[
                    'id'=>$chat_id,
                    'category_id'=>$chat_detail->chat_category,
                    'message'=>$message,
                    'attachments'=>array($attachments),
                    'sender'=>$sender,
                    'receiver'=>$receiver,
                    'role'=>$role,
                    'created_at'=>$created_at
                   ];
                    
                   array_push($chat_simple,$complete_chat_object);
               }
                
               //return with the details
               return response()->json(["success"=>true,"message"=>$chat_simple]);


            }
            
            elseif($request->message!='' && empty($request->file('attachments'))){
                $chat_id_array=[];

                $chat = new Chat();
                $chat->farmer_id = $request->farmer_id;
                $chat->farmer_org_id = $request->farmer_org_id;
                $chat->message = $request->message;
                $chat->chat_category= $request ->category_id;
                $chat->expert_id =$request->farmer_org_id;
                $chat->file_url ='';
                $chat->mime_type='';
                $chat->file_name='';
                $chat->message_type='text';
                $chat->role =$request->role;
                $chat->status =1;
                $chat->save();

                //get the id
                $chat_id = $chat->id;
                array_push($chat_id_array,$chat_id);

                  //get the details of the chats
               $chat_details = Chat::whereIn('id',$chat_id_array)->get();
            
               $chat_simple =[];

               foreach($chat_details as $chat_detail){
                   $chat_id=$chat_detail->id;
                   $message=$chat_detail->message;
                   $role =$chat_detail->role;

                   $attachments = (Object)[
                    'file_url'=>$chat->file_url,
                    'mime'=>'',
                    'filename'=>'',

                   ];

                   $senderid= $chat_detail->farmer_id;
                   $sender_details = User::where('id',$senderid)->first();

                   $sender = (Object)[
                    'id'=>$senderid,
                     'name'=>$sender_details['firstname'].' '.$sender_details['lastname'],
                    'avatar'=>$sender_details['picture_uri'],
                   ];

                   $receiverid= $chat_detail->expert_id;
                   $receiver_details = User::where('id',$receiverid)->first();

                   $receiver = (Object)[
                    'id'=>$receiverid,
                    'name'=>$receiver_details['firstname'].' '.$sender_details['lastname'],
                    'avatar'=>$receiver_details['picture_uri'],
                   ];
                   $created_at = $chat_detail->created_at;
                   
                    //was here
                   
                    if($chat_detail->file_name !=""){
                        $complete_chat_object = (Object)[
                    'id'=>$chat_id,
                    'category_id'=>$chat_detail->chat_category,
                    'message'=>$message,
                    'attachments'=>array($attachments),
                    'sender'=>$sender,
                    'receiver'=>$receiver,
                    'created_at'=>$created_at,
                    'role'=>$role
                    ];
                    
                       array_push($chat_simple,$complete_chat_object);  
                       
                    }
                    else if($chat_detail->file_name==""){
                             $complete_chat_object = (Object)[
                    'id'=>$chat_id,
                    'category_id'=>$chat_detail->chat_category,
                    'message'=>$message,
                    'attachments'=>array(),
                    'sender'=>$sender,
                    'receiver'=>$receiver,
                    'created_at'=>$created_at,
                    'role'=>$role
                    ];
                       array_push($chat_simple,$complete_chat_object);  
                    }
                  
               }
                
               //return with the details
               return response()->json(["success"=>true,"message"=>$chat_simple]);



             
                return response()->json(["success"=>true,"message"=>"chat saved"]);

            }
            elseif($request->message!='' && !empty($request->file('attachments'))){
                
                $chat_id_array=[];
                $mime_type="";  
                $filename="";      

                if ($request->hasfile('attachments')) {

                    foreach($request->file('attachments') as $file){
    
                        $destinationPath = 'publi/chatfiles/'; // upload path
                        $file_name = date('YmdHis') . "." . $file->getClientOriginalExtension();
                        $filename=$file_name;
                        $mime_type=$file->getClientMimeType(); 
                        $file->move($destinationPath, $file_name);
                        $file_path =  $appurl.'/'.$destinationPath.$file_name;

                       

                        $chat = new Chat();
                        
                        $chat->farmer_id = $request->farmer_id;
                        $chat->farmer_org_id = $request->farmer_org_id;
                        $chat->message = $request->message;
                        $chat->expert_id =$request->farmer_org_id;
                        $chat->chat_category= $request ->category_id;
                        $chat->file_url =$file_path;
                        $chat->mime_type=$mime_type;
                        $chat->message_type='text_with_file';
                        $chat->status =1;
                        
                        $chat->file_name=$filename;
                        $chat->role =$request->role;

                        $chat->save();

                         //get the id
                         $chat_id = $chat->id;
                         array_push($chat_id_array,$chat_id);
                    }
                
                }
                 //get the details of the chats
               $chat_details = Chat::whereIn('id',$chat_id_array)->get();
            
               $chat_simple =[];

               foreach($chat_details as $chat_detail){
                   $chat_id=$chat_detail->id;
                   $message=$chat_detail->message;
                   $role=$chat_detail->role;

                   $attachments = (Object)[
                    'file_url'=>$chat->file_url,
                    'mime'=>$mime_type,
                    'filename'=>$filename,
                   ];

                   $senderid= $chat_detail->farmer_id;
                   $sender_details = User::where('id',$senderid)->first();

                   $sender = (Object)[
                    'id'=>$senderid,
                    'name'=>$sender_details['firstname'].' '.$sender_details['lastname'],
                    'avatar'=>$sender_details['picture_uri'],
                   ];

                   $receiverid= $chat_detail->expert_id;
                   $receiver_details = User::where('id',$receiverid)->first();

                   $receiver = (Object)[
                    'id'=>$receiverid,
                    'name'=>$receiver_details['firstname'].' '.$sender_details['lastname'],
                    'avatar'=>$receiver_details['picture_uri'],
                   ];
                   $created_at = $chat_detail->created_at;
                   
                   $complete_chat_object = (Object)[
                    'id'=>$chat_id,
                    'category_id'=>$chat_detail->chat_category,
                    'message'=>$message,
                    'attachments'=>array($attachments),
                    'sender'=>$sender,
                    'receiver'=>$receiver,
                    'created_at'=>$created_at,
                    'role'=>$role
                   ];

                   array_push($chat_simple,$complete_chat_object);
               }
                
               //return with the details
               return response()->json(["success"=>true,"message"=>$chat_simple]);
            }
        }
        catch(Exception $e)
        {
            return response()->json(["success"=>false,"message"=>"chat failed"]);
        }
        

    }




}
