<?php

namespace App\Http\Controllers;
use App\Libs\Mobisky;
use DateTime;
use EloquentBuilder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Exports\TradersExport;
use App\Http\Controllers\Controller;
use App\Trader;
use App\TraderType;
use App\TraderContract;
use App\ContractDetail;
use App\BuyerContractDetail;
use App\Produce;
use App\ProduceItem;
use App\ProduceUnit;
use App\Region;
use App\County;
use App\User;
use App\TraderContact;
use App\TraderMember;
use App\TraderNetwork;
use App\TraderSetting;
use App\Input;
use App\InputItem;
use App\InputUnit;
use DB;
use Log;

class TradersController extends Controller
{
    public function __construct() {
	    $this->middleware('auth',['except' => ['showRegistrationForm','storeNoAuthTrader','store','register_user_no_organization','storeNonOrganization','counties_names','getregions_names','storeUserNonOrganization']]);
    }

    public function export(Request $request) {
        return new TradersExport($request);
    }

    /**
     * Display a listing of the traders.
     *
     * @return Illuminate\View\View
     */
    public function index(Request $request)
    {
        $traders = EloquentBuilder::to(Trader::class, $request->all())->where('status','=',1)->get();
        $trader_types = TraderType::all();
        $regions = Region::all();
        $counties = County::all();
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();

        return view('traders.index', compact('traders', 'trader_types', 'regions', 'counties','dashboard'));
    }
    public function agentFos(Request $request)
    {
        $agent = Auth::user()->userAgent;
        $trader = [];
        foreach($agent as $traderobj)
        {
            $traderid = $traderobj->trader_id;
            array_push($trader,$traderid);
        }
        //get the traders from the tradermembers table
        $all_traders= TraderMember::where('user_id',$trader)->get()->pluck('trader_id');
       
        $traders = Trader::whereIn('id',$all_traders)->get();
        

        return view('traders.agents-fos', compact('traders'));
    }

    /**
     * Show the form for creating a new trader.
     *
     * @return Illuminate\View\View
     */

        public function linkexpert($id) {
            
        $trader = Trader::findOrFail($id);
        // $tradertypes = TraderType::pluck('name','id')->all();
        $trader_types = TraderType::all();
        $tradertypes = TraderType::all();
        $farmerorganization = Trader::where('type_id','1')->get();
        $regions = Region::all();
        $counties = County::all();
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();

        return view('traders.link', compact('dashboard','farmerorganization','trader','trader_types','tradertypes','regions','counties'));
     }



     public function update_user_org(Request $request)
    {
       
        $user = User::findOrFail($request->type_id);
        $user->trader_id = $request->trader_id;
        $user->active =1;
        $user->save();

        $user = new TraderMember();
        $user->user_id = $request->type_id;
        $user->trader_id = $request->trader_id;
        $user->type="farmer";
        $user->save();


        $traders = User::where('trader_id',Null)->get();
        $trader_types = TraderType::all();
        $regions = Region::all();
        $counties = County::all();
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
   
        return view('traders.no_assigned_organization', compact('traders', 'trader_types', 'regions', 'counties','dashboard'));
 
    }



     public function linkFarmerOrg($id) {
     
        $trader = User::findOrFail($id);
          
        // $tradertypes = TraderType::pluck('name','id')->all();
        $trader_types= Trader::where('type_id',1)->get();
        $tradertypes = TraderType::all();
        $farmerorganization = Trader::where('type_id','1')->get();
        $regions = Region::all();
        $counties = County::all();
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        
        

        return view('traders.link_farmer_org', compact('dashboard','farmerorganization','trader','trader_types','tradertypes','regions','counties'));
     }




    public function counties_names()
    {
        $shops = DB::table('trading_counties')->get();
        return $shops;
    }

    public function getregions_names()
    {
        $shops = DB::table('trading_regions')->get();
        return $shops;
    }


   public function organisation_names()
    {
        $shops = DB::table('trading_traders')->get();
        return $shops;
    }

   public function orgName()
    {
        $shops = DB::table('trading_trader_type')->get();
        return $shops;
    }


   public function store_organization(Request $request)
    {
     
        $user = new TraderMember();
        $user->trader_id = $request->trader_id;
        $user->user_id = $request->user_id;
        $user->active = '1';
        $user->type ='agent';
        
        $checkexistence = TraderMember::where('trader_id',$request->trader_id)->where('user_id',$request->user_id)->get();
        
        if(empty($checkexistence->toArray())){
            
            $user->save();
            return back()->with('success','Added succesfully');
        }
        elseif(!empty($checkexistence->toArray())){
            
            return back()->with('success','Link to FO exists!');
        }
           
       
    }

    public function create(Request $request)
    {
        $tradertypes = TraderType::pluck('name','id')->all();
        //$regions = Region::pluck('name','id')->all();
        $trader_types = TraderType::all();
        $regions = Region::all();

        // if($request->ajax()){
        //     $return_array = compact('tradertypes','regions','trader_types');
        //     return json_encode($return_array);
        // }

        return view('traders.create', compact('tradertypes','regions','trader_types'));
    }

    /**
     * Store a new trader in the storage.
     *
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        //create the use account and get the id
        $user_id = $this->storeUser($request);
        if($user_id) {
            $trader = $this->storeTrader($user_id, $request);
            if($trader) {
                if(Auth::user() == null) {
                    return redirect()->route('show-login-form')
                        ->with('success_message', 'Trader was successfully created.');
                } else {
                    return redirect()->route('traders.index')
                        ->with('success_message', 'Trader was successfully created.');
                }
            }
        } else {
            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        }
    }

    public function storeUser(Request $request) {
        $request->validate([            
            'organisation_name' => 'required',
            'email'=>'required',
            'user_email'=>'required',
            'phone' => 'required', 
            'postal_address'=>'required',
            'user_username' => 'required', 
            'user_password'=>'required',            
            'user_firstname' => 'required', 
            'user_lastname'=>'required',
            'user_phone'=>'required',
        ]);
        //set the username and the password
        $admin_user['username'] = $request->user_username;
        $admin_user['username_canonical'] = $request->user_username;
        $admin_user['password'] = Hash::make($request->user_password);
        $admin_user['firstname'] = $request->user_firstname;
        $admin_user['lastname'] = $request->user_lastname;
        $admin_user['email'] = $request->user_email;
        $admin_user['email_canonical'] = $request->user_email;
        $admin_user['phone'] = $request->user_phone;
        $admin_user['locked'] = 0;
        $admin_user['enabled'] = 1;
        $admin_user['user_id'] = 0;
        $admin_user['expired'] = 0;
        $admin_user['address'] = null;
        $admin_user['credentials_expired'] = 0;
        $admin_user['salt'] = Hash::make("password");
        $admin_user['roles'] = serialize([]);
        $admin_user['registration_date'] = new DateTime();
        $admin_user['active'] = 0;
        $admin_user['status'] = 6;
        $admin_user['official_code'] = 'anonymous';
        $admin_user['language'] = 'english';
       
       //Send Message
       // function send_trader_reg_sms($phone);  
        // $result = (new SmsController)->send_trader_reg_sms($phone);
        $phone = $request->user_phone;
        $smsobject=new Mobisky('demo1','mob1d3m01');

        $phn= $phone;
  
        $sms='Thank you for registering';
       
        $textstatus=$smsobject->sendMessage($phn,$sms);
        Log::info($textstatus);
            //create the use account and get the id
        $user_id = User::create($admin_user)->id;



        if($user_id) return $user_id;
        else return false;
    }


    public function storeNonOrganization(Request $request)
    {
        //create the use account and get the id
        $user_id = $this->storeUserNonOrganization($request);
        if($user_id) {
            $trader = $this->storeTrader($user_id, $request);
            if($trader) {
                if(Auth::user() == null) {
                    return redirect()->route('show-login-form')
                        ->with('success_message', 'Trader was successfully created.');
                } else {
                    return redirect()->route('traders.index')
                        ->with('success_message', 'Trader was successfully created.');
                }
            }
        } else {
            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        }
    }

   public function storeUserNonOrganization(Request $request) {
 
        //set the username and the password
        $admin_user['username'] = $request->username;
        $admin_user['username_canonical'] = $request->username;
        $admin_user['password'] = Hash::make($request->password);
        $admin_user['firstname'] = $request->firstname;
        $admin_user['lastname'] = $request->lastname;
        $admin_user['email'] = $request->email;
        $admin_user['email_canonical'] = $request->email;
        $admin_user['phone'] = $request->phone;
        $admin_user['locked'] = 0;
        $admin_user['enabled'] = 1;
        $admin_user['user_id'] = 0;
        $admin_user['expired'] = 0;
        $admin_user['address'] = null;
        $admin_user['credentials_expired'] = 0;
        $admin_user['salt'] = Hash::make("password");
        $admin_user['roles'] = serialize([]);
        $admin_user['registration_date'] = new DateTime();
        $admin_user['active'] = 0;
        $admin_user['status'] = 6;
        $admin_user['official_code'] = 'anonymous';
        $admin_user['language'] = 'english';
        $admin_user['region'] = $request->region;
        $admin_user['county_id'] = $request->county_id;
        $admin_user['ward'] = $request->ward;
       
       //Send Message
       // function send_trader_reg_sms($phone);  
        // $result = (new SmsController)->send_trader_reg_sms($phone);
        $phone = $request->user_phone;
        $smsobject=new Mobisky('demo1','mob1d3m01');

        $phn= $phone;
  
        $sms='Thank you for registering';
       
        $textstatus=$smsobject->sendMessage($phn,$sms);
        Log::info($textstatus);
            //create the use account and get the id
        $user_id = User::create($admin_user)->id;
   
        
         
        return redirect()->back()
        ->with('success','Registered Succesfully.');
     
        if($user_id) return $user_id;
        else return false;
    }








    public function storeTrader($user_id, $request) {
        //create the corresponding organization details
        $trader['organisation_name'] = $request->organisation_name;
        $trader['type_id'] = $request->type_id;
        // $trader['preferred_regions'] = serialize($request->preferred_regions);
        $trader['region_id'] = $request->region_id;
        $trader['county_id'] = $request->county_id;
        $trader['ward'] = $request->ward;
        $trader['email'] = $request->email;
        $trader['buyer_type'] = $request->buyer_type;
        $trader['phone'] = $request->phone;
        $trader['postal_address'] = $request->postal_address;
        $trader['user_id'] = $user_id;
        $trader['status'] = 0;

       

        //store the data of the trader and get the trader id
        $new_trader = Trader::create($trader);
        if($new_trader) return $new_trader;
        else return false;
    }

    /**
     * Display the specified trader.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
 public function show(Request $request, $id) {
        $trader = Trader::findOrFail($id)->load('trader_type');
        $traderin = TraderMember::where('trader_id', $id)->get()->pluck('user_id');
        $trader_contacts = TraderContact::where('trader_id', $id)->get();
        $trader_members = TraderMember::where('trader_id', $id)->get()->load('user');
        $trader_contracts = TraderContract::where('trader_id', $id)->get();
        $trader_networks = TraderNetwork::where('trader_id', $id)->get()->load('trader', 'region', 'county', 'agrodealer');
        $produce_items = ProduceItem::where('trader_id', $id)->get();
        $input_items = InputItem::where('trader_id', $id)->get();
        $traders = EloquentBuilder::to(Trader::class, $request->all())->where('status','=',1)->where('type_id','=',1)->wherein('user_id',$traderin)->get();

        $produces = Produce::all();
        $inputs = Input::all();
        $produce_units = ProduceUnit::all();
        $input_units = InputUnit::all();
        $regions = Region::all();
        $counties = County::all();
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
       
       
        $trader_types = TraderType::all();
    $tradertypes = TraderType::all();
    $farmerorganization = Trader::where('type_id','1')->get();

       
        return view('traders.show', compact('traders','farmerorganization','trader_types','tradertypes','dashboard','trader_members', 'trader_contracts', 'trader_contacts', 'trader_networks', 'produce_items', 'input_items', 'trader', 'produces', 'inputs', 'produce_units', 'input_units', 'regions', 'counties'));
    }



    public function farmerno_organizarion(Request $request) {
        $traders = User::where('trader_id',Null)->get();
        $trader_types = TraderType::all();
        $regions = Region::all();
        $counties = County::all();
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();

        return view('traders.no_assigned_organization', compact('traders', 'trader_types', 'regions', 'counties','dashboard'));
          }





    public function profile()
    {
        $user_id = Auth::user()->id;
        $user = User::findOrFail($user_id);

        $trader = $user->getRelatedTrader();
        $id = $trader->id;

        $trader = Trader::findOrFail($id)->load('trader_type');
        $trader_members = TraderMember::where('trader_id', $id)->where('type','farmer')->get()->load('user');
        $trader_contracts = TraderContract::where('trader_id', $id)->get();
        $trader_contacts = TraderContact::where('trader_id', $id)->get();
        $produce_items = ProduceItem::where('trader_id', $id)->get();
        $trader_networks = TraderNetwork::where('trader_id', $id)->get()->load('trader', 'region', 'county', 'agrodealer');
        $input_items = InputItem::where('trader_id', $id)->get();

        $produces = Produce::all();
        $inputs = Input::all();
        $produce_units = ProduceUnit::all();
        $input_units = InputUnit::all();
        $regions = Region::all();
        $counties = County::all();
        $users = User::all();
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        // return view('traders.index', compact('trader_members', 'produce_items', 'input_items', 'trader_contracts', 'trader_contacts', 'trader', 'users', 'produces', 'inputs', 'produce_units', 'input_units'));
        return view('traders.profile', compact('dashboard','trader_members', 'trader_contracts', 'trader_contacts', 'trader_networks', 'produce_items', 'input_items', 'trader', 'users', 'produces', 'inputs', 'produce_units', 'input_units', 'regions', 'counties'));
    }

    /**
     * Show the form for editing the specified trader.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function edit($id)
    {
        $trader = Trader::findOrFail($id);
        // $tradertypes = TraderType::pluck('name','id')->all();
        $trader_types = TraderType::all();
        $tradertypes = TraderType::all();

        $regions = Region::all();
        $counties = County::all();

        return view('traders.edit', compact('trader','trader_types','tradertypes','regions','counties'));
    }

    /**
     * Update the specified trader in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        $updated_trader = $this->updateTrader($id, $request);
        if($updated_trader) {
            return redirect()->back()
                ->with('success_message', 'Trader updated successfully.');
        } else {
            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        }
    }

    public function updateTrader($id, $request) {
        //get the trader organisation data
        $data['organisation_name'] = $request->organisation_name;
        $data['type_id'] = $request->type_id;
        // $data['preferred_regions'] = serialize($request->preferred_regions);
        $data['region_id'] = $request->region_id;
        $data['county_id'] = $request->county_id;
        $data['ward'] = $request->ward;
        $data['buyer_type'] = $request->buyer_type;
        $data['email'] = $request->email;
        $data['phone'] = $request->phone;
        $data['status']=1;
        $data['postal_address'] = $request->postal_address;

        $trader = Trader::findOrFail($id);
        //get the userid of this account
        $user_id=$trader->user_id;
        User::where('id',$user_id)->update(['enabled'=>1,'active'=>1]);

        $updated_trader = $trader->update($data);

        if($updated_trader) return $updated_trader;
        else return false;
    }

    /**
     * Remove the specified trader from the storage.
     *
     * @param int $id
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        
        $trader = Trader::findOrFail($id);
        //get user_id in trader
        $admin_user = $trader->user_id;

        $user = User::where('id','=',$admin_user)->first();
        

        $deleted_user = $user->delete();

        if($deleted_user) {

            $deleted_trader = $trader->delete();
            if($deleted_trader) {
                //delete the admin_user
              
                    return redirect()->route('traders.index')
                        ->with('success_message', 'Trader Account was successfully deleted.');
                }
            
        }

        else {
            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        }
    }

    //show trader registration form
    public function showRegistrationForm() {
        
        $regions = DB::table('trading_regions')->get();
        $counties = DB::table('trading_counties')->get();
        $trader_types = DB::table('trading_trader_type')->get();
        return view('auth.register', compact('regions','counties','trader_types'));
    }


    //show trader registration form
    public function register_user_no_organization() {
        
        $regions = DB::table('trading_regions')->get();
        $counties = DB::table('trading_counties')->get();
        $trader_types = DB::table('trading_trader_type')->get();
        return view('auth.register_no_organization', compact('regions','counties','trader_types'));
    }
    


    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request\Request $request
     * @return array
     */
    /*protected function getData(Request $request)
    {
        $rules = [
            'organization_name' => 'nullable|string|min:0|max:255',
            'postal_address' => 'nullable|string|min:0|max:255',
            //'regions' => 'nullable|string|min:0|max:255',
            //'email' => 'required|string|min:0|max:255',
            //'phone' => 'required|string|min:0|max:255',
            postal_address' => 'nullable|string|min:0|max:255',
            'physical_address' => 'nullable|string|min:0|max:255',
            'contact_one_name' => 'nullable|string|min:0|max:255',
            'contact_one_email' => 'nullable|string|min:0|max:255',
            'contact_one_phone' => 'nullable|string|min:0|max:255',
            'contact_two_name' => 'nullable|string|min:0|max:255',
            'contact_two_email' => 'nullable|string|min:0|max:255',
            'contact_two_phone' => 'nullable|string|min:0|max:255',
            'contact_three_name' => 'nullable|string|min:0|max:255',
            'contact_three_email' => 'nullable|string|min:0|max:255',
            'contact_three_phone' => 'nullable|string|min:0|max:255',
            'tonnage_per_year' => 'nullable|numeric|min:-999999.99|max:999999.99',
            'special_terms' => 'nullable',
            'destination_markets' => 'nullable|string|min:0|max:255',
            'trader_type_id' => 'required',
            'region_id' => 'required',
            'latitude' => 'nullable|string|min:0|max:255',
            'longitude' => 'nullable|string|min:0|max:255',


        ];

        $data = $request->validate($rules);

        return $data;
    }*/

    //add contract for the trader
    public function addContract(Request $request){
        $tradercontract['trader_id']=$request->trader_id;
        $tradercontract['contract_name']=$request->contract_name;
        $tradercontract['tonnage']=$request->trader_tonnage;
        $tradercontract['produce']=$request->trader_produce;

        if( $request->hasFile('contractinput') )
        {
            $file = $request->file('contractinput');
            $destinationPath = public_path().'/trader-contracts';
            $fileName = $file->getClientOriginalName();
            $upload_success = $file->move($destinationPath, $fileName);
            $tradercontract['contract_file'] = $fileName;
        }
        //add the record to the model

        $contract=TraderContract::create($tradercontract);
        if($contract){
            return redirect()->route('traders.index')
            ->with('success_message', 'Trader Contract was successfully added.');

        }

    }

    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request)
    {
        if($request->id) {
            $trader_updated = $this->updateTrader($request->id, $request);
            if($trader_updated) {
                $trader = Trader::where('id', $request->id)->first();
                return response()->json($trader->load('user'));
            }

        } else {
            $user_id = $this->storeUser($request);
            if($user_id) {
                $trader = $this->storeTrader($user_id, $request);
                // TODO: Add User as TraderContact after registration
                return response()->json($trader->load('user', 'trader_type', 'region', 'county'));
            }
        }

        return response()->json(['errors'=> 'Unexpected error occurred while trying to process your request']);
    }

    //no auth store new trader
    public function storeNoAuthTrader(Request $request)
    {
        if($request->id) {
            $trader_updated = $this->updateTrader($request->id, $request);
            if($trader_updated) {
                $trader = Trader::where('id', $request->id)->first();
                return response()->json($trader->load('user'));
            }

        } else {
            $user_id = $this->storeUser($request);
            if($user_id) {
                $trader = $this->storeTrader($user_id, $request);
                // TODO: Add User as TraderContact after registration
                return response()->json($trader->load('user', 'trader_type', 'region', 'county'));
            }
        }

        return response()->json(['errors'=> 'Unexpected error occurred while trying to process your request']);
    }

    public function storeSettings(Request $request)
    {
        $settings = TraderSetting::updateOrCreate(
            ['id' => $request->id],
            ['trader_id' => $request->trader_id, 'locked' => $request->locked, 'credit_limit' => $request->credit_limit]
        );

        if($settings) {
            $notification = array(
                'message' => 'Organisation settings updated successfully!',
                'alert' => 'success', // success, error, info, warning
            );

            return response()->json(['settings' => $settings, 'notification' => $notification]);
        }

        return response()->json(['errors' => 'Organisation settings update failed.']);
    }

    /**
     * Show the form for editing the specified trader.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $trader = Trader::findOrFail($id);
        return response()->json($trader->load('user'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        //$trader = Trader::where('id', $id)->delete();
       
        
        $trader = Trader::findOrFail($id);
        //get user_id in trader
        $admin_user = $trader->user_id;

        $user = User::where('id','=',$admin_user)->first();
        

        $deleted_user = $user->delete();

        if($deleted_user) {

            $deleted_trader = $trader->delete();
            if($deleted_trader) {
                return response()->json($trader);

                  }
            
        }

        else {

            return response()->json($trader);

             }
    }

    public function getContractsAjax($id) {
        $trader = Trader::with('contracts')->findOrFail($id);

        if(isset($trader)) {
            $items = collect();
            $trader->each(function($q) use(&$items) {
                $items = $items->concat($q->contracts->load('produce','produce_unit'));
            });

            return response()->json($items);
        }

        return response()->json(['errors'=> 'No contract details found.']);
    }
    public function getItemsAjax($id) {
        $trader = Trader::with('inputitem')->findOrFail($id);

        if(isset($trader)) {
            $items = collect();
            $trader->each(function($q) use(&$items) {
                $items = $items->concat($q->inputitem->load('input','input_unit'));
            });

            return response()->json($items);
        }

        return response()->json(['errors'=> 'No contract details found.']);
    }


    //fosettings

    public function fosettings($id){
        $traderid=$id;
        $trader = Trader::findOrFail($id)->first();
        //retrieve the settings of this trader,if they dont exist initialize credit limit and lock to zero
        $fosettings= TraderSetting::where('trader_id',$id)->exists();
        $new_settings['locked']=0.00;
        $new_settings['trader_id']=$id;
        $new_settings['credit_limit']=0.00;
        $mysettings=array();
        if($fosettings){
            //return the record
            $mysettings= TraderSetting::where('trader_id',$id)->get();
        }
        else{
            //create the record with 0 values
         $new_fo_settings = TraderSetting::create($new_settings)->id;

         if($new_fo_settings){
           //return the record
           $mysettings= TraderSetting::where('trader_id',$new_fo_settings)->get();
         }
         else{
            //return the record
           $mysettings= TraderSetting::where('trader_id',$new_fo_settings)->get();
         }

        }

         return view('fo_settings.show', compact('mysettings','traderid','trader'));

    }

    public function savefolockedsettings(Request $request,$id){
        //update the locked property with new value
        $lockedrecord=TraderSetting::find($id);
        $lockedrecord->update(['locked'=>$request->locked]);
        //redirect back to the settings page
        return redirect('/fosettings'.'/'.$lockedrecord->trader_id)
        ->with('success_message', 'Lock Settings was successfully updated.');
    }
    public function savecreditlimitsettings(Request $request, $id){

         //update the locked property with new value
         $lockedrecord=TraderSetting::find($id);
         $lockedrecord->update(['credit_limit'=>$request->credit_limit]);
         //redirect back to the settings page
         return redirect('/fosettings'.'/'.$lockedrecord->trader_id)
         ->with('success_message', 'Credit Limit Settings was successfully updated.');
    }

    public function getAgroDealersAjax($id, Request $request) {
        $trader = Trader::findOrFail($id);
        if(isset($trader)) {
            if($request->type == 'last-mile') {
                $agrodealers = Trader::where('county_id', $request->location_id)->whereHas(
                    'trader_type', function($q) {
                        $q->where('name', 'Agrodealer');
                    }
                )->get();
            } elseif($request->type == 'regional') {
                $agrodealers = Trader::where('region_id', $request->location_id)->whereHas(
                    'trader_type', function($q) {
                        $q->where('name', 'Agrodealer');
                    }
                )->get();
            } else {
                $agrodealers = Trader::whereHas(
                    'trader_type', function($q) {
                        $q->where('name', 'Agrodealer');
                    }
                )->get();
            }

            return response()->json($agrodealers);
        }

        return response()->json(['errors'=> 'No agrodealers found.']);
    }

}
