<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\TraderType;
use App\Trader;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Exception;

class TraderTypeController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Display a listing of the trader-types.
     *
     * @return Illuminate\View\View
     */
    public function index(Request $request) {
        $trader_types = TraderType::paginate(env('LIST_SIZE', 10));
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();

        if($request->ajax()){
            $return_array = compact('trader_types');
            return json_encode($return_array);
        }

        return view('trader-types.index', compact('trader_types','dashboard'));
    }

    /**
     * Show the form for creating a new trader_type.
     *
     * @return Illuminate\View\View
     */
    public function create(Request $request)
    {
        $trader_types = TraderType::pluck('name','id')->all();

        if($request->ajax()){
					$return_array = compact('TraderTypes');
          return json_encode($return_array);
        }

        return view('trader-types.create', compact('trader_types'));
    }

    /**
     * Store a new trader_type in the storage.
     *
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
             $data = $this->getData($request);

            $trader_type=TraderType::create($data)->id;
            if($trader_type){
                    return redirect()->route('trader-types.index')
                    ->with('success_message', 'TraderTyepe was successfully added.');

                   // return response()->json($k);
                }
                else{
                    return back()->withInput()
                    ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);

                }

            //return response()->json($data);
    }

    /**
     * Display the specified trader_type.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function show($id)
    {
        $trader_type = TraderType::findOrFail($id);

        return view('trader-types.show', compact('trader_type'));
    }

    /**
     * Show the form for editing the specified trader_type.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function edit($id)
    {
        $trader_type = TraderType::findOrFail($id);

        return view('trader-types.edit', compact('trader_type'));
    }

    /**
     * Update the specified trader_type in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        //try {

            $data = $this->getData($request);

            $trader_type = TraderType::findOrFail($id);
            $updatetradertype=$trader_type->update($data);
            if($updatetradertype){
                return redirect()->route('trader-types.index')
                ->with('success_message', 'TraderType was successfully updated.');
            }
            else{
                return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
            }


    }

    /**
     * Remove the specified trader_type from the storage.
     *
     * @param int $id
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        $trader_type = TraderType::findOrFail($id);
        $deletedtradertype=$trader_type->delete();
        if($deletedtradertype){
            return redirect()->route('trader-types.index')
            ->with('success_message', 'TraderType was successfully deleted.');
        }
        else{
            return back()->withInput()
            ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        }
    }

    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request)
    {
        $trader_type = TraderType::updateOrCreate(
            ['id' => $request->id],
            ['name' => $request->name]
        );

        return response()->json($trader_type);
    }

    /**
     * Show the form for editing the specified trader_type.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $trader_type = TraderType::findOrFail($id);
        return response()->json($trader_type);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        $trader_type = TraderType::where('id', $id)->delete();
        return response()->json($trader_type);
    }


    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request\Request $request
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
            'name' => 'required|string|min:0|max:255',

        ];
        $data = $request->validate($rules);

        return $data;
    }
}
