<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\TraderNetwork;

class TraderNetworkController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request) {
        $trader_network = TraderNetwork::updateOrCreate(
            ['id' => $request->id],
            ['trader_id' => $request->trader_id, 'agrodealer_id' => $request->agrodealer_id, 'type' => $request->type, 'region_id' => $request->region_id, 'county_id' => $request->county_id, 'description' => $request->description]
        );

        return response()->json($trader_network->load('trader', 'region', 'county', 'agrodealer'));
    }

    /**
     * Show the form for editing the specified trader-member.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $trader_network = TraderNetwork::findOrFail($id);
        return response()->json($trader_network);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\TraderNetwork  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        $trader_network = TraderNetwork::where('id', $id)->delete();
        return response()->json($trader_network);
    }
}
