<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Auth;
use App\User;
use App\TraderContract;
use App\BuyerContractDetail;
use App\ContractDetail;
use App\ProduceItem;
use App\Produce;
use App\Trader;
use Log;

class TraderContractController extends Controller
{

    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Display a listing of the contracts.
     *
     * @return Illuminate\View\View
     */
    public function index(Request $request)
    {
        $contracts = TraderContract::paginate(env('LIST_SIZE', 10));

        if($request->ajax()){
            $return_array = compact('contracts');
            return json_encode($return_array);
        }

        return view('trader-contracts.index', compact('contracts'));
    }

    /**
     * Show the form for creating a new contract.
     *
     * @return Illuminate\View\View
     */
    public function create(Request $request)
    {
        $contracts = TraderContract::pluck('contract_url','id')->all();

        if($request->ajax()){
            $return_array = compact('contracts');
            return json_encode($return_array);
        }

        return view('trader-contracts.create', compact('contracts'));
    }

    /**
     * Store a new contract in the storage.
     *
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        $contract=TraderContract::create($data)->id;
        if($contract){
                return redirect()->route('trader-contracts.index')
                ->with('success_message', 'Contract for Trader was successfully added.');

                // return response()->json($k);
            }
            else{
                return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);

            }

        //return response()->json($data);
    }

    /**
     * Display the specified tradercontract.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function show($id)
    {
        $user_id = Auth::user()->id;
        $user = User::findorFail($user_id);
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();

        $trader_contract = TraderContract::findOrFail($id);
        $contract_details = ContractDetail::where('contract_id', $id)->get();
        // $produce_items = ProduceItem::where('produce_id', $trader_contract->produce_id)->get();
        $data = [];
        $data['contract_id'] = $trader_contract->id;
        $buyer_contract_details=1;
        $produce=1;
        $data['produce_id'] = $trader_contract->produce_id;
        $produce_items = ProduceItem::where('produce_id', $data['produce_id'])->whereDoesntHave('contract_details', function($query) use ($data) {
            $query->where('contract_id', $data['contract_id']);
        })->get();

        return view('trader-contracts.show', compact('dashboard','trader_contract', 'contract_details', 'produce_items', 'buyer_contract_details', 'produce'));
    }

    /**
     * Show the form for editing the specified tradercontract.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function edit($id)
    {
        $tradercontract = TraderContract::findOrFail($id);

        return view('trader-contracts.edit', compact('tradercontract'));
    }

    /**
     * Update the specified tradercontract in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {

        $tradercontract = TraderContract::findOrFail($id);
        $updatetradercontract=$tradercontract->update($data);
        if($updatetradercontract){
            return redirect()->route('trader-contracts.index')
                ->with('success_message', 'Trader Contract was successfully updated.');
        } else{
            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        }
    }

    /**
     * Remove the specified trader contract from the storage.
     *
     * @param int $id
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function destroy(Request $request)
    {

        $id = $request->id;
        $contract = TraderContract::where('id',$id)->delete();
        $destinationPath = public_path().'/trader-contracts/'.$request->contract_file;
        unlink($destinationPath);

            if($contract){
                return redirect('traders/'.$request->traderid)
                ->with('success_message', 'Trader Contract was successfully deleted.');
            }
            else{
                return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
            }
    }

    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request) {
        if($request->id || $request->hasFile('contract_file')) {
            if($request->hasFile('contract_file')) {
                $file = $request->file('contract_file');
                $contract_file_name = rand() . '.' . $file->getClientOriginalExtension();
                $file->move(public_path('trader-contracts'), $contract_file_name);
                $fileWasReplaced = true;
            } else {
                $contract_file_name = $request->old_contract_file;
                $fileWasReplaced = false;
            }
           Log::info("its here");
            $trader_contract = TraderContract::updateOrCreate(
                ['id' => $request->id],
                ['name' => $request->name, 'trader_id' => $request->trader_id, 'contract_file' => $contract_file_name, 'produce_id' => $request->produce_id, 'produce_unit_id' => $request->produce_unit_id, 'price_per_unit' => $request->price_per_unit, 'tonnage' => $request->tonnage]
            );

            if($trader_contract->wasChanged() && $fileWasReplaced) {
                File::delete(public_path('trader-contracts/'. $request->old_contract_file));
            }

            return response()->json($trader_contract->load('produce', 'produce_unit'));
        }

        return response()->json(['error' => "Invalid file"]);
    }

    /**
     * Show the form for editing the specified trader-member.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $trader_contract = TraderContract::findOrFail($id);
        return response()->json($trader_contract);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\TraderContract  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        $trader_contract = TraderContract::where('id', $id)->delete();
        return response()->json($trader_contract);
    }

    /**
     * Show the form for editing the specified trader-member.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function getContractDetails($id)
    {
        $trader_contract = TraderContract::findOrFail($id);
        return response()->json($trader_contract->contract_details);
    }

    // getContractDetails

    //show details to add the contract
    public function showAddContract($traderid){

        return view('trader-contracts')->compact('$traderid');
    }

    //edit the contract

    public function editContract(Request $request){

        return response()->json("testitems");

    }

    //add extra details on the contract
    public function addContractDetails(Request $request){
        $traderid=$request->trader_id;
        //get the contractid belonging to the organisation
        $organisation=TraderContract::where('trader_id',$traderid)->first();
        $extraDetails['contract_id']=$organisation['id'];
        $extraDetails['produce_item_id']=$request->trader_produce;
        $extraDetails['produce_tonnage']=$request->produce_tonnage;
        $extraDetails['produce_unit_price']=$request->unit_per_price;

        //save the extra details
        $contractdetails=ContractDetail::create($extraDetails);

        if($contractdetails){

            return redirect('traders/'.$traderid)
            ->with('success_message', 'Contract Details updated successfully.');
        }
        else{
            return back()->withInput()
            ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);

        }
    }

    //destroy a contract details item
    public function deleteContractItem(Request $request)
    {

        $id = $request->contractdetailsid;

        $contractdetail = ContractDetail::where('id',$id)->delete();

        if($contractdetail){
            return redirect('traders/'.$request->traderid)
                ->with('success_message', 'Trader Contract was successfully deleted.');
        } else {
            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        }
    }

    public function getFulfilment($id) {
        $contract = TraderContract::findOrFail($id);

        if ($contract) {
            $tonnage = (int) $_GET['tonnage'];
            $expected_tonnage = $contract->tonnage;
            $percentage = ($tonnage / $expected_tonnage) * 100;

            $fulfilled = $contract->fulfilled + $percentage;



            return response()->json(['fulfilled' => $fulfilled]);
        }

        return response()->json(['errors'=>'Contract not found.']);
    }

}
