<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\TraderContact;

class TraderContactController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request) {
        $is_admin = $request->is_admin;

        if (isset($request->id)) {
            $trader_contact = TraderContact::findOrFail($request->id);
            if ($is_admin == 1) {
                $trader_id = $trader_contact->trader_id;

                // Check if any other contact is presently set as admin - force set is_admin = 0 if any found
                $trader_contacts = TraderContact::where('trader_id', $trader_id)->get();
                foreach ($trader_contacts as $contact) {
                    if ($contact->id != $trader_contact->id && $contact->is_admin == 1) $contact->update(['is_admin' => 0]);
                }
            } else {
                // Check if user is presently admin - force set is_admin = 1
                if ($trader_contact->is_admin == 1) $is_admin = 1;
            }
        }

        $updated_trader_contact = TraderContact::updateOrCreate(
            ['id' => $request->id],
            ['trader_id' => $request->trader_id, 'firstname' => $request->firstname, 'lastname' => $request->lastname, 'email' => $request->email, 'phone' => $request->phone, 'user_id' => $request->user_id, 'is_admin' => $is_admin]
        );

        return response()->json($updated_trader_contact->load('user'));
    }

    /**
     * Show the form for editing the specified trader-member.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $trader_contact = TraderContact::findOrFail($id);
        return response()->json($trader_contact);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\TraderContact  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        $trader_contact = TraderContact::where('id', $id)->delete();
        return response()->json($trader_contact);
    }
}
