<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\InboxTag;
use App\Models\Incoming;
use App\Expert_Messages;
use App\TraderMember;

use App\Trader;
use Auth;
use Log;
use DB;
use EloquentBuilder;
class TaggedController extends Controller
{
    public function index()
    {
    $trader = Auth::user()->userAgent;
    $trader_arr = [];
    foreach($trader as $traderobj)
    {
        $traderid = $traderobj->trader_id;
        array_push($trader_arr,$traderid);
    }
   $dashboard['verified_traders'] = Trader::where('status','=',1)->count();
    $fos=Trader::whereIn('id',$trader_arr)->get();  
    
    $expert_messages=Expert_Messages::with('TextQuestionCoach')->with('TextQuestionOrganization')->get();
    //$expert_messages = EloquentBuilder::to($query,request()->all())->get();

    $query=TraderMember::whereIn('trader_id',$trader_arr);
    $allfarmers = EloquentBuilder::to($query,request()->all())->get();
    
    $selectedtrader = Trader::where('id',json_decode(request()->trader))->pluck('organisation_name');
        return view('tagged.index', compact('expert_messages','dashboard','allfarmers','fos','selectedtrader'));
 
    }
    //show messages with tags
    public function tagged($id)
    {
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $mid = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
       else{
            return abort('401');
        }
     //return $mid;
        $messages = Incoming::where('sms','LIKE','%'.$id.'%')->where('responded_to','')->where('site',$mid)->get();
        return view('tagged.tagged-sms',compact('messages','id'));
    }
    //other untagged
    public function untagged()
    {
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
       else{
            return abort('401');
        }
        $dept = Department::where('organization_id',$id)->pluck('department_id');
        $inboxtags = InboxTag::with('tagsSDep')->whereIn('department_id',$dept)->pluck('tag_name');
        $messages = Incoming::whereNotIn('sms',['%'.$inboxtags.'%'])->where('responded_to',NULL)->where('site',$id)->get();
        return view('tagged.untagged',compact('messages'));
 
    }
}
