<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Trader;
use App\User;
use App\TraderMember;
use App\Vehicle;
use App\Driver;
use App\inputOrders;
use App\inputOrderItems;
use App\ProduceItem;
use App\ProduceOrder;
use App\ProduceOrderItem;
use App\Delivery;
use App\InputOrderItemsRelease;
use App\InputDeliveryConfirm;
use Auth;

class SellerDeliveriesController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	}
    //
    public function index()
    {
        //
        //
        if(Auth::user()->isAdmin())
        {
            
            $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
            $deliveries = inputOrderItemsRelease::all()->sortByDesc('id');
            return view('deliveries.index', compact('deliveries','dashboard'));
        }
        elseif(Auth::user()->getRelatedTrader()->isFarmerOrganisation()) {
            $user_id = Auth::User()->id;
            $trader = Trader::where('user_id',$user_id)->pluck('id');
            $order = inputOrders::where('trader_id',$trader[0])->pluck('id');
            $deliveries = inputOrderItemsRelease::all()->whereIn('order_id',$order);
            
            $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
            return view('deliveries.index', compact('deliveries','dashboard'));
            
        }
        elseif(Auth::user()->getRelatedTrader()->isBulkSeller()){
            $user_id = Auth::User()->id;
            $trader = Trader::where('user_id',$user_id)->pluck('id');
            $order = inputOrderItems::where('directed_to',$trader[0])->pluck('order_id');
            $deliveries = inputOrderItemsRelease::all()->whereIn('order_id',$order);
            
            $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
            return view('deliveries.index', compact('deliveries','dashboard'));
        }
        else{        
            $deliveries = inputOrderItemsRelease::all()->sortByDesc('id');
            
            $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
            return view('deliveries.index', compact('deliveries','dashboard'));
        }
    }
    public function store(Request $request)
    {
        InputDeliveryConfirm::create($request->all());
         $id = $request->get('input_order_items_release_id');
            
        $del = inputOrderItemsRelease::find($id);
        $del->status = $request->get('status');
        //dd($del);
            
        $order_id = $request->get('order_id');
        $items = inputOrderItems::where('approved',3)
                        ->where('order_id',$order_id)
                        ->get();
                        
                        foreach($items as $item)
                        {
                            $item->approved = "4";
                            $item->save();
                        }
                        $del->save();
                        //update order
        $inputorder = inputOrders::find($order_id);
        $inputorder->approved = "4";
        $inputorder->save();
                                        
         return redirect()->back()
            ->with('success','Acknowledged receive succesfully.');
    }
}
