<?php

namespace App\Http\Controllers;

use App\SeasonProduce;
use App\Season;
use Illuminate\Http\Request;
use App\ProduceItem;
use App\Produce;
use Auth;
use App\FarmerProfile;

class SeasonProduceController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    //return view and table data
    public function  index($id)
    {
        $season = Season::where('season_id',$id)->pluck('farmer_id');
        
        $farmer=FarmerProfile::where('id',$season[0])->pluck('middlename');
        
        return view('season_produce.index',compact('id','farmer'));
    }
    //get soilhealth dets
    public function getSeasonProduce($id)
    {
        $seasonproduces = SeasonProduce::where('season_id',$id)->with('seasonproduceProduce.produce')->get();//
        return $seasonproduces;
    }
    //getProduce
    public function getProduce()
    {
        //get trader id
        $id = Auth::user()->traderMember->trader_id;
        $produces = ProduceItem::where('trader_id',$id)->with('produce_unit')->with('produce')->get();
        return json_decode($produces,true);
    }
    //store soil health dets
    public function store(Request $request)
    {
        request()->validate([
            'produce_item_id' => 'required',
            'season_id' => 'required',
            'quality' => 'required',
            // 'recommended_seed' => 'required',
            // 'fertilizer' => 'required',
            'pesticides' => 'required',
            'sowing_date' => 'required',
            'sowing_area' => 'integer',
            'yield_estimation' => 'integer',
            'est_harvestdate' => 'required',
        ]);
        $seasonprod = new SeasonProduce();
        $seasonprod->produce_item_id = $request->produce_item_id['id'];
        $seasonprod->season_id =$request->season_id;
        $seasonprod->quality =$request->quality;
        $seasonprod->recommended_seed =$request->recommended_seed;
        $seasonprod->fertilizer =$request->fertilizer;
        $seasonprod->pesticides =$request->pesticides;
        $seasonprod->sowing_date =$request->sowing_date;
        $seasonprod->sowing_area =$request->sowing_area;
        $seasonprod->yield_estimation =$request->yield_estimation;
        $seasonprod->est_harvestdate =$request->est_harvestdate;
        $seasonprod->save();
        
        return $seasonprod;
    }
    //update soil health dets
    public function update(Request $request)
    {
        request()->validate([
            'produce_item_id' => 'required',
            'season_id' => 'required',
            'quality' => 'required',
            // 'recommended_seed' => 'required',
            // 'fertilizer' => 'required',
            'pesticides' => 'required',
            'sowing_date' => 'required',
            'sowing_area' => 'integer',
            'yield_estimation' => 'integer',
            'est_harvestdate' => 'required',
        ]);
        $seasonprod = SeasonProduce::findOrFail($request->season_produce_id);
        $seasonprod->produce_item_id = $request->produce_item_id['id'];
        // $seasonprod->season_id =$request->season_id;
        $seasonprod->quality =$request->quality;
        $seasonprod->recommended_seed =$request->recommended_seed;
        $seasonprod->fertilizer =$request->fertilizer;
        $seasonprod->pesticides =$request->pesticides;
        $seasonprod->sowing_date =$request->sowing_date;
        $seasonprod->sowing_area =$request->sowing_area;
        $seasonprod->yield_estimation =$request->yield_estimation;
        $seasonprod->est_harvestdate =$request->est_harvestdate;
        $seasonprod->save();
        
        return $seasonprod;
    }
    //delete
    public function delete($id)
    {
        $seasonprod = SeasonProduce::findOrFail($id);
        $seasonprod->delete();
        return $seasonprod;
    }
}
