<?php

namespace App\Http\Controllers;

use App\Region;
use App\Trader;
use Illuminate\Http\Request;

class RegionController extends Controller {

    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
       // $this->authorize('viewAny', Region::class);
        $regions = Region::paginate(env('LIST_SIZE', 10));
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('regions.index', compact('regions','dashboard'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        //$this->authorize('create', Region::class);
        return view('regions.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        //$this->authorize('create', Region::class);
        $request->validate([
            'name' => 'required|unique:regions,name',
            'description' => 'required',
        ]);
        $record = new Region();
        $record->fill($request->all());
        if ($record->save()) {
            return redirect()->route('regions.index')->with('success', 'Region created.');
        } else {
            return redirect()->back()->with('failure', 'Create failed.');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Region  $region
     * @return \Illuminate\Http\Response
     */
    public function show(Region $region) {
        //$this->authorize('view', $region);
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('regions.show', compact('region','dashboard'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Region  $region
     * @return \Illuminate\Http\Response
     */
    public function edit(Region $region) {
       // $this->authorize('update', $region);
       
       $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('regions.edit', compact('region','dashboard'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Region  $region
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Region $region) {
        //$this->authorize('update', $region);
        $request->validate([
            'name' => 'required|unique:regions,name,' . $region->id,
            'description' => 'required',
        ]);
        if ($region->update($request->all())) {
            return redirect()->route('regions.index')->with('success', 'Region updated.');
        } else {
            return redirect()->back()->with('failure', 'Update failed.');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Region  $region
     * @return \Illuminate\Http\Response
     */
    public function destroy(Region $region) {
        //$this->authorize('delete', $region);
        //attempt to delete
        if ($region->delete()) {
            return redirect()->route('regions.index')->with('success', 'Region deleted.');
        } else {
            return redirect()->route('regions.index')->with('failure', 'Delete failed.');
        }
    }

    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request)
    {
        $region = Region::updateOrCreate(
            ['id' => $request->id],
            ['name' => $request->name, 'description' => $request->description]
        );

        return response()->json($region);
    }

    /**
     * Show the form for editing the specified region.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $region = Region::findOrFail($id);

        return response()->json($region);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        $region = Region::where('id', $id)->delete();
        return response()->json($region);
    }

}
