<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Publications;
use App\Trader;
use Auth;
use App\User;
use Log;
use Config;
class PublicationController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */


    public function index(Request $request)
    {
        $publications = Publications::All();
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('publication.index', compact('publications','dashboard'));
    }



    public function store(Request $request)
    {
      
        request()->validate([
    
       // 'publications_name' => 'required',
            'file' => 'required|max:2000'
        ],
        [
            'file.required' => 'Please upload an image'
        ]);
        $user = new Publications();               
        $appurl = Config::get('app.url');
        $imagelink='';
        if($request->file('file'))
        {
            $files = $request->file('file');
            $destinationPath = 'publications_files/'; // upload path
            $profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
            $files->move($destinationPath, $profileImage);
            $imagelink = $destinationPath.$profileImage;
        }
        
        $user->publications_name = $request->publications_name;

        $user->file = $imagelink;
        $user->save();  
        return back()->with('success','Added succesfully');
    }

    
    public function update(Request $request)
    {
        return $request; $user = Publications::findOrFail($request->publications_id);   
        $user->publications_name = $request->publications_name;

        $user->save();  
        return back()->with('success','Updated succesfully');
    }

    public function destroy($id )
    {
 
       // return $request->id['shop_id'];
       // return $request;     return Favourite::find($id)->delete();
        $user = Publications::findOrFail( $id );
        $user->delete();
        return back()->with('success','Deleted succesfully');
    }
}
