<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ProductionCost;
use App\FarmerBusinesPlan;
use App\FarmerProfile;
use Auth;
use App\inputOrders;
use App\inputOrderItems;


class ProductionCostController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    //return index view
    public function index($id)
    {
        $businessplan=FarmerBusinesPlan::where('id',$id)->pluck('farmer_id');
        
        $user=FarmerProfile::where('id',$businessplan[0])->pluck('middlename');
        
        return view('production-cost.index',compact('id','user'));
    }
    public function get($id)
    {
        $costs = ProductionCost::where('plan_id',$id)->get();
        return $costs;
    }
    //get ordered items 
    public function getOrdered($id)
    {
        $businessplan=FarmerBusinesPlan::where('id',$id)->pluck('farmer_id');
        
        $user=FarmerProfile::where('id',$businessplan[0])->pluck('user_id');
        
        $inputs = inputOrderItems::where('farmer_id',$user[0])->where('approved','>','1')->where('created_at','>=',now()->subMonths(12))->with('input')->get();
        
        return $inputs;
    }
    public function store(Request $request)
    {
        request()->validate([
            'input' => 'required',
            'time' => 'required',
            'cost' => 'required',
            'details' => 'required',
        ]);
        $cost = new ProductionCost();
        $cost->input = $request->input;
        $cost->time = $request->time;
        $cost->cost = $request->cost;
        $cost->details = $request->details;
        $cost->plan_id = $request->plan_id;
        $cost->system = $request->system;
        //set profit
        $plan = FarmerBusinesPlan::findOrFail($request->plan_id);
        $plan->profit = $plan->profit-$request->cost;
        $plan->save();
        $cost->save();
        return $plan;

    }
    public function update(Request $request)
    {
        request()->validate([
            'input' => 'required',
            'time' => 'required',
            'cost' => 'required',
            'details' => 'required',
        ]);
        $planid = ProductionCost::where('id',$request->id)->get();

        $prevplan = FarmerBusinesPlan::findOrFail($planid[0]->plan_id);
        $prevcost = $planid[0]->cost;
        $prevprofit = $prevplan['profit'];
        $currentcost = $request->cost;
        $profit = $prevprofit + $prevcost - $currentcost;        

        $cost = ProductionCost::findOrFail($request->id);
        $cost->input = $request->input;
        $cost->time = $request->time;
        $cost->cost = $request->cost;
        $cost->details = $request->details;
        //set profit
        $plan = FarmerBusinesPlan::findOrFail($request->plan_id);
        $plan->profit = $profit;
        $plan->save();
        $cost->save();
        return $cost;
    }
    public function destroy($id)
    {
        $cost = ProductionCost::findOrFail($id);
        $planid = ProductionCost::where('id',$id)->get();

        $prevplan = FarmerBusinesPlan::findOrFail($planid[0]->plan_id);
        $prevcost = $planid[0]->cost;
        $prevplan->profit += $prevcost;
        $prevplan->save();
        $cost->delete();
        return $cost;
    }
}
