<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\ProduceUnit;
use App\Trader;
use Illuminate\Http\Request;
use Exception;

class ProduceUnitController extends Controller
{

    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Display a listing of the produce-units.
     *
     * @return Illuminate\View\View
     */
    public function index(Request $request)
    {
        $produce_units = ProduceUnit::paginate(env('LIST_SIZE', 10));
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        if($request->ajax()){
					$return_array = compact('produce_units');
          return json_encode($return_array);
        }

        return view('produce-units.index', compact('produce_units','dashboard'));
    }

    /**
     * Show the form for creating a new produce_unit.
     *
     * @return Illuminate\View\View
     */
    public function create(Request $request)
    {
        $produce_units = ProduceUnit::pluck('name','id')->all();

        if($request->ajax()){
					$return_array = compact('produce_units');
          return json_encode($return_array);
        }
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('produce-units.create', compact('produce_units','dashboard'));
    }

    /**
     * Store a new produceunit in the storage.
     *
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
             $data = $this->getData($request);

            $produce_unit=ProduceUnit::create($data)->id;
            if($produce_unit){
                    return redirect()->route('produce-units.index')
                    ->with('success_message', 'Produce unit was successfully added.');

                   // return response()->json($k);
                }
                else{
                    return back()->withInput()
                    ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);

                }

            //return response()->json($data);


    }

    /**
     * Display the specified produceunit.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function show($id)
    {
        $produce_unit = ProduceUnit::findOrFail($id);
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('produce-units.show', compact('produce_unit','dashboard'));
    }

    /**
     * Show the form for editing the specified produceunit.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function edit($id)
    {
        $produce_unit = ProduceUnit::findOrFail($id);
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('produce-units.edit', compact('produce_unit','dashboard'));
    }

    /**
     * Update the specified produceunit in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        //try {

            $data = $this->getData($request);

            $produce_unit = ProduceUnit::findOrFail($id);
            $updateproduceunit=$produce_unit->update($data);
            if($updateproduceunit){
                return redirect()->route('produce-units.index')
                ->with('success_message', 'Produce Unit was successfully updated.');
            }
            else{
                return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);


            }


    }

    /**
     * Remove the specified produce unit from the storage.
     *
     * @param int $id
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        //try {
            $produceunit = ProduceUnit::findOrFail($id);
            $deletedproduceunit=$produceunit->delete();
            if($deletedproduceunit){
                return redirect()->route('produce-units.index')
                ->with('success_message', 'Produce Unit was successfully deleted.');
            }
            else{
                return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
            }


    }


    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request\Request $request
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
            'name' => 'required|string|min:0|max:255',
            'description' => 'required|string|min:0|max:255',
            'abbreviation' => 'required|string|min:0|max:255',

        ];
        $data = $request->validate($rules);

        return $data;
    }

    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request)
    {
        $produce_unit = ProduceUnit::updateOrCreate(
            ['id' => $request->id],
            ['name' => $request->name, 'abbreviation' => $request->abbreviation, 'description' => $request->description]
        );

        return response()->json($produce_unit);
    }

    /**
     * Show the form for editing the specified produce_unit.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $produce_unit = ProduceUnit::findOrFail($id);

        return response()->json($produce_unit);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        $produce_unit = ProduceUnit::where('id', $id)->delete();
        return response()->json($produce_unit);
    }
}
