<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\ProduceItem;
use App\ProduceOrder;
use App\ProduceOrderItem;
use App\Trader;
use App\Invoice;
use App\InputOrderItemsRelease;
use App\TransportModel;
use App\User;
use App\DeliveryRequests;
use App\DeliveryAcknowledgement;

class ProduceOrderController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {

        $trader_id = $request->trader_id;
        if (!is_null($trader_id)) {
            $trader = Trader::findOrFail($trader_id);
        } else {
            $user_id = Auth::user()->id;
            $user = User::findOrFail($user_id);
            $trader = $user->getRelatedTrader();
        }

        if($trader) {
            $transporters = Trader::all()->where('type_id', 5)->where('status',1);
            // $produce_items = ProduceItem::where('trader_id', $trader->id)->get();
            $produce_orders = ProduceOrder::where('trader_id', $trader->id)->withCount('produce_order_items')->get();
            // dd($produce_orders);
            return view('produce-orders.index', compact('produce_orders','trader','transporters'));
        } elseif(Auth::user()->isAdmin()) {
            $transporters = Trader::all()->where('type_id',5)->where('status',1);
            // $produce_items = ProduceItem::all()->where('trader_id', $trader->id);
            $bulk_buyer_id = get_id('App\TraderType', 'name', 'Bulk Buyer');
            $traders = Trader::where('type_id', $bulk_buyer_id)->get();
            $produce_orders = ProduceOrder::withCount('produce_order_items')->get();
            return view('produce-orders.index', compact('produce_orders','traders','transporters'));
        } else {
            return redirect()->back()->with('failure', 'Produce order creation failed.');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        // $this->authorize('create', Product::class);
        if(isset($_POST['transport']))
        {

            DeliveryRequests::create($request->all());
            return redirect()->route('produce-orders.index')
            ->with('success','Delivery details added succesfully.');
        }
        else{
            $request->validate([
            'trader_id' => 'exists:traders,id'
        ]);

        $record = new ProduceOrder();
        $record->fill($request->all());
        if ($record->save()) {
            return redirect()->route('produce-orders.index')->with('success', 'Produce order created.');
        } else {
            return redirect()->back()->with('failure', 'Create failed.');
        }
    }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\ProduceOrder  $product_order
     * @return \Illuminate\Http\Response
     */
    public function show(ProduceOrder $produce_order) {
        return view('produce-orders.show', compact('produce_order'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\ProduceOrder  $product_order
     * @return \Illuminate\Http\Response
     */
    public function edit(ProduceOrder $produce_order)
    {
        return view('produce-orders.edit', compact('produce_order'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\ProduceOrder  $product_order
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ProduceOrder $produce_order)
    {
        //  $this->authorize('update', $produce);
        $request->validate([
            'trader_id' => 'exists:traders,id'
        ]);

        if ($produce_order->update($request->all())) {
            return redirect()->route('produce-orders.index')->with('success', 'Produce order updated.');
        } else {
            return redirect()->back()->with('failure', 'Update failed.');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\ProduceOrder  $product_order
     * @return \Illuminate\Http\Response
     */
    public function destroy(ProduceOrder $produce_order)
    {
        if ($produce_order->items()->count() > 0) {
            return redirect()->route('produce-orders.index')->with('failure', 'Cannot delete produce order because it has associated items.');
        }
        //attempt to delete
        if ($produce_order->delete()) {
            return redirect()->route('produce-orders.index')->with('success', 'Produce order deleted.');
        } else {
            return redirect()->route('produce-orders.index')->with('failure', 'Delete failed.');
        }
    }

    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request)
    {
        $total = 0;
        $record_count = 0;

        $produce_order = ProduceOrder::updateOrCreate(
            ['id' => $request->id],
            ['trader_id' => $request->trader_id]
        );

        if($produce_order) {
            foreach($request->produce_order_item as $produce_order_item) {
                if (isset($produce_order_item['contract_id']) && isset($produce_order_item['quantity']) && isset($produce_order_item['price_per_unit'])) {
                    $record = $produce_order->produce_order_items()->create([
                        'produce_order_id' => $produce_order->id,
                        'contract_id' => $produce_order_item['contract_id'],
                        'quantity' => $produce_order_item['quantity'],
                        'price_per_unit' => $produce_order_item['price_per_unit']
                    ]);

                    if($record) {
                        $item_total = $produce_order_item['quantity'] * $produce_order_item['price_per_unit'];
                        $total += $item_total;
                        $record_count++;
                    }
                }
            }

            if($record_count != 0) {
                $produce_order->total = $total;
                $produce_order->save();
            } else {
                $produce_order->delete();
                return response()->json(['errors'=> 'Produce order has no items.']);
            }
            //else delete $produce_order
        }

        return response()->json($produce_order->load('trader')->loadCount('produce_order_items'));
    }

    /**
     * Show the form for editing the specified produce.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $produce_order = ProduceOrder::findOrFail($id);

        return response()->json($produce_order->load('produce_order_items'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        $produce_order = ProduceOrder::find($id);
        if($produce_order) {
            $produce_order->delete();
            return response()->json($produce_order);
        }
    }

    public function approveAjax(Request $request) {
        $approved = 1;
        $approved_by = Auth::user()->id;

        $produce_order = ProduceOrder::updateOrCreate(
            ['id' => $request->id],
            ['approved' => $approved, 'approved_by' => $approved_by]
        );

        if($produce_order) {
            //RAISE INVOICE HERE

            $invoice = new Invoice();
            $invoice->produce_collection_id = $produce_order->id;;
            $invoice->posted_by = Auth::User()->id;
            $invoice->number = $produce_order->id;
            //$invoice->date = date('Y-m-d H:i:s');
            $invoice->direction = "in";
            $invoice->directed_to = $produce_order->trader_id;
            $invoice->type = "produce";
            $invoice->total = $produce_order->total;
            $invoice->balance = $produce_order->total;
            $invoice->status = "0";

            $invoice->save();

            // END INVOICE

            return response()->json($produce_order->load('trader')->loadCount('produce_order_items'));
        }
    }
}
