<?php

namespace App\Http\Controllers;

use App\Stock;
use App\Produce;
use App\ProduceUnit;
use App\ProduceItem;
use App\Trader;
use App\TraderType;
use Illuminate\Http\Request;

class ProduceItemController extends Controller{

    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
       // $this->authorize('viewAny', Item::class);
        $fo_id = get_id(TraderType::class, 'name', 'Farmer Organisation');
        $traders = Trader::where('type_id', $fo_id)->get();
        $produces = Produce::all();
        $produce_units = ProduceUnit::all();

        if (isset($request->cid)) $cid = $request->cid;
        else $cid = null;

        //$items = ProductCategory::where('id', $request->cid)->products();//->get();
        // $produce_categories = ProduceCategory::all();//->get();
        // $produceaddeditems = ProduceItem::all();
        $produce_items = ProduceItem::all();

       /*  $itemscollection=[];

        foreach($selectedcategory as $category){
            foreach($products as $product){
                if($category->id==$product->category_id){
                    array_push($itemscollection, $product);

                }
            }
        }
        $items=collect($itemscollection);*/
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('produce-items.index', compact('dashboard','traders', 'produces', 'produce_units', 'produce_items'));
        //return response()->json($produce_items);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        // $this->authorize('create', ProduceItem::class);
        $traders = Trader::all();
        $produces = Produce::all();
        $produceunits = ProduceUnit::all();
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('produce-items.create', compact('dashboard','traders', 'produces', 'produceunits'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
       // $this->authorize('create', ProduceItem::class);
       /* $data=$request->validate([
            'name'=>'required',
            'trader_id' => 'required|exists:traders,id',
            'produce_id' => 'required|exists:produces,id',
            'produceunit_id' => 'required|exists:produceunits,id',
            'price_per_unit' => 'required',
            'icon' => 'nullable|file|mimes:jpg,jpeg,png'
        ]);  */
        //$record = new ProduceItem();
        //$record->fill($request->all());
       /*  if ($record->save()) {
            //save uploaded file
            if ($request->hasFile('icon')) {
                $icon = $request->file('icon');
                //save path to icon in database
                $record->icon = $icon->store('item-icons', 'public');
                $record->save();
            }
            return redirect()->route('produce-items.index')->with('success', 'Produce item created.');
        } else {
            return redirect()->back()->with('failure', 'Create failed.');
        } */

        $itemdata['trader_id']=$request->trader_id;
        $itemdata['produce_unit_id']=$request->unit;
        $itemdata['produce_id']=$request->product_id;

        //save the data
        $data=ProduceItem::create($itemdata);
        if($data){
            return redirect()->route('produce-items.index')->with('success', 'Produce item created.');
        } else {
            return redirect()->back()->with('failure', 'Create failed.');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\ProduceItem  $item
     * @return \Illuminate\Http\Response
     */
    public function show(ProduceItem $item) {
       // $this->authorize('view', $item);
       
       $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('produce-items.show', compact('item','dashboard'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\ProduceItem  $item
     * @return \Illuminate\Http\Response
     */
    public function edit(ProduceItem $item) {
       // $this->authorize('update', $item);
        $traders = Trader::all();
        $produces = Produce::all();
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('produce-items.edit', compact('item', 'traders', 'produces','dashboard'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\ProduceItem  $item
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ProduceItem $item) {
        $this->authorize('update', $item);
        $request->validate([
            'trader_id' => 'required|exists:traders,id',
            'name' => 'required|string',
            'produce_id' => 'required|exists:produces,id',
            'produce_unit_id' => 'required|exists:produceunits,id',
            'icon' => 'nullable|file|mimes:jpg,jpeg,png'
        ]);
        if ($item->update($request->all())) {
            //save uploaded file
            if ($request->hasFile('icon')) {
                $icon = $request->file('icon');
                //save path to icon in database
                $item->icon = $icon->store('item-icons', 'public');
                $item->save();
            }
            return redirect()->route('produce-items.index')->with('success', 'Produce item updated.');
        } else {
            return redirect()->back()->with('failure', 'Produce Update failed.');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\ProduceItem  $item
     * @return \Illuminate\Http\Response
     */
    public function destroy(ProduceItem $item) {
        //$this->authorize('delete', $item);
        //attempt to delete
        if ($item->delete()) {
            return redirect()->route('produce-items.index')->with('success', 'Produce item deleted.');
        } else {
            return redirect()->route('produce-items.index')->with('failure', 'Produce Delete failed.');
        }
    }

    //show form for stock form
    public function getUpdateStockForm(Request $request, ProduceItem $item) {
        $traders = Trader::all();
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('items.update-stock', compact('item', 'traders','dashboard'));
    }
    //update stock
    public function updateStock(Request $request, ProduceItem $item) {
        $request->validate([
            'operation' => 'required|in:add,remove',
            'amount' => 'required|numeric|min:1',
            'description' => 'required'
        ]);
        $record = new Stock();
        $record->item_id = $item->id;
        $record->amount = $request->operation == 'remove' ? -1 * $request->amount : $request->amount;
        $record->description = $request->description;
        if ($record->save()) {
            return redirect()->route('produce-items.index')->with('success', 'Stock updated.');
        } else {
            return redirect()->back()->with('failure', 'Stock update failed.');
        }
    }

    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request)
    {
        $produce_item = ProduceItem::updateOrCreate(
            ['id' => $request->id],
            ['trader_id' => $request->trader_id, 'produce_id' => $request->produce_id, 'produce_unit_id' => $request->produce_unit_id, 'price_per_unit' => $request->price_per_unit, 'tonnage' => $request->tonnage, 'quality' => $request->quality, 'approved' => $request->approved, 'balance' => 0]
        );

        return response()->json($produce_item->load('trader', 'produce', 'produce_unit'));
    }

    /**
     * Show the form for editing the specified produce.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $produce_item = ProduceItem::findOrFail($id);

        return response()->json($produce_item);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        $produce_item = ProduceItem::where('id', $id)->delete();
        return response()->json($produce_item);
    }

}
