<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Invoice;
use App\Order;
use App\Trader;
use App\TraderMember;
use App\InvoicePayment;
use Illuminate\Http\Request;
use Exception;
use Auth;
use App\ProduceOrder;
use App\ProduceOrderItem;
use App\ForwardedInputOrderItem;

class ProduceInvoicesController extends Controller
{
    /**
     * Create a new Invoices controller instance.
     *
     * @return void
     */
	public function __construct()
	{
	    $this->middleware('auth');
	}

    /**
     * Display a listing of the produce-invoices.
     *
     * @return Illuminate\View\View
     */
    public function index()
    {
        $user_id = Auth::User()->id;
        $trader = Trader::where('user_id',$user_id)->pluck('id');
        // $order = ProduceOrder::where('trader_id', $user_id)->pluck('id');
        
        // $items = ProduceOrderItem::whereIn('produce_order_id',$order)->pluck('id');
        $invoices = Invoice::with('invoice')->where('type' ,"produce")->where('directed_to',$trader[0])->paginate(25)->sortByDesc('id');
        return view('produce-invoices.index', compact('invoices'));
    }
    public function index2()
    {
        $invoiceout = Invoice::with('invoice')->where('direction' ,"out")->paginate(25);

        return view('produce-invoices.index2', compact('invoiceout'));
    }
    /**
     * Show the form for creating a new invoice.
     *
     * @return Illuminate\View\View
     */
    public function create()
    {
        // $orders = Order::pluck('id','id')->all();

        // return view('produce-invoices.create', compact('orders'));
    }

    /**
     * Store a new invoice in the storage.
     *
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
                $pay = new InvoicePayment();
                $total = $request->get('total');   
                $amount = $request->get('amount');
                $balance = $request->get('balance');

                $id = $request->get('id');    
                $pay->invoice_id = $request->get('id');           
                $pay->amount = $request->get('amount');            
                $pay->mode = $request->get('mode');            
                //$pay->date = $request->get('date');
                $pay->save();
                if($amount ==  $balance)
                {
                    $invoice = Invoice::find($id);
                    $invoice->status = "1";
                    $invoice->balance = $balance -  $amount;
                    
                    $invoice->Save();
                } else
                {
                    $invoice = Invoice::find($id);
                    $invoice->status = "0";
                    $invoice->balance = $balance -  $amount;
                    
                    $invoice->Save();
                }
                return redirect()->back()
                ->with('success', "Payment made Succesfully");
        // $id = $request->get('id');
        
        //         //invoice
        //         $invoice = new Invoice();
        //         $invoice->input_item_id = NULL;
        //         $invoice->produce_order_item_id = NULL;
        //         $invoice->direction = "out";
        //         $invoice->status = $request->get('approved');
        //         $invoice->directed_to = NULL;
        //         $invoice->posted_by = Auth::User()->id;
        //         $invoice->type = $request->get('type');
        //         $invoice->total = $request->get('total');
        //         $invoice->number = $request->get('number');
        //         $invoice->save();
        // return redirect()->route('produce-invoices.index')
        // ->with('success', "Done Succesfully");
    }

    /**
     * Display the specified invoice.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function show($id)
    {
        // $invoice = Invoice::with('order')->findOrFail($id);

        // return view('produce-invoices.show', compact('invoice'));
        $invoice = Invoice::find($id);
        $invoices = InvoicePayment::all()->where('invoice_id',$id);
        return view('produce-invoices.details', compact('invoices','invoice'));
    }

    /**
     * Show the form for editing the specified invoice.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function edit($id)
    {
        // $invoice = Invoice::findOrFail($id);
        // $orders = Order::pluck('id','id')->all();

        // return view('produce-invoices.edit', compact('invoice','orders'));
    }

    /**
     * Update the specified invoice in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        // try {

           //invoice
        // $invoice = new Invoice();
        // $invoice->input_item_id = $id;
        // $invoice->posted_by = Auth::User()->id;
        // $invoice->number = $request->get('order_id');
        // //$invoice->date = date('Y-m-d H:i:s');
        // $invoice->direction = "in";
        // $invoice->type = "produce";
        // $invoice->total = $request->get('total');
        // $invoice->status = $request->get('approved');
        // $invoice->save();
        //end invoice

        //     return redirect()->route('produce-invoices.index')
        //         ->with('success_message', 'Invoice was successfully Raised.');
        // } catch (Exception $exception) {

        //     return back()->withInput()
        //         ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        // }
    }

    /**
     * Remove the specified invoice from the storage.
     *
     * @param int $id
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        try {
            $invoice = Invoice::findOrFail($id);
            $invoice->delete();

            return redirect()->route('produce-invoices.index')
                ->with('success_message', 'Invoice was successfully deleted.');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        }
    }


    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request\Request $request
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
            'order_id' => 'required',
            'number' => 'nullable|numeric|string|min:0',
            'date' => 'required|string|date_format:m/d/Y',
            'total' => 'nullable|numeric|min:0|max:1.844674407371E+19',
            'status' => 'nullable|string|min:0|max:255',
        ];


        $data = $request->validate($rules);

        return $data;
    }

}
