<?php

namespace App\Http\Controllers;

use App\Produce;
use App\ProduceCategory;
use App\Trader;
use Illuminate\Http\Request;

class ProduceController extends Controller {

    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
       // $this->authorize('viewAny', Produce::class);

        $produce_categories = ProduceCategory::all();
        //create query to retrieve  products
        $query = Produce::query();
        //apply category if it was supplied
        $cid = $request->cid;
        if (!is_null($cid)) {
            $query->where('category_id', '=', $cid);
        }
        $produces = $query->paginate(env('LIST_SIZE', 10));
        
                
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('produces.index', compact('produces', 'produce_categories','dashboard'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        //$this->authorize('create', Produce::class);
        $produceCategories = ProduceCategory::all();
        
                
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('produces.create', compact('produceCategories','dashboard'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
       // $this->authorize('create', Product::class);
        $request->validate([
            'category_id' => 'nullable|exists:produce_categories,id',
            'name' => 'required|unique:produce,name',
            'description' => 'required',
            'listed' => 'required|in:0,1',
            'icon' => 'nullable|file|mimes:jpg,jpeg,png'
        ]);
        $record = new Produce();
        $record->fill($request->all());
        if ($record->save()) {
            //save uploaded file
            if ($request->hasFile('icon')) {
                $icon = $request->file('icon');
                //save path to icon in database
                $record->icon = $icon->store('product-icons', 'public');
                $record->save();
            }
            return redirect()->route('produces.index')->with('success', 'Produce created.');
        } else {
            return redirect()->back()->with('failure', 'Create failed.');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Produce  $product
     * @return \Illuminate\Http\Response
     */
    public function show(Produce $produce) {
        //$this->authorize('view', $product);
        
                
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('produces.show', compact('produce','dashboard'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Produce $product
     * @return \Illuminate\Http\Response
     */
    public function edit(Produce $produce) {
        //$this->authorize('update', $product);
        $produceCategories = ProduceCategory::all();
        
                
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('produces.edit', compact('produce', 'produceCategories','dashboard'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Produce  $product
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Produce $produce) {
        //  $this->authorize('update', $produce);
        $request->validate([
            'category_id' => 'nullable|exists:produce_categories,id',
            'name' => 'required|unique:produce,name,' . $produce->id,
            'description' => 'required',
            'listed' => 'required|in:0,1',
            'icon' => 'nullable|file|mimes:jpg,jpeg,png'
        ]);
        if ($produce->update($request->all())) {
            //save uploaded file
            if ($request->hasFile('icon')) {
                $icon = $request->file('icon');
                //save path to icon in database
                $produce->icon = $icon->store('produce-icons', 'public');
                $produce->save();
            }
            return redirect()->route('produces.index')->with('success', 'Produce updated.');
        } else {
            return redirect()->back()->with('failure', 'Update failed.');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Produce  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy(Produce $produce) {
        // $this->authorize('delete', $product);
        //check associations
        if ($produce->items()->count() > 0) {
            return redirect()->route('produces.index')->with('failure', 'Cannot delete produce because it has associated items.');
        }
        //attempt to delete
        if ($produce->delete()) {
            return redirect()->route('produces.index')->with('success', 'Produce deleted.');
        } else {
            return redirect()->route('produces.index')->with('failure', 'Delete failed.');
        }
    }

    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request)
    {
        $produce = Produce::updateOrCreate(
            ['id' => $request->id],
            ['name' => $request->name, 'description' => $request->description, 'category_id' => $request->category_id, 'listed' => $request->listed]
        );

        return response()->json($produce->load('category'));
    }

    /**
     * Show the form for editing the specified produce.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $produce = Produce::findOrFail($id);

        return response()->json($produce);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        $produce = Produce::where('id', $id)->delete();
        return response()->json($produce);
    }

}
