<?php

namespace App\Http\Controllers;

use EloquentBuilder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use App\Exports\ProduceCollectionsExport;
use App\FarmerProduceAggregation;
use App\User;
use App\Trader;
use App\TraderMember;
use App\TraderContract;
use App\ContractDetail;
use App\ProduceCollection;
use App\ProduceItem;
use App\Produce;
use App\Invoice;
use App\DeliveryRequests;

class ProduceCollectionsController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
    }

    public function export(Request $request) {
        return new ProduceCollectionsExport($request);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $user_id = Auth::user()->id;
        $user = User::findOrFail($user_id);
        //addded trader---changes************
         $trader = $user->getRelatedTrader();
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        if($user->isAdmin() || $user->getRelatedTrader()->isBulkBuyer() || $trader->isFarmerOrganisation()) {
            $produces = Produce::all();

            if($user->isAdmin()) {
                $produce_collections = EloquentBuilder::to(ProduceCollection::class, $request->all())->get();
            }
            elseif($trader->isFarmerOrganisation()){
                $trader = $user->getRelatedTrader();
                $trader_id = $trader->id;
                $query = ProduceCollection::whereHas('contract_detail', function($query) use($trader_id) {
                        $query->whereHas('contract', function($query) use($trader_id) {
                       $query->where('fo_id', $trader_id);
                    });
                });
                
                //$produce_collections = EloquentBuilder::to(ProduceCollection::class, $request->all())->get();
                $produce_collections = EloquentBuilder::to($query, request()->all())->get();
               
                 //return $produce_collections;
                }
                else {
                $trader = $user->getRelatedTrader();
                $trader_id = $trader->id;
                $query = ProduceCollection::whereHas('contract_detail', function($query) use($trader_id) {
                    $query->whereHas('contract', function($query) use($trader_id) {
                        $query->where('trader_id', $trader_id);
                    });
                });
                $produce_collections = EloquentBuilder::to($query, request()->all())->get();
            }

            $transporters = Trader::whereHas('trader_type', function($query) {
                $query->where('name', 'Transporter');
            })->where('status', 1)->get();

            return view('produce-collections.index', compact('dashboard','produce_collections', 'transporters', 'produces'));
        }

        return redirect('/dashboard');
    }

    public function collect(Request $request)
    {
        $user_id = Auth::user()->id;
        $user = User::findOrFail($user_id);
        $trader = $user->getRelatedTrader();
                
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        if($user->isAdmin() || $user->getRelatedTrader()->isBulkBuyer() ||$trader->isFarmerOrganisation() ) {
            if($user->isAdmin()) {
                $produce_items = ProduceItem::whereHas('contract_details')->get();
            } 
            elseif($trader->isFarmerOrganisation()){
                //the id 
                $trader_id = $trader->id;
                $produce_items = ProduceItem::whereHas('contract_details',function($query) use($trader_id) {
                                $query->whereHas('contract', function($query) use($trader_id) {
                        $query->where('fo_id', $trader_id);
                         });
                     })->get();
                     
                
                
                }else {
                $trader = $user->getRelatedTrader();
                $trader_id = $trader->id;
                $produce_items = ProduceItem::whereHas('contract_details', function($query) use($trader_id) {
                    $query->whereHas('contract', function($query) use($trader_id) {
                        $query->where('trader_id', $trader_id);
                    });
                })->get();
            }

            return view('produce-collections.collect', compact('dashboard','produce_items'));
        }

        return redirect('/dashboard');
    }

    public function collectAjax($id)
    {
        $produce_item = ProduceItem::findOrFail($id);
        if($produce_item) {
            // $produce_item_id = $produce_item->id;
            // $pending_collections = ProduceCollection::whereHas('contract_detail', function($query) use($produce_item_id) {
            //     $query->whereHas('produce_item', function($query) use($produce_item_id) {
            //         $query->where('id', $produce_item_id);
            //     });
            // })->where('status', 0)->sum('quantity');

            // $produce_item->balance -= $pending_collections;
            // $produce_item->pending_collections = $pending_collections;

            return response()->json($produce_item->load('trader', 'produce', 'produce_unit', 'contract_details', 'contract_details.contract', 'contract_details.contract.trader'));
        }

        return response()->json(['errors' => 'No collections found.']);
    }

    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request)
    {

        $contract_detail_id = $request->contract_detail_id;
        $produce_item = ProduceItem::whereHas('contract_details', function($query) use($contract_detail_id) {
            $query->where('id', $contract_detail_id);
        })->first();

        $available_balance = $produce_item->available_balance;
        if(isset($request->id)) {
            $collection_quantity = ProduceCollection::where('id', $request->id)->pluck('quantity');
            $available_balance += $collection_quantity[0];
            $redirect = false;
        } else {
            $redirect = true;
        }


        $validator = Validator::make($request->all(), [
            'contract_detail_id' => 'required',
            'quantity' => 'required|numeric|min:1|max:'. $available_balance,
        ]);

        if ($validator->fails())
            return response()->json(['errors' => $validator->errors()->all()]);

        $produce_collection = ProduceCollection::updateOrCreate(
            ['id' => $request->id],
            ['contract_detail_id' => $request->contract_detail_id, 'quantity' => $request->quantity, 'collected_by' => $request->collected_by, 'approved_by' => Auth::user()->id,'status' => 0]
        );

        if($produce_collection) {
            // $produce_item = ProduceItem::findOrFail($produce_collection->contract_detail->produce_item->id);
            $notification = array(
                'message' => 'Produce collected successfully!',
                'alert' => 'success', // success, error, info, warning
                'redirect' => $redirect
            );

            if(Auth::user()->isAdmin()) $is_admin = true;
            else $is_admin = false;

            return response()->json(['produce_collection' => $produce_collection->load('contract_detail', 'contract_detail.produce_item', 'contract_detail.contract', 'contract_detail.produce_item.trader', 'contract_detail.contract.trader', 'contract_detail.produce_item.produce', 'contract_detail.produce_item.produce_unit'), 'notification' => $notification, 'is_admin' => $is_admin]);
        }

        return response()->json(['errors' => 'Collection failed.']);
    }

    public function storeDelivery(Request $request) {
        $user_id = Auth::user()->id;
        $user = User::findOrFail($user_id);
        $trader = $user->getRelatedTrader();
        
        $produce_collection_id = $request->produce_collection_id;
        $produce_collection = ProduceCollection::findOrFail($produce_collection_id);

        if($produce_collection) {
            $produce_collection->status = 1;
            $produce_collection->approved_by = Auth::user()->id;

            if($produce_collection->save()) {
                // Reduce produce_item balance
                $produce_item = ProduceItem::findOrFail($produce_collection->contract_detail->produce_item->id);
                $produce_item->balance -= $produce_collection->quantity;
                $produce_item->save();

                //Raise Invoice
                $invoice = new Invoice();
                $invoice->produce_collection_id = $produce_collection->id;
                $invoice->posted_by = Auth::User()->id;
                $invoice->number = $produce_collection->id;
                if($trader->isFarmerOrganisation()){
                   $invoice->fo_id = $trader->id ; 
                }
                $invoice->direction = "in";
                $invoice->directed_to = $produce_collection->contract_detail->contract->trader->id;
                $invoice->type = "produce";
                $invoice->total = $produce_collection->contract_detail->contract->price_per_unit * $produce_collection->quantity;
                $invoice->balance = $invoice->total;
                $invoice->status = "0";
                $invoice->save();

                //Raise delivery request
                $delivery_request = new DeliveryRequests();
                $delivery_request->produce_collection_id = $produce_collection->id;
                $delivery_request->transporter_id = $request->transporter_id;
                $delivery_request->picking_time = $request->picking_time;
                $delivery_request->delivery_time = $request->delivery_time;
                $delivery_request->status = $request->status;
                $delivery_request->save();

                $notification = array(
                    'message' => 'Collection approved successfully!',
                    'alert' => 'success', // success, error, info, warning
                );

                return response()->json(['produce_collection' => $produce_collection->load('contract_detail', 'contract_detail.produce_item', 'contract_detail.contract', 'contract_detail.produce_item.trader', 'contract_detail.contract.trader', 'contract_detail.produce_item.produce', 'contract_detail.produce_item.produce_unit'), 'notification' => $notification]);
            }
        }

        return response()->json(['errors' => 'Approval failed.']);
    }

    /**
     * Show the form for editing the specified trader-member.
     *
     * @param int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function editAjax($id)
    {
        $produce_collection = ProduceCollection::findOrFail($id);
        return response()->json($produce_collection->load('contract_detail', 'contract_detail.contract', 'contract_detail.produce_item', 'contract_detail.contract.trader', 'contract_detail.produce_item.trader', 'contract_detail.produce_item.produce', 'contract_detail.produce_item.produce_unit', 'collector', 'approver'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\ProduceCollection  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        $produce_collection = ProduceCollection::where('id', $id)->delete();
        return response()->json($produce_collection);
    }
}
