<?php

namespace App\Http\Controllers;

use App\ProduceCategory;
use App\Trader;
use Illuminate\Http\Request;

class ProduceCategoryController extends Controller {

    public function __construct()
	{
	    $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
        //$this->authorize('viewAny', ProductCategory::class);
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        $produce_categories = ProduceCategory::paginate(env('LIST_SIZE', 10));
        // $productCategories = ProductCategory::whereNull('parent_id')
        //     ->with('childrenCategories')
        //     ->get();

        return view('produce-categories.index', compact('produce_categories','dashboard'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
       // $this->authorize('create', ProductCategory::class);
        //fetch existing product categories for purposes of filling parent_id
        $produceCategories = ProduceCategory::all();
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('produce-categories.create', compact('produceCategories','dashboard'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
       // $this->authorize('create', ProductCategory::class);
        $request->validate([
            'name' => 'required|unique:produce,name',
            'description' => 'nullable',
            //'parent_id' => 'nullable|exists:product_categories,id'
        ]);
        $record = new ProduceCategory();
        $record->fill($request->all());
        if ($record->save()) {
            return redirect()->route('produce-categories.index')->with('success', 'Produce category created.');
        } else {
            return redirect()->back()->with('failure', 'Create failed.');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\ProduceCategory  $produceCategory
     * @return \Illuminate\Http\Response
     */
    public function show(ProduceCategory $produceCategory) {
       // $this->authorize('view', $productCategory);
       
       $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('produce-categories.show', compact('produceCategory','dashboard'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\ProduceCategory  $produceCategory
     * @return \Illuminate\Http\Response
     */
    public function edit(ProduceCategory $produceCategory) {
       // $this->authorize('update', $produceCategory);
        //fetch existing product categories for purposes of filling parent_id
        $produceCategories = ProduceCategory::paginate(env('LIST_SIZE', 10));
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('produce-categories.edit', compact('produceCategory', 'produceCategories','dashboard'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\ProduceCategory  $produceCategory
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ProduceCategory $produceCategory) {
        //$this->authorize('update', $productCategory);
        $request->validate([
            'name' => 'required|unique:produce,name,' . $produceCategory->id,
            'description' => 'nullable',
            //'parent_id' => 'nullable|exists:product_categories,id'
        ]);
        if ($produceCategory->update($request->all())) {
            return redirect()->route('produce-categories.index')->with('success', 'Produce category updated.');
        } else {
            return redirect()->back()->with('failure', 'Update failed.');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\ProduceCategory  $produceCategory
     * @return \Illuminate\Http\Response
     */
    public function destroy(ProduceCategory $produceCategory) {
        //$this->authorize('delete', $productCategory);
        //check associations
        if ($produceCategory->produce()->count() > 0) {
            return redirect()->route('produce-categories.index')->with('failure', 'Cannot delete category because it has related produce.');
        }
        //attempt to delete
        if ($produceCategory->delete()) {
            return redirect()->route('produce-categories.index')->with('success', 'Produce category deleted.');
        } else {
            return redirect()->route('produce-categories.index')->with('failure', 'Delete failed.');
        }
    }

    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request)
    {
        $produce_category = ProduceCategory::updateOrCreate(
            ['id' => $request->id],
            ['name' => $request->name, 'description' => $request->description, 'parent_id' => $request->parent_id]
        );

        return response()->json($produce_category->load('parent'));
    }

    /**
     * Show the form for editing the specified produce_category.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $produce_category = ProduceCategory::findOrFail($id);
        return response()->json($produce_category);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        $produce_category = ProduceCategory::where('id', $id)->delete();
        return response()->json($produce_category);
    }

}
