<?php
namespace App\Http\Controllers;

use App\News;
use App\NewsCategory;
use App\Trader;
use Illuminate\Http\Request;
use Config;
use Auth;
use App\Chat;

class NewsController extends Controller
{
    //return news data
    public function news()
    {
        
        $news = News::with('newsAdmin')/*->with('newsCategory')*/->where('status',0)->get();
        return $news;
    }
    //return index view
    public function index()
    {
        $dashboard['verified_traders'] = Trader::where('status','=',1)->count();
        $news = News::with('newsAdmin')->with('newsCategory')->get();
        return view('news.index',compact('news','dashboard'));
    }
    //return specific news data
    public function getNews($id)
    {
        $news = News::where('id',$id)->with('newsAdmin')/*->with('newsCategory')*/->get();
        return $news;
    }
    //return category news
    public function getNewsCategory()
    {
        $newscat = NewsCategory::all();
        return $newscat;
    }
    //add content
    public function store(Request $request)
    {
        request()->validate([
            'title' => 'required',
            'news' => 'required',
            // 'category' => 'required',
            'file' => 'required|max:2000'
        ],
        [
            'file.required' => 'Please upload an image'
        ]);
        
        try{
            $news = new News();
            $news->title = $request->title;
            // $news->newscategory_id = $request->category;
            $news->content = $request->news;
            // return $news;
            //upload file if any
            $appurl = Config::get('app.url');
            $imagelink='';
            if($request->file('file'))
            {
                $files = $request->file('file');
                $destinationPath = 'public/newsuploads/'; // upload path
                $profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
                $files->move($destinationPath, $profileImage);
                $imagelink =  $appurl.'/'.$destinationPath.$profileImage;
            }
            

            $news->image = $imagelink;
            $news->user_id = Auth::user()->id;
            $news->status = '1';
            
            $news->save();
            return response()->json('Success');
        }
        catch(Exception $e)
        {
            return response()->json('Failed');
        }
    }
    
    
    
        //return index view
    public function surveillance()
    {
        $pests='pests';
        $insects='insects';
        $content='rodents';
        $dashboard['verified_traders'] = Trader::where('status','=',1)->count();
       // $county=County::with('tradercounty')->get();
        $news = Chat::with('traderchart')->where('message', 'like', '%' . $content . '%')->orWhere('message', 'like', '%' . $pests . '%')->orWhere('message', 'like', '%' . $insects . '%')->get();
        return view('news.surveillance',compact('news','dashboard'));
    }
    
    
    
    //update content
    public function update(Request $request)
    {
        try
        {
            $news = News::findOrFail($request->id);
            $news->title = $request->title;
            if($request->status == 'true')
            {
                $news->status = 1;
            }
            else if($request->status == 'false')
            {
                $news->status = 0;
            }
            // $news->newscategory_id = $request->newscategory_id;
            $news->content = $request->news;
            //upload file if any
            $appurl = Config::get('app.url');
            $imagelink=$request->file;
            if($request->file('file'))
            {
                $files = $request->file('file');
                $destinationPath = 'public/newsuploads/'; // upload path
                $profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
                $files->move($destinationPath, $profileImage);
                $imagelink =  $appurl.'/'.$destinationPath.$profileImage;
            }
            

            $news->image = $imagelink;
            $news->user_id = Auth::user()->id;
            
            $news->save();
            return response()->json('Success');
        }
        catch(Exception $e)
        {
            return response()->json('Failed');
        }
        
    }
    //delete content
    public function destroy($id)
    {
        try{
            $news = News::findOrFail($id);
            $news->delete();
            return response()->json('Success');
        }
        catch(Exception $e)
        {
            return response()->json('Failed');
        }
    }
}