<?php

namespace App\Http\Controllers;
use Exception;
use Auth;
use App\Livestock;
use Illuminate\Http\Request;

class LivestockController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index($id)
    {
        return view('livestock-inspect.index',compact('id'));
    }

    public function getInspects($id)
    {
        $livestock = Livestock::where('farmer_id',$id)->with('livestockChild')->get();
        return $livestock;
    }
    
    public function store(Request $request)
    {
        request()->validate([
            'animal' => 'required',
            'breed' => 'required',
            'sex' => 'required',
            'weight' => 'required',
            'age' => 'required',
            'disease_history' => 'required',
            'purpose' => 'required',
            'intake' => 'required',
            'yields' => 'required',
            'tag_number' => 'required',
            
        ]);
            $inspect= new Livestock();
            $inspect->animal = $request->animal;
            $inspect->breed = $request->breed;
            $inspect->sex = $request->sex;
            $inspect->weight = $request->weight;
            $inspect->age = $request->age;
            $inspect->disease_history = $request->disease_history;
            $inspect->purpose = $request->purpose;
            $inspect->intake = $request->intake;
            $inspect->yields = $request->yields;
            $inspect->tag_number = $request->tag_number;
            $inspect->agent_id = Auth::user()->id;
            $inspect->farmer_id = $request->farmer_id;
            $inspect->parent_id = $request->parent_id['livestock_id'];
            $inspect->save();
            return $inspect;
        
    }


    public function update(Request $request)
    {
            $inspect= Livestock::findOrFail($request->livestock_id);
            $inspect->animal = $request->animal;
            $inspect->breed = $request->breed;
            $inspect->sex = $request->sex;
            $inspect->weight = $request->weight;
            $inspect->age = $request->age;
            $inspect->disease_history = $request->disease_history;
            $inspect->purpose = $request->purpose;
            $inspect->intake = $request->intake;
            $inspect->yields = $request->yields;
            $inspect->tag_number = $request->tag_number;
            $inspect->agent_id = Auth::user()->id;
            $inspect->parent_id = $request->parent_id['livestock_id'];
            $inspect->save();
            return $inspect;
    }


    public function destroy($id)
    {
        $inspect= Livestock::findOrFail($id);
        $inspect->delete();
        return $inspect;
    }
}
