<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Invoice;
use App\InvoicePayment;
use App\Order;
use Illuminate\Http\Request;
use Exception;
use Auth;
use App\inputOrderItems;
use App\inputOrders;
use App\Trader;


class InvoicesController extends Controller
{
    /**
     * Create a new Invoices controller instance.
     *
     * @return void
     */
	public function __construct()
	{
	    $this->middleware('auth');
	}

    /**
     * Display a listing of the seller-invoices.
     *
     * @return Illuminate\View\View
     */
    public function index()
    {
        $user_id = Auth::User()->id;
        
        $trader = Trader::where('user_id',$user_id)->pluck('id');       
        
        //$order = inputOrders::where('trader_id', $user_id)->pluck('id');
      
        $items = inputOrderItems::where('directed_to', $trader[0])->pluck('id');
        
        $invoices = Invoice::with('invoice')->where('type',"input")->whereIn('input_item_id', $items)->paginate(25)->sortByDesc('id');
       
        return view('seller-invoices.index', compact('invoices'));
    }
    public function index2()
    {
        $invoiceout = Invoice::with('invoice')->where('direction' ,"out")->paginate(25);

        return view('seller-invoices.index2', compact('invoiceout'));
    }
    /**
     * Show the form for creating a new invoice.
     *
     * @return Illuminate\View\View
     */
    public function create()
    {
        // $orders = Order::pluck('id','id')->all();

        // return view('seller-invoices.create', compact('orders'));
    }

    /**
     * Store a new invoice in the storage.
     *
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {

        try {

            $id = $request->get('id');
            $invoice = Invoice::find($id);
            $invoice->status = "2";
            $invoice->save();
            return redirect()->route('seller-invoices.index')
                ->with('success', 'Invoice payment confirmed successfully.');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        }

        // $id = $request->get('id');

        // //invoice
        // $invoice = new Invoice();
        // $invoice->input_item_id = NULL;
        // $invoice->direction = "out";
        // $invoice->status = $request->get('approved');
        // $invoice->directed_to = NULL;
        // $invoice->posted_by = Auth::User()->id;
        // $invoice->type = $request->get('type');
        // $invoice->total = $request->get('total');
        // $invoice->number = $request->get('number');
        // $invoice->save();
        // return redirect()->route('seller-invoices.index')
        // ->with('success', "Done Succesfully");
    }

    /**
     * Display the specified invoice.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function show($id)
    {
        // $invoice = Invoice::with('order')->findOrFail($id);

        // return view('seller-invoices.show', compact('invoice'));
        $invoice = Invoice::find($id);
        $invoices = InvoicePayment::all()->where('invoice_id',$id);

        return view('seller-invoices.details', compact('invoices','invoice'));
    }

    /**
     * Show the form for editing the specified invoice.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function edit($id)
    {
        // $invoice = Invoice::findOrFail($id);
        // $orders = Order::pluck('id','id')->all();

        // return view('seller-invoices.edit', compact('invoice','orders'));
    }

    /**
     * Update the specified invoice in the storage.
     *
     * @param int $id$invoices = InvoicePayment::find($id)->sortByDesc('id');
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        // try {

        //     $data = $this->getData($request);

        //     $invoice = Invoice::findOrFail($id);
        //     $invoice->update($data);

        //     return redirect()->route('seller-invoices.invoice.index')
        //         ->with('success_message', 'Invoice was successfully updated.');
        // } catch (Exception $exception) {

        //     return back()->withInput()
        //         ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        // }
    }

    /**
     * Remove the specified invoice from the storage.
     *
     * @param int $id
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        try {
            $invoice = Invoice::findOrFail($id);
            $invoice->delete();

            return redirect()->route('seller-invoices.index')
                ->with('success_message', 'Invoice was successfully deleted.');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        }
    }


    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request\Request $request
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
            'order_id' => 'required',
            'number' => 'nullable|numeric|string|min:0',
            'date' => 'required|string|date_format:m/d/Y',
            'total' => 'nullable|numeric|min:0|max:1.844674407371E+19',
            'status' => 'nullable|string|min:0|max:255',
        ];


        $data = $request->validate($rules);

        return $data;
    }

}
