<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Invoice;
use App\InvoicePayment;
use Illuminate\Http\Request;
use Exception;

class InvoicePaymentsController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	}

    /**
     * Display a listing of the invoice payments.
     *
     * @return Illuminate\View\View
     */
    public function index()
    {
        $invoicePayments = InvoicePayment::with('invoice')->paginate(25);

        return view('invoice_payments.index', compact('invoicePayments'));
    }

    /**
     * Show the form for creating a new invoice payment.
     *
     * @return Illuminate\View\View
     */
    public function create()
    {
        $Invoices = Invoice::pluck('number','id')->all();

        return view('invoice_payments.create', compact('Invoices'));
    }

    /**
     * Store a new invoice payment in the storage.
     *
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
        try {

            $data = $this->getData($request);

            InvoicePayment::create($data);

            return redirect()->route('invoice_payments.invoice_payment.index')
                ->with('success_message', 'Invoice Payment was successfully added.');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        }
    }

    /**
     * Display the specified invoice payment.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function show($id)
    {
        $invoicePayment = InvoicePayment::with('invoice')->findOrFail($id);

        return view('invoice_payments.show', compact('invoicePayment'));
    }

    /**
     * Show the form for editing the specified invoice payment.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function edit($id)
    {
        $invoicePayment = InvoicePayment::findOrFail($id);
        $Invoices = Invoice::pluck('number','id')->all();

        return view('invoice_payments.edit', compact('invoicePayment','Invoices'));
    }

    /**
     * Update the specified invoice payment in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        try {

            $data = $this->getData($request);

            $invoicePayment = InvoicePayment::findOrFail($id);
            $invoicePayment->update($data);

            return redirect()->route('invoice_payments.invoice_payment.index')
                ->with('success_message', 'Invoice Payment was successfully updated.');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        }
    }

    /**
     * Remove the specified invoice payment from the storage.
     *
     * @param int $id
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        try {
            $invoicePayment = InvoicePayment::findOrFail($id);
            $invoicePayment->delete();

            return redirect()->route('invoice_payments.invoice_payment.index')
                ->with('success_message', 'Invoice Payment was successfully deleted.');
        } catch (Exception $exception) {

            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
        }
    }


    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request\Request $request
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
            'invoice_id' => 'required',
            'mode' => 'nullable|string|min:0|max:255',
            'amount' => 'nullable|numeric|min:0|max:999999999.9999',
            'reference' => 'nullable|string|min:0|max:255',
            'date' => 'nullable|string|min:0',
        ];

        $data = $request->validate($rules);

        return $data;
    }

}
