<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\InputUnit;
use App\Trader;
use Illuminate\Http\Request;
use Exception;

class InputUnitController extends Controller
{

    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Display a listing of the produce-units.
     *
     * @return Illuminate\View\View
     */
    public function index(Request $request)
    {
        $input_units = InputUnit::paginate(env('LIST_SIZE', 10));

        if($request->ajax()){
					$return_array = compact('input_units');
          return json_encode($return_array);
        }
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('input-units.index', compact('input_units','dashboard'));
    }

    /**
     * Show the form for creating a new produce_unit.
     *
     * @return Illuminate\View\View
     */
    public function create(Request $request)
    {
        $input_units = InputUnit::pluck('name','id')->all();

        if($request->ajax()){
					$return_array = compact('input_units');
          return json_encode($return_array);
        }
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('input-units.create', compact('input_units','dashboard'));
    }

    /**
     * Store a new produceunit in the storage.
     *
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function store(Request $request)
    {
             $data = $this->getData($request);

            $input_unit=InputUnit::create($data)->id;
            if($input_unit){
                    return redirect()->route('input-units.index')
                    ->with('success_message', 'Input unit was successfully added.');

                   // return response()->json($k);
                }
                else{
                    return back()->withInput()
                    ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);

                }

            //return response()->json($data);


    }

    /**
     * Display the specified produceunit.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function show($id)
    {
        $input_unit = InputUnit::findOrFail($id);
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('input-units.show', compact('input_unit','dashboard'));
    }

    /**
     * Show the form for editing the specified inputunit.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function edit($id)
    {
        $input_unit = InputUnit::findOrFail($id);
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('input-units.edit', compact('input_unit','dashboard'));
    }

    /**
     * Update the specified inputunit in the storage.
     *
     * @param int $id
     * @param Illuminate\Http\Request $request
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function update($id, Request $request)
    {
        //try {

            $data = $this->getData($request);

            $input_unit = InputUnit::findOrFail($id);
            $updateinputunit=$input_unit->update($data);
            if($updateinputunit){
                return redirect()->route('input-units.index')
                ->with('success_message', 'input Unit was successfully updated.');
            }
            else{
                return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);


            }


    }

    /**
     * Remove the specified input unit from the storage.
     *
     * @param int $id
     *
     * @return Illuminate\Http\RedirectResponse | Illuminate\Routing\Redirector
     */
    public function destroy($id)
    {
        //try {
            $inputunit = InputUnit::findOrFail($id);
            $deletedinputunit=$inputunit->delete();
            if($deletedinputunit){
                return redirect()->route('input-units.index')
                ->with('success_message', 'Input Unit was successfully deleted.');
            }
            else{
                return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);
            }


    }


    /**
     * Get the request's data from the request.
     *
     * @param Illuminate\Http\Request\Request $request
     * @return array
     */
    protected function getData(Request $request)
    {
        $rules = [
            'name' => 'required|string|min:0|max:255',
            'description' => 'required|string|min:0|max:255',
            'abbreviation' => 'required|string|min:0|max:255',

        ];
        $data = $request->validate($rules);

        return $data;
    }

    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request)
    {
        $input_unit = InputUnit::updateOrCreate(
            ['id' => $request->id],
            ['name' => $request->name, 'abbreviation' => $request->abbreviation, 'description' => $request->description]
        );

        return response()->json($input_unit);
    }

    /**
     * Show the form for editing the specified input_unit.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $input_unit = InputUnit::findOrFail($id);

        return response()->json($input_unit);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        $input_unit = InputUnit::where('id', $id)->delete();
        return response()->json($input_unit);
    }
}
