<?php

namespace App\Http\Controllers;

use Auth;
use EloquentBuilder;
use Illuminate\Http\Request;
use App\InputItem;
use App\inputOrders;
use App\inputOrderItems;
use App\ForwardedInputOrderItem;
use App\Trader;
use App\User;
use App\UserWallet;
use App\TraderMember;
use App\Input;
use App\Credits;
use App\Exports\InputOrderItemsExport;

class InputOrderItemsController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
    }

    public function export($id, Request $request) {
        return new InputOrderItemsExport($id, $request);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $items = inputOrderItems::all();
        return view('input_orders.details.{id}', 'items');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        inputOrderItems::create($request->all());

        return redirect()->route('input_orders.details')
        ->with('success','Order Item has been added succesfully.');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $farmer_items = inputOrderItems::find($id);
        return view('farmer_input_orders.details.{id}', 'farmer_items');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $item = inputOrderItems::find($id);
        return view('input_orders.edit', 'item');
    }

    public function destroyAjax($id) {
        $item = inputOrderItems::findOrFail($id);
        if($item->delete()) {
            if($item->financing == "wallet") {
                $id = UserWallet::where('user_id', $item->farmer_id)->pluck('id');
                $float = UserWallet::findOrFail($id[0]);
                $float->float_bal += $item->price;
                $float->save();
            } elseif($item->financing == "credit") {
                $id = Credits::where('input_order_item_id', $item->id)->pluck('id');
                if(isset($id[0])) {
                    $float = Credits::findOrFail($id[0]);
                    $float->delete();
                }
            }

            $notification = array(
                'message' => 'Order item deleted successfully!',
                'alert' => 'success', // success, error, info, warning
            );

            return response()->json(['order_item' => $item, 'notification' => $notification]);
        }

        return response()->json(['errors' => 'Order item deletion failed.']);
    }

    public function getInputItemsAjax($id) {

        if(Auth::user()->isAdmin() || Auth::user()->getRelatedTrader()->isFarmerOrganisation())
        {
            $input_items = InputItem::where('input_id', $id)->with('trader','input','input_unit')->get();

        }else
        {
            $trader_id = TraderMember::where('user_id',Auth::user()->id)->pluck('trader_id');
            $input_items = InputItem::where('input_id', $id)->where('trader_id', $trader_id[0])->with('trader','input','input_unit')->get();

        }
        if(isset($input_items)) {
            return response()->json($input_items);
        } else { return response()->json(['errors'=> 'No input items found.']); }
    }

    /**
     * Show the form for editing the specified trader-member.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $input_order_item = inputOrderItems::findOrFail($id);
        return response()->json($input_order_item->load('input', 'input.input','crs'));
    }

    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request)
    {
        if($request->financing == "wallet") {
            $approved = "1";
        } else {
            if($request->credited > 0){
                $approved = "1";
            } else {
                $approved = "0";
            }
        }

        if($request->id) {
            $old_price = inputOrderItems::where('id', $request->id)->value('price');
        }

        $input_order_item = inputOrderItems::updateOrCreate(
            ['id' => $request->id],
            ['order_id' => $request->order_id, 'farmer_id' => $request->farmer_id, 'input_item_id' => $request->input_item_id, 'quantity' => $request->quantity, 'expected_date' => $request->expected_date, 'description' => $request->description, 'directed_to' => $request->directed_to, 'financing' => $request->financing, 'price' => $request->price, 'approved' =>$approved]
        );

        if($input_order_item) {
            if($request->id) {
                $msg = 'Order item updated successfully!';
                if($request->financing == "wallet") {
                    $id = UserWallet::where('user_id', $input_order_item->farmer_id)->pluck('id');
                    $wallet = UserWallet::findOrFail($id[0]);
                    $wallet->float_bal += $old_price;
                    $wallet->float_bal -= $input_order_item->price;
                    $wallet->save();
                }
            } else {
                $msg = 'Order item added successfully!';
                if($request->financing == "wallet") {
                    $id = UserWallet::where('user_id', $input_order_item->farmer_id)->pluck('id');
                    $wallet = UserWallet::findOrFail($id[0]);
                    $wallet->float_bal -= $input_order_item->price;
                    $wallet->save();
                }
            }

            $input_order = inputOrders::find($request->order_id)->loadCount('orderItems');
            if($input_order->order_items_count == 1) $redirect = $first_item = true;
            else $redirect = $first_item = false;

            $notification = array(
                'message' => $msg,
                'alert' => 'success', // success, error, info, warning
                'redirect' => $redirect
            );

            return response()->json(['order_item' => $input_order_item->load('farmer', 'orders', 'input', 'input.trader', 'input.input_unit'), 'notification' => $notification, 'first_item' => $first_item]);
        }

        return response()->json(['errors' => 'Order item creation failed.']);
    }


    public function forwardInputItemAjax(Request $request) {
        $forwarded['input_order_item_id'] = $request->id;
        $forwarded['forwarded_by'] = $request->forwarded_by;
        $forwarded['forwarded_to'] = $request->forwarded_to;

        $forwarded_id = ForwardedInputOrderItem::create($forwarded)->id;
        if($forwarded_id){
            $input_order_item = inputOrderItems::updateOrCreate(
                ['id' => $request->id],
                ['directed_to' => $request->forwarded_to]
            );

            return response()->json($input_order_item->load('farmer', 'orders', 'input'));
        }

        return response()->json(['errors'=> 'Could not forward order.']);
    }

    public function getForwardInputItemAjax($id) {
        $input_order_item = inputOrderItems::findOrFail($id);
        return response()->json($input_order_item->load('farmer', 'input', 'orders'));
    }
}
