<?php

namespace App\Http\Controllers;

use EloquentBuilder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\inputOrders;
use App\inputOrderItems;
use App\Trader;
use App\User;
use App\TraderMember;
use App\InputItem;
use App\Invoice;
use App\Input;
use App\Credits;
use App\UserWallet;
use App\InputReleases;
use App\InputOrderItemsRelease;
class InputOrderController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        
                
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        $user_id = Auth::user()->id;
        $trader = Trader::where('user_id', $user_id)->pluck('id');
        if($trader->count() == 0) {
            $order = inputOrders::all()->where('approved',1);
            $inpu = Trader::all()->where('type_id',1);
            $inputs = inputOrders::all()->sortByDesc('id');
        } elseif($trader->count() > 0) {
            $order = inputOrders::all()->where('approved',1);
            $inpu = Trader::all()->where('type_id',1);
            $inputs = inputOrders::all()->where('trader_id', $trader[0])->sortByDesc('id');
        }

        return view('input_orders.index', compact('inputs','inpu','order','trader','dashboard'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        
                
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        $uid = Auth::user()->id;

        $trader = TraderMember::where('user_id', $uid)->pluck('trader_id');
        $agfarmers = TraderMember::all();

        $inputsag = InputItem::where('trader_id',$trader[0])->pluck('input_id');
        $inputsagro = Input::whereIn('id',$inputsag)->all();

        $inputs = Input::all();

        $seller = Trader::all()->whereIn('type_id', [3,4]);

        return view('input_orders.create', compact('agfarmers','inputs','inputsagro','seller','dashboard'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        if(isset($_POST['transport'])) {
            request()->validate([
                'recipient' => 'required',
                'means' => 'required',
                'date' => 'required'
            ]);

            $delivery = new InputOrderItemsRelease();
            $delivery->recipient = $request->get('recipient');
            $delivery->means = $request->get('means');
            $delivery->date = $request->get('date');
            $delivery->order_id = $request->get('order_id');
            $delivery->trader_id = $request->get('trader_id');
            $delivery->save();

            return redirect()->route('input_orders.index')
                ->with('success','Delivery details added succesfully.');
        } elseif(isset($_POST['form1'])) {
            $inputitem = new inputOrderItems();
            $inputitem->order_id = $request->get('order_id');
            $inputitem->farmer_id = $request->get('farmer_id');
            $inputitem->input_item_id = $request->get('input_item_id');
            $inputitem->quantity = $request->get('quantity');
            $inputitem->financing = $request->get('financing');
            $inputitem->description = $request->get('description');
            $inputitem->directed_to = $request->get('directed_to');
            $inputitem->price = $request->get('price');
            $inputitem->expected_date = $request->get('expected_date');
            if($request->get('financing') == "wallet") $inputitem->approved = 1;
            $inputitem->save();

            return redirect()->back()
                ->with('success','Order item has been created succesfully.');
        } elseif(isset($_POST['invoice'])) {
            request()->validate([
                'number' => 'required',
                'order_id' => 'required',
                'date' => 'required',
                'total' => 'required'
            ]);

            Invoice::create($request->all());

            return redirect()->route('input_orders.details')
                ->with('success','Invoice has been raised succesfully.');
        } else {
            $order = inputOrders::create($request->all());

            return redirect()->route("input_orders.show",$order->id)
                ->with('success','Input order has been added succesfully.');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id, Request $request) {
        //fetch FO members
        
                
       
        if(Auth::user()->isAdmin()) {
            $trader_id = inputOrders::where('id', $id)->pluck('trader_id');
            $trader_area = Trader::all()->where('id',$trader_id[0]);

            $farmers = TraderMember::all()->where('trader_id', $trader_id[0]);
            $agfarmers = TraderMember::all();
            $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
            $inputs = Input::all();

            $seller = Trader::all()->whereIn('type_id', [3,4]);
            $order = inputOrders::find($id)->loadCount('orderItems');

            $query = inputOrderItems::where('order_id', $id);
            $items = EloquentBuilder::to($query, request()->all())->get();
            return view('input_orders.details', compact('order','items','dashboard','agfarmers','farmers','inputs'));
        } else {
            $uid = Auth::user()->id;
            $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
            // $trader = TraderMember::where('user_id', $uid)->pluck('trader_id');
            $trader = Trader::where('user_id', $uid)->pluck('id');
            $inputsag = InputItem::where('trader_id',$trader[0])->pluck('input_id');
            $inputsagro = Input::all()->whereIn('id',$inputsag);
            $trader_id = inputOrders::where('id', $id)->pluck('trader_id');
            $trader_area = Trader::all()->where('id',$trader_id[0]);

            $farmers = TraderMember::all()->where('trader_id', $trader_id[0]);
            $agfarmers = TraderMember::all();
            $inputs = Input::all();
            $seller = Trader::all()->whereIn('type_id', [3,4]);
            $order = inputOrders::find($id)->loadCount('orderItems');

            $query = inputOrderItems::where('order_id', $id);
            $items = EloquentBuilder::to($query, request()->all())->get();
            return view('input_orders.details', compact('order','items','trader','agfarmers','farmers','inputs','inputsagro','seller','dashboard'));
        }
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $order = inputOrders::find($id);
        
                
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('input_orders.edit', compact('order','dashboard'));
        $item = inputOrderItems::find($id);
        return view('input_orders.edit', 'item','dashboard');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
        if(isset($_POST['approveitem'])) {
            $id = $request->get('id');
            $item = inputOrderItems::find($id);
            $item->approved = $request->get('approved');
            $item->save();
            return redirect()->back()
                ->with("success","Input Order Item Has Been Approved.");
        } elseif(isset($_POST['releaseitem'])) {
            $id = $request->get('input_order_item_id');
            InputReleases::create($request->all());
            $itemUpdate = inputOrderItems::find($id);
            $itemUpdate->approved = "5";
            $itemUpdate->save();

            return redirect()->back()
                ->with("success","Input Order Item Has Been Released.");
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id) {
        $order = inputOrders::find($id);
        $order->delete();
        return redirect()->route('input_orders.index')
            ->with("success","Input Order Cancelled Successfully!");
    }

    public function approveAjax(Request $request) {
        $approved = 1;
        $approved_by = Auth::user()->id;

        $input_order = inputOrders::findOrFail($request->id);
        $input_order->approved = $approved;
        $input_order->approved_by = $approved_by;

        if($input_order->save()) {
            $notification = array(
                'message' => 'Input order approved successfully!',
                'alert' => 'success', // success, error, info, warning
                'redirect' => true
            );

            return response()->json(['input_order' => $input_order->load('trader')->loadCount('orderItems'), 'notification' => $notification]);
        }

        return response()->json(['errors' => 'Input order approval failed.']);
    }
}
