<?php

namespace App\Http\Controllers;

use App\InputItem;
use App\Stock;
use App\Input;
use App\InputCategory;
use App\InputUnit;
use App\Trader;
use Illuminate\Http\Request;

class InputItemController extends Controller{
    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
       // $this->authorize('viewAny', Item::class);

        $traders = Trader::all();
        $inputs = Input::all();
        $input_units = InputUnit::all();

        if (isset($request->cid)) $cid = $request->cid;
        else $cid = null;

        //$items = ProductCategory::where('id', $request->cid)->products();//->get();
        $input_items = InputItem::all();//->get();



       /*  $itemscollection=[];

        foreach($selectedcategory as $category){
            foreach($products as $product){
                if($category->id==$product->category_id){
                    array_push($itemscollection, $product);

                }
            }
        }
        $items=collect($itemscollection);*/
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count(); 
       return view('input-items.index', compact('dashboard','traders', 'inputs', 'input_units', 'input_items'));
       // return response()->json($input_items);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
       // $this->authorize('create', Item::class);
        $traders = Trader::all();
        $inputs = Input::all();
        $inputunits = InputUnit::all();
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('input-items.create', compact('dashboard','traders', 'inputs', 'inputunits'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
       // $this->authorize('create', Item::class);
        $request->validate([
            'trader_id' => 'required|exists:traders,id',
            'input_id' => 'required|exists:inputs,id',
            'input_unit_id' => 'required|exists:input_units,id',
            'price_per_unit' => 'required|numeric',
            'icon' => 'nullable|file|mimes:jpg,jpeg,png'
        ]);
        $record = new InputItem();
        $record->fill($request->all());
        if ($record->save()) {
            //save uploaded file
            if ($request->hasFile('icon')) {
                $icon = $request->file('icon');
                //save path to icon in database
                $record->icon = $icon->store('item-icons', 'public');
                $record->save();
            }
            return redirect()->route('input-items.index')->with('success', 'Input item created.');
        } else {
            return redirect()->back()->with('failure', 'Create failed.');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\InputItem  $item
     * @return \Illuminate\Http\Response
     */
    public function show(InputItem $item) {
        //$this->authorize('view', $item);
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('input-items.show', compact('dashboard','item'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\InputItem  $item
     * @return \Illuminate\Http\Response
     */
    public function edit(InputItem $inputitem) {
        //$this->authorize('update', $item);
        $traders = Trader::all();
        $inputs = Input::all();
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('input-items.edit', compact('dashboard','inputitem', 'traders', 'inputs'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\InputItem  $item
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, InputItem $item) {
        //$this->authorize('update', $item);
        $request->validate([
            'trader_id' => 'required|exists:traders,id',
            'input_id' => 'required|exists:inputs,id',
            'input_unit_id' => 'required|exists:units,id',
            'price_per_unit' => 'required|numeric',
            'icon' => 'nullable|file|mimes:jpg,jpeg,png'
        ]);
        if ($item->update($request->all())) {
            //save uploaded file
            if ($request->hasFile('icon')) {
                $icon = $request->file('icon');
                //save path to icon in database
                $item->icon = $icon->store('item-icons', 'public');
                $item->save();
            }
            return redirect()->route('input-items.index')->with('success', 'Input item updated.');
        } else {
            return redirect()->back()->with('failure', 'Update failed.');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\InputItem  $item
     * @return \Illuminate\Http\Response
     */
    public function destroy(InputItem $item) {
        //$this->authorize('delete', $item);
        //attempt to delete
        if ($item->delete()) {
            return redirect()->route('input-items.index')->with('success', 'Input item deleted.');
        } else {
            return redirect()->route('input-items.index')->with('failure', 'Delete failed.');
        }
    }

    //show form for stock form
    public function getUpdateStockForm(Request $request, InputItem $item) {
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        $traders = Trader::all();
        return view('input-items.update-stock', compact('dashboard','item', 'traders'));
    }
    //update stock
    public function updateStock(Request $request, InputItem $item) {
        $request->validate([
            'operation' => 'required|in:add,remove',
            'amount' => 'required|numeric|min:1',
            'description' => 'required'
        ]);
        $record = new Stock();
        $record->item_id = $item->id;
        $record->amount = $request->operation == 'remove' ? -1 * $request->amount : $request->amount;
        $record->description = $request->description;
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        if ($record->save()) {
            return redirect()->route('input-items.index')->with('success', 'Input Stock updated.');
        } else {
            return redirect()->back()->with('failure', 'Input Stock update failed.');
        }
    }

    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request) {
        $input_item = InputItem::updateOrCreate(
            ['id' => $request->id],
            ['name' => $request->name, 'trader_id' => $request->trader_id, 'input_id' => $request->input_id, 'input_unit_id' => $request->input_unit_id, 'price_per_unit' => $request->price_per_unit, 'listed' => $request->listed]
        );
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        
        return response()->json($input_item->load('trader', 'input', 'input_unit'));
    }

    /**
     * Show the form for editing the specified input.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $input_item = InputItem::findOrFail($id);

        return response()->json($input_item);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        $input_item = InputItem::where('id', $id)->delete();
        return response()->json($input_item);
    }

}
