<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Input;
use App\Trader;
use App\InputCategory;

class InputController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	} 
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
        // $this->authorize('viewAny', Produce::class);

         $input_categories = InputCategory::all();
         //create query to retrieve  products
         $query = Input::query();
         //apply category if it was supplied
         $cid = $request->cid;
         if (!is_null($cid)) {
             $query->where('category_id', '=', $cid);
         }
         $inputs = $query->paginate(env('LIST_SIZE', 10));
         
         $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
         return view('inputs.index', compact('inputs', 'input_categories','dashboard'));
     }

     /**
      * Show the form for creating a new resource.
      *
      * @return \Illuminate\Http\Response
      */
     public function create() {
         //$this->authorize('create', Produce::class);
         $categories = Input::all();
         
         $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
         return view('inputs.create', compact('categories','dashboard'));
     }

     /**
      * Store a newly created resource in storage.
      *
      * @param  \Illuminate\Http\Request  $request
      * @return \Illuminate\Http\Response
      */
     public function store(Request $request) {
        // $this->authorize('create', Product::class);
         $request->validate([
             'category_id' => 'nullable|exists:input_categories,id',
             'name' => 'required|unique:input,name',
             'description' => 'required',
             'listed' => 'required|in:0,1',
             'icon' => 'nullable|file|mimes:jpg,jpeg,png'
         ]);
         $record = new Input();
         $record->fill($request->all());
         if ($record->save()) {
             //save uploaded file
             if ($request->hasFile('icon')) {
                 $icon = $request->file('icon');
                 //save path to icon in database
                 $record->icon = $icon->store('input-icons', 'public');
                 $record->save();
             }
             return redirect()->route('inputs.index')->with('success', 'Input created.');
         } else {
             return redirect()->back()->with('failure', 'Create failed.');
         }
     }

     /**
      * Display the specified resource.
      *
      * @param  \App\Input  $product
      * @return \Illuminate\Http\Response
      */
     public function show(Input $input) {
         //$this->authorize('view', $product);
         
         $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
         return view('inputs.show', compact('input','dashboard'));
     }

     /**
      * Show the form for editing the specified resource.
      *
      * @param  \App\Input $product
      * @return \Illuminate\Http\Response
      */
     public function edit(Input $input) {
         //$this->authorize('update', $product);
         $categories = Input::all();
         
         $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
         return view('inputs.edit', compact('input', 'categories','dashboard'));
     }

     /**
      * Update the specified resource in storage.
      *
      * @param  \Illuminate\Http\Request  $request
      * @param  \App\Input  $product
      * @return \Illuminate\Http\Response
      */
     public function update(Request $request, Input $input) {
       //  $this->authorize('update', $produce);
         $request->validate([
             'category_id' => 'nullable|exists:input_categories,id',
             'name' => 'required|unique:input,name,' . $input->id,
             'description' => 'required',
             'listed' => 'required|in:0,1',
             'icon' => 'nullable|file|mimes:jpg,jpeg,png'
         ]);
         if ($input->update($request->all())) {
             //save uploaded file
             if ($request->hasFile('icon')) {
                 $icon = $request->file('icon');
                 //save path to icon in database
                 $input->icon = $icon->store('input-icons', 'public');
                 $input->save();
             }
             return redirect()->route('inputs.index')->with('success', 'Input updated.');
         } else {
             return redirect()->back()->with('failure', 'Update failed.');
         }
     }

     /**
      * Remove the specified resource from storage.
      *
      * @param  \App\Input  $product
      * @return \Illuminate\Http\Response
      */
     public function destroy(Input $input) {
        // $this->authorize('delete', $product);
         //check associations
         if ($input->input_items()->count() > 0) {
             return redirect()->route('inputs.index')->with('failure', 'Cannot delete input because it has associated items.');
         }
         //attempt to delete
         if ($input->delete()) {
             return redirect()->route('inputs.index')->with('success', 'input deleted.');
         } else {
             return redirect()->route('inputs.index')->with('failure', 'Delete failed.');
         }
     }

     /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request)
    {
        $input = Input::updateOrCreate(
            ['id' => $request->id],
            ['name' => $request->name, 'description' => $request->description, 'category_id' => $request->category_id, 'listed' => $request->listed]
        );

        return response()->json($input->load('category'));
    }

    /**
     * Show the form for editing the specified input.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $input = Input::findOrFail($id);

        return response()->json($input);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        $input = Input::where('id', $id)->delete();
        return response()->json($input);
    }

}
