<?php

namespace App\Http\Controllers;

use App\InputCategory;
use App\Trader;
use Illuminate\Http\Request;

class InputCategoryController extends Controller {

    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
        //$this->authorize('viewAny', ProductCategory::class);

        $input_categories = InputCategory::paginate(env('LIST_SIZE', 10));
        // $productCategories = ProductCategory::whereNull('parent_id')
        //     ->with('childrenCategories')
        //     ->get();
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('input-categories.index', compact('input_categories','dashboard'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
       // $this->authorize('create', ProductCategory::class);
        //fetch existing product categories for purposes of filling parent_id
        $inputCategories = InputCategory::all();
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('input-categories.create', compact('inputCategories','dashboard'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
       // $this->authorize('create', ProductCategory::class);
        $request->validate([
            'name' => 'required|unique:input,name',
            'description' => 'nullable',
            //'parent_id' => 'nullable|exists:product_categories,id'
        ]);
        $record = new InputCategory();
        $record->fill($request->all());
        if ($record->save()) {
            return redirect()->route('input-categories.index')->with('success', 'Input category created.');
        } else {
            return redirect()->back()->with('failure', 'Create failed.');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\InputCategory  $productCategory
     * @return \Illuminate\Http\Response
     */
    public function show(InputCategory $inputCategory) {
       // $this->authorize('view', $productCategory);
       
       $dashboard['verified_traders'] = Trader::where('status','=',0)->count(); 
       return view('input-categories.show', compact('inputCategory','dashboard'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\InputCategory  $productCategory
     * @return \Illuminate\Http\Response
     */
    public function edit(InputCategory $inputCategory) {
       // $this->authorize('update', $productCategory);
        //fetch existing product categories for purposes of filling parent_id
        $inputCategories = InputCategory::paginate(env('LIST_SIZE', 10));
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('input-categories.edit', compact('inputCategory', 'inputCategories','dashboard'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\InputCategory  $productCategory
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, InputCategory $inputCategory) {
        //$this->authorize('update', $productCategory);
        $request->validate([
            'name' => 'required|unique:input,name,' . $inputCategory->id,
            'description' => 'nullable',
            //'parent_id' => 'nullable|exists:product_categories,id'
        ]);
        if ($inputCategory->update($request->all())) {
            return redirect()->route('input-categories.index')->with('success', 'Input category updated.');
        } else {
            return redirect()->back()->with('failure', 'Update failed.');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\InputCategory  $productCategory
     * @return \Illuminate\Http\Response
     */
    public function destroy(InputCategory $inputCategory) {
        //$this->authorize('delete', $productCategory);
        //check associations
        if ($inputCategory->inputs()->count() > 0) {
            return redirect()->route('input-categories.index')->with('failure', 'Cannot delete category because it has related input.');
        }
        //attempt to delete
        if ($inputCategory->delete()) {
            return redirect()->route('input-categories.index')->with('success', 'Input category deleted.');
        } else {
            return redirect()->route('input-categories.index')->with('failure', 'Delete failed.');
        }
    }

    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request)
    {
        $input_category = InputCategory::updateOrCreate(
            ['id' => $request->id],
            ['name' => $request->name, 'description' => $request->description, 'parent_id' => $request->parent_id]
        );

        return response()->json($input_category->load('parent'));
    }

    /**
     * Show the form for editing the specified input_category.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $input_category = InputCategory::findOrFail($id);

        return response()->json($input_category);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        $input_category = InputCategory::where('id', $id)->delete();
        return response()->json($input_category);
    }

}
