<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use AfricasTalking\SDK\AfricasTalking;
use Log;
use Auth;
use App\IVR;
use App\User;
use App\FarmerProfile;
class IVRController extends Controller
{
    //return view
    public function index(){
        return view('ivr.index');
    }
    
    //get data from db
    public function getIvr()
    {
        $ivrs = IVR::where('agent_id',Auth::user()->id)->with('ivrFarmer.user')->get();
        return $ivrs;
    }
    
    //callback 
    public function callBack(Request $request)
    {
        Log::info($request);
        // This is a unique ID generated for this call
        $sessionId = $_POST['sessionId'];

        // Check to see whether this call is active
        $isActive  = $_POST['isActive'];

        if ($isActive == 1)  {
            // Read in the caller's number. The format will contain the + in the beginning
            $callerNumber = $_POST['callerNumber'];

            $text = "Welcome, to twalisha, Interactive voice response. Thank you!";

            // Compose the response
            $response  = '<?xml version="1.0" encoding="UTF-8"?>';
            $response .= '<Response>';
            $response .= '<Say>'.$text.'</Say>';
            $response .= '</Response>';
            
            // Print the response onto the page so that our gateway can read it
            header('Content-type: text/plain');
            echo $response;
        } 
        else {
            // Read in call details (duration, cost). This flag is set once the call is completed.
            // Note that the gateway does not expect a response in thie case

            $duration     = $_POST['durationInSeconds'];
            $currencyCode = $_POST['currencyCode'];
            $amount       = $_POST['amount'];

            // You can then store this information in the database for your records
        }

    }
    
    //events
    public function event(Request $request)
    {
        // This is a unique ID generated for this call
        $sessionId = $request->sessionId;

        // Check to see whether this call is active
        $isActive  = $request->isActive;

        if ($isActive == 1)  {
            
            $messages = \DB::table('i_v_r_s')->where('sessionId',$sessionId)->get();
            Log::info($messages);
            // return $messages;
            if($messages[0]->message !='')
            {
                    // Compose the response
                $response  = '<?xml version="1.0" encoding="UTF-8"?>';
                $response .= '<Response>';
                $response .= '<Say>'.$messages[0]->message.'</Say>';
                $response .= '</Response>';
            }
            elseif($messages[0]->audio !='') {
                // Compose the response
                $response  = '<?xml version="1.0" encoding="UTF-8"?>';
                $response .= '<Response>';
                $response .= '<Play url='.$messages[0]->audio.'/>';
                $response .= '</Response>';
            }
            
            
            // Print the response onto the page so that our gateway can read it
            header('Content-type: text/plain');
            echo $response;
        } 
        else {
            // Read in call details (duration, cost). This flag is set once the call is completed.
            // Note that the gateway does not expect a response in thie case

            $duration     = $request->durationInSeconds;
            $currencyCode =$request->currencyCode;
            $amount       = $request->amount;

            // You can then store this information in the database for your records
            //update IVR to read
            // $ivrupdate = IVR::findOrFail($messages[0]->id);
            // $ivrupdate->status = 1;
            // $ivrupdate->save();
            \DB::table('i_v_r_s')->where('sessionId',$sessionId)->update(['status'=>2]);
            
        }
        
    }
    //make call
    public function call(Request $request)
    {
        
        // Set your app credentials
        $username = "mobisky";
        $apikey   = "9fb834c9dc3b254cba4f799e7a3f00269b001442b5cb7b837f33603e660192fb";

        // Initialize the SDK
        $AT       = new AfricasTalking($username, $apiKey="9fb834c9dc3b254cba4f799e7a3f00269b001442b5cb7b837f33603e660192fb");

        // Get the voice service
        $voice    = $AT->voice();

        // Set your Africa's Talking phone number in international format
        $from     = "+254711082099";

        // Set the numbers you want to call to in a comma-separated list
        $to       = "+254".substr($request->phone,-9);//"+254708058225";

        try {
            // Make the call
            $results = $voice->call([
                'from' => $from,
                'to'   => $to
            ]);
            Log::info($results);
            //insert to db
            if($results['status'] == 'success')
            {
                $sessionId = $results['data']->entries[0]->sessionId;
                $status = 1;
            }
            else
            {
                $status = 0;
            }
   
            $farmer_id = $request->farmer_id;
            
            if($request->audio)
            {
                $audio = $request->audio;
                $message = '';
            }
            else
            if($request->message)
            {
                $audio = '';
                $message = $request->message;
            }
            $agent_id = Auth::user()->id;
            \DB::table('trading_i_v_r_s')->insert(['sessionId'=>$sessionId ?? null,'status'=>$status,'farmer_id'=>$farmer_id,'audio'=>$audio,'message'=>$message,'agent_id'=>$agent_id]);
            return $results;
        } catch (Exception $e) {
            Log::info($e);
        }
    }
    //call to group
    public function callGroup(Request $request)
    {
        // Set your app credentials
        $username = "mobisky";
        $apikey   = "9fb834c9dc3b254cba4f799e7a3f00269b001442b5cb7b837f33603e660192fb";

        // Initialize the SDK
        $AT       = new AfricasTalking($username, $apiKey="9fb834c9dc3b254cba4f799e7a3f00269b001442b5cb7b837f33603e660192fb");

        // Get the voice service
        $voice    = $AT->voice();

        // Set your Africa's Talking phone number in international format
        $from     = "+254711082099";

        // Set the numbers you want to call to in a comma-separated list
        $farmers =  $request->farmer;
        $i = 0;
        foreach($farmers as $farmer)
        {
            $phone = FarmerProfile::where('id', $farmer['id'])->pluck('mpesa_number');
            if($phone->count())
            {
                $to="+254".substr($phone[0],-9);
                
                try {
                        // Make the call
                        $results = $voice->call([
                            'from' => $from,
                            'to'   => $to
                        ]);
                        //insert to db
                        //insert to db
                        if($results['status'] == 'success')
                        {
                            $sessionId = $results['data']->entries[0]->sessionId;
                            $status = 1;
                        }
                        else
                        {
                            $status = 0;
                        }
               
                        $farmer_id = $request->farmer_id;
                        
                        if($request->audio)
                        {
                            $audio = $request->audio;
                            $message = '';
                        }
                        else
                        if($request->message)
                        {
                            $audio = '';
                            $message = $request->message;
                        }
                        $agent_id = Auth::user()->id;
                        \DB::table('trading_i_v_r_s')->insert(['sessionId'=>$sessionId ?? null,'status'=>$status,'farmer_id'=>$farmer_id,'audio'=>$audio,'message'=>$message,'agent_id'=>$agent_id]);
                        return 'Success';
                    
                    } 
                        catch (Exception $e) {
                        echo "Error: ".$e->getMessage();
                    }
            }
        }
        return $results;
    }
}
