<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Frequentustions;
use App\Trader;

class FrequentQustionsController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */


    public function index(Request $request)
    {
        $Frequentustions = Frequentustions::paginate(env('LIST_SIZE', 10));
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('frequentquestions.index', compact('Frequentustions','dashboard'));
    }


    public function store(Request $request)
    {
     
        $user = new Frequentustions();     
        $user->frequentquestions = $request->frequentquestions;
        $user->answer = $request->answer;
        $user->status = '1';
 
        $user->save();  
        return back()->with('success','Added succesfully');
    }

    
    public function update(Request $request)
    {
        
      $user = Frequentustions::findOrFail($request->frequentquestions_id);   
        $user->frequentquestions = $request->frequentquestions;
        $user->answer = $request->answer;
        $user->status = '1';
 
        $user->save();  
        return back()->with('success','Updated succesfully');
    }


    public function destroy($id )
    {
        
       // return $request->id['shop_id'];
     ///$request;     return Favourite::find($id)->delete();
        $user = Frequentustions::findOrFail($id);
        $user->delete();
        return back()->with('success','Deleted succesfully');
    }



}
