<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\FarmerSoilHealth;
use App\Picture;
use DB;

class FarmerSoilHealthController extends Controller
{
    //return view and table data
    public function  index($id)
    {
        
        return view('soil_health.index',compact('id'));
    }
    
    //get soilhealth dets
    public function getHealth($id)
    {
        // $healths = DB::table('farmer_soil_healths')->where('farmer_id',$id)->join('pictures', 'farmer_soil_healths.soil_health_id', '=', 'pictures.soil_health_id')->get();
        $healths = DB::table('farmer_soil_healths')->where('farmer_id',$id)->
            join('pictures', function($query)
            {
                $query->on('farmer_soil_healths.soil_health_id', '=', 'pictures.soil_health_id');
            })->get();
            
        return $healths;
    }
    //store soil health dets
    public function store(Request $request)
    {
        request()->validate([
            'geolocation' => 'required',
            'physical' => 'required',
            'chemical' => 'required',
            'biological' => 'required',
            'biometric' => 'required',
            'file' => 'file|image|max:2000'
        ]);
        // $soilhealth = new FarmerSoilHealth();
        $soilhealth['geolocation'] =  $request->geolocation ;
        $soilhealth['physical'] = $request->physical;
        $soilhealth['chemical'] = $request->chemical;
        $soilhealth['biological'] = $request->biological;
        $soilhealth['biometric'] = $request->biometric;
        $soilhealth['farmer_id'] = $request->farmer_id;
        $soilhealth_id = DB::table('farmer_soil_healths')->insertGetId($soilhealth);
        
        
        $target_dir = "soiluploads/";
        $target_file = $target_dir . basename($_FILES["file"]["name"]);
        move_uploaded_file($_FILES["file"]["tmp_name"], $target_file);
        // $picture->picture_name = $target_file;
        // $picture->save();
        $picture = DB::table('pictures')->insert(['soil_health_id'=>$soilhealth_id,'picture_name'=>$target_file]);
        return $picture;
    }
    //update soil health dets
    public function update(Request $request)
    {
        request()->validate([
            'geolocation' => 'required',
            'physical' => 'required',
            'chemical' => 'required',
            'biological' => 'required',
            'biometric' => 'required',
            'file' => 'max:2000'
        ]);
        // $soilhealth = FarmerSoilHealth::findOrFail($request->id);
        $soilhealth['geolocation'] =  $request->geolocation ;
        $soilhealth['physical'] = $request->physical;
        $soilhealth['chemical'] = $request->chemical;
        $soilhealth['biological'] = $request->biological;
        $soilhealth['biometric'] = $request->biometric;
        $soilhealth['farmer_id'] = $request->farmer_id;
        // $soilhealth->save();
        
        DB::table('farmer_soil_healths')->where('soil_health_id',$request->id)->update($soilhealth);
        
        //save image
        if($request->file != 'undefined')
        {
            // $picture = new Picture();
            // $picture->soil_health_id = $request->id;
            //$newPath = $request->file->store('/home/ngetich/Desktop/mobi','local');
            $target_dir = "soiluploads/";
            $target_file = $target_dir . basename($_FILES["file"]["name"]);
            move_uploaded_file($_FILES["file"]["tmp_name"], $target_file);
            // $picture->picture_name = $target_file;
            // $picture->save();
            $picture = DB::table('pictures')->insert(['soil_health_id'=>$request->id,'picture_name'=>$target_file]);
        }
        return $soilhealth;
        
    }
    //delete
    public function delete($id)
    {
        // $soilhealth = FarmerSoilHealth::findOrFail($id);
        $soilhealth=DB::table('farmer_soil_healths')->where('soil_health_id',$id)->delete();
        $picture = DB::table('pictures')->where('soil_health_id',$id)->delete();
        return $soilhealth;
    }
    //delete pic
    public function deletePic($id)
    {
        $picture = DB::table('pictures')->where('id',$id)->delete();
        return $picture;
    }
}
