<?php

namespace App\Http\Controllers;

use EloquentBuilder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\FarmerProduceAggregation;
use App\User;
use App\Trader;
use App\TraderMember;
use App\Produce;
use App\UserWallet;
use App\Exports\ProduceAggregationsExport;
use App\ProduceItem;

class FarmerProduceAggregationController extends Controller
{
    public function __construct() {
	    $this->middleware('auth');
    }

    public function export(Request $request) {
        return new ProduceAggregationsExport($request);
    }

    public function index(Request $request) {
        $user_id = Auth::user()->id;
        $user = User::findOrFail($user_id);
        $trader = $user->getRelatedTrader();
        $produces = Produce::all();              
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();

        if($user->isAdmin() || $trader->isFarmerOrganisation()) {
            if($user->isAdmin()) {
                $produce_aggregations = EloquentBuilder::to(FarmerProduceAggregation::class, $request->all())->get();

                $traders = Trader::all();
                return view('produce-aggregations.index', compact('traders', 'produces', 'produce_aggregations','dashboard'));
            } else {
                $farmer_ids = $trader->users->pluck('id');

                $query = FarmerProduceAggregation::whereIn('farmer_id', $farmer_ids);
                $produce_aggregations = EloquentBuilder::to($query, request()->all())->get();

                // $produce_aggregations = FarmerProduceAggregation::whereIn('farmer_id', $farmer_ids)->paginate(env('LIST_SIZE', 10));
                return view('produce-aggregations.index', compact('trader', 'produces', 'produce_aggregations','dashboard'));
            }
        } else {
            return redirect()->route('dashboard')->with('failure', 'You must be an organisation admin to perform aggregation operations.');
        }
    }

    public function create() {

    }

    public function store() {

    }

    public function edit() {

    }

    public function update() {

    }

    public function destroy() {

    }

    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request)
    {
        $aggregated_by = Auth::user()->id;
        $produce_aggregation = FarmerProduceAggregation::updateOrCreate(
            ['id' => $request->id],
            ['farmer_id' => $request->farmer_id, 'produce_item_id' => $request->produce_item_id, 'quantity' => $request->quantity, 'price_per_unit' => $request->price_per_unit, 'aggregated_by' => $aggregated_by]
        );

        if($produce_aggregation) {
            $notification = array(
                'message' => 'Farmer\'s produce aggregated successfully!',
                'alert' => 'success', // success, error, info, warning
            );

            return response()->json(['produce_aggregation' => $produce_aggregation->load('farmer','produce_item','produce_item.produce','produce_item.produce_unit','aggregator','farmer.traderMember.trader'), 'notification' => $notification]);
        }

        return response()->json(['errors' => 'Aggregation failed.']);
    }

    /**
     * Show the form for editing the specified region.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $produce_aggregation = FarmerProduceAggregation::findOrFail($id);

        return response()->json($produce_aggregation);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id) {
        $produce_aggregation = FarmerProduceAggregation::where('id', $id)->delete();
        return response()->json($produce_aggregation);
    }

    public function approveAjax(Request $request) {
        $approved = 1;
        $approved_by = Auth::user()->id;

        $produce_aggregation = FarmerProduceAggregation::updateOrCreate(
            ['id' => $request->id],
            ['approved' => $approved, 'approved_by' => $approved_by]
        );

        if($produce_aggregation) {
            $produce_item = ProduceItem::find($produce_aggregation->produce_item_id);
            if ($produce_item != null) {
                $produce_item->balance += $produce_aggregation->quantity;
                $produce_item->save();
            }

            $user = User::find($produce_aggregation->farmer_id)->load('wallet');
            if ($user != null) {
                $quantity = $produce_aggregation->quantity;
                $price_per_unit = $produce_aggregation->price_per_unit;
                $transaction_total = $quantity * $price_per_unit;

                if(isset($user->traderMember->trader->settings->locked))
                    $locked_amount_factor = $user->traderMember->trader->settings->locked;
                if(isset($user->traderMember->trader->settings->credit_limit))
                    $credit_limit_factor = $user->traderMember->trader->settings->credit_limit;

                if (! isset($locked_amount_factor) || $locked_amount_factor <= 0)
                    $locked_amount_factor = 20;

                if (! isset($credit_limit_factor) || $credit_limit_factor <= 0)
                    $credit_limit_factor = 2;

                $locked_amount = ($locked_amount_factor / 100) * $transaction_total;
                $to_credit = $transaction_total - $locked_amount;

                $transaction_meta['aggregation_id'] = $produce_aggregation->id;
                $transaction_meta['description'] = 'Produce aggregation: ' . $produce_aggregation->produce_item->produce->name . ' (quantity = ' . $quantity . ', price = ' . $price_per_unit . ')';
                $transaction_meta['amount'] = $transaction_total;
                $transaction_meta['locked_amount'] = $locked_amount;
                $user->deposit($to_credit, 'deposit', $transaction_meta);

                // Calculate and update user's locked_amount and credit_limit
                $wallet_id = UserWallet::where('user_id', $user->id)->pluck('id');
                $wallet = UserWallet::findOrFail($wallet_id[0]);

                if($wallet) {
                    $new_locked_amount = $wallet->locked_amount + $locked_amount;
                    $new_credit_limit_amount = $credit_limit_factor * $new_locked_amount;

                    $wallet->locked_amount = $new_locked_amount;
                    $wallet->credit_limit = $new_credit_limit_amount;
                    $wallet->save();
                }
            }

            $notification = array(
                'message' => 'Produce aggregation approved successfully!',
                'alert' => 'success', // success, error, info, warning
            );

            return response()->json(['produce_aggregation' => $produce_aggregation->load('farmer','produce_item','produce_item.produce','produce_item.produce_unit','aggregator','farmer.traderMember.trader'), 'notification' => $notification]);
        }

        return response()->json(['errors' => 'Aggregation approval failed.']);
    }
}
