<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Trader;
use App\TraderType;
use App\User;
use App\TraderMember;
use App\TraderContract;
use App\ContractDetail;
use App\Produce;
use Exception;
use DateTime;
use App\FarmerWallet;
use Illuminate\Support\Facades\Hash;

class FarmerController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	}
    //listing the farmers
    public function index(){

        //show all the farmers
        $allfarmers=TraderMember::where('is_admin','<>','1')->get();
        //get users
        $farmers=User::whereIn('id',$allfarmers->pluck('user_id'))->get();
        //get organisations
        $organisations=Trader::whereIn('id',$allfarmers->pluck('trader_id'))->get();

        $farmers_organisations=[];
        //store the contract produce_items
        $produce_items=[];
        foreach($organisations as $org){
            foreach($allfarmers as $farmer){
                if($farmer->trader_id==$org->id){
                    //get the details of the farmer and organisation
                    $farmeruser=User::findOrFail($farmer->user_id);

                    $farmerData['farmerid']=$farmer->user_id;
                    $farmerData['firstname']=$farmeruser->firstname;
                    $farmerData['lastname']=$farmeruser->lastname;
                    $farmerData['organisation']=$org->organisation_name;
                    $farmerData['orgid']=$org->id;


                    array_push($farmers_organisations,$farmerData);

                }

            }
         }
         //get the list of organisations that are of type farmer organisations
          $traders=Trader::all();
          //get the list of farmorganisations
          $traderfarmers=TraderType::where('name','FarmerOrganisation')->get();
          $farmerorgs=[];
          //get the traders
          foreach($traders as $trader){
              foreach($traderfarmers as $farmer){
                  if($trader->type_id==$farmer->id){

                      array_push($farmerorgs,$trader);
                  }
              }
          }
          $farmerorganisations=collect($farmerorgs);

        $farmerusers=collect($farmers_organisations);


        //get the contracts details
        $contractdetails=ContractDetail::all();
        //get the trader
        $contracts=TraderContract::all();
        $produces=Produce::all();

       return view('farmers.index',compact('farmerusers','produces','farmerorganisations','contractdetails','contracts'));

    }

    //add a new farmer
    public function create(){
        //get the list of organisations that are of type farmer organisations
        $traders=Trader::all();
        //get the list of farmorganisations
        $traderfarmers=TraderType::where('name','FarmerOrganisation')->get();
        $farmerorgs=[];
        //get the traders
        foreach($traders as $trader){
            foreach($traderfarmers as $farmer){
                if($trader->type_id==$farmer->id){

                    array_push($farmerorgs,$trader);
                }

            }
        }
        $farmerorganisations=collect($farmerorgs);

        return view('farmers.create',compact('farmerorganisations'));

    }

    //add a new farmer
    public function addFarmer(Request $request){
        //set the username and the password
        $farmeruserdata['username']=$request->username;
        $farmeruserdata['username_canonical']=$request->username;
        $farmeruserdata['password']=Hash::make("password");
        $farmeruserdata['firstname']=$request->firstname;
        $farmeruserdata['lastname']=$request->lastname;
        $farmeruserdata['email']=$request->email;
        $farmeruserdata['email_canonical']=$request->email;
        $farmeruserdata['phone']=$request->phone;
        $farmeruserdata['address']=$request->address;
        $farmeruserdata['user_id']=199;
        $farmeruserdata['locked']="0";
        $farmeruserdata['enabled']="1";
        $farmeruserdata['expired']="0";
        $farmeruserdata['credentials_expired']="0";
        $farmeruserdata['salt']=Hash::make("password");
        $farmeruserdata['roles']="na";
        $farmeruserdata['registration_date']=new DateTime();
        $farmeruserdata['active']=1;
        $farmeruserdata['status']=1;
        //create the use account and get the id
        $userid=User::create($farmeruserdata)->id;
        if($userid){


            //create the corresponding organisation membership details
            $farmermemberdata['trader_id']=$request->farmerorganisation;
            $farmermemberdata['user_id']=$userid;
            $farmermemberdata['is_admin']=0;
            //store the data of the trader and get the trader id
            $tradermemberid=TraderMember::create($farmermemberdata)->id;
            if($tradermemberid){

                    return redirect('/farmers')
                    ->with('success_message', 'Farmer was successfully created.');
            }
            else{
                return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);

            }
        }
        else{
            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);

        }

    }

    //show the farmer wallet
    public function showWallet($id)
    {
        //show the wallet page
        return view('farmers.wallet',compact('id'));
    }

    //add money to wallet
    public function addMoney(Request $request){

        $wallet['credit']=$request->amount;
        $wallet['debit']=0;
        $wallet['user_id']=$request->userid;

        $walletamount=FarmerWallet::create($wallet);
        if($walletamount){

          return redirect('/farmer_wallet/'.$request->userid)
            ->with('success_message', 'Amount Credited to Wallet successfully.');
        }
        else{
            return back()->withInput()
                ->withErrors(['unexpected_error' => 'Unexpected error occurred while trying to process your request.']);

        }

    }

    //display the records of the user wallet
    public function displayWallet($id){

        $wallet_records=FarmerWallet::where('user_id',$id)->get();

        return view('farmers.wallet_listing',compact('wallet_records'));
    }

    //show the produce belong to the request farmer

    public function addFarmerProduce(Request $request){

        $produceData['farmerid']=$request->farmerid;
        $produceData['organisationid']=$request->organisationid;
        $produceData['item']=$request->item;

    }

}
