<?php

namespace App\Http\Controllers;

use App\FarmerBusinesPlan;
use App\FarmerProfile;
use Illuminate\Http\Request;
use Auth;
class FarmerBusinesPlanController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function farmerindex($id)
    {
        $farmer = FarmerProfile::where('id',$id)->with('user')->get();
        return view('farmer-plans.index', compact('id','farmer'));
    }
    //return settings data
    public function getFarmerPlans($id)
    {
        $plans = FarmerBusinesPlan::where('farmer_id',$id)->with('businessCost')->get();
        return $plans;
    }
    //store
    public function store(Request $request)
    {
        request()->validate([
            'crop' => 'required',
            'default_yield' => 'required',
            'variety' => 'required',
            'market_price' => 'required',
        ]);
        $plan = new FarmerBusinesPlan();
        $plan->crop = $request->crop;
        $plan->default_yield = $request->default_yield;
        $plan->variety = $request->variety;
        $plan->market_price = $request->market_price;
        $plan->profit = $request->market_price;
        $plan->farmer_id = $request->farmer_id;
        $plan->save();
        return $plan;
    }
    //update
    public function update(Request $request)
    {
        request()->validate([
            'crop' => 'required',
            'default_yield' => 'required',
            'variety' => 'required',
            'market_price' => 'required',
        ]);
        $prevplan = FarmerBusinesPlan::findOrFail($request->id);
        
        $profit = $request->market_price - $prevplan['market_price'];
        $plan = FarmerBusinesPlan::findOrFail($request->id);
        $plan->crop = $request->crop;
        $plan->default_yield = $request->default_yield;
        $plan->variety = $request->variety;
        $plan->market_price = $request->market_price;
        $plan->profit += $profit;
        $plan->save();
        return $plan;
    }
    public function destroy($id)
    {
        $plan = FarmerBusinesPlan::findOrFail($id);
        $plan->delete();
        return $plan;
    }
}
