<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\TraderMember;
use App\Trader;
use App\User;
use Auth;
use EloquentBuilder;

class FOFarmersController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	}
    public function index()
    {
    $trader = Auth::user()->userAgent;
    $trader_arr = [];
    foreach($trader as $traderobj)
    {
        $traderid = $traderobj->trader_id;
        array_push($trader_arr,$traderid);
    }

    $all_traders= TraderMember::where('user_id',$trader_arr)->get()->pluck('trader_id');
    
    $fos=Trader::whereIn('id',$all_traders)->get();
    
   

    $query=TraderMember::whereIn('trader_id',$all_traders);
    $allfarmers = EloquentBuilder::to($query,request()->all())->get();
    
    $selectedtrader = Trader::where('id',json_decode(request()->trader))->pluck('organisation_name');
    return view('fo-farmers.index', compact('allfarmers','fos','selectedtrader'));
    }

    //get
    public function get()
    {
    $trader = Auth::user()->userAgent;
    $trader_arr = [];
    foreach($trader as $traderobj)
    {
        $traderid = $traderobj->trader_id;
        array_push($trader_arr,$traderid);
    }
    // dd($trader);
    $allmembers=TraderMember::whereIn('trader_id',$trader_arr)->pluck('user_id');
    $allfarmers = User::whereIn('id',$allmembers)->with('farmer_profile')->with('traderMember.trader')->get();
    return $allfarmers;
    }
}
