<?php

namespace App\Http\Controllers;

use App\Events;
use Illuminate\Http\Request;
use Auth;
use Hash;
use Exception;
use App\Trader;
use App\TraderMember;
use App\User;

class EventsController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	} 
    public function index(){
        return view('calendar.index');
    }
    public function retrieve() {
        $events = Events::where('agent_id',Auth::user()->id)->get();
        return $events;
    }
    //get my farmer organizations
    public function getFOs()
    {
        $trader = Auth::user()->userAgent;
        $trader_arr = [];
        foreach($trader as $traderobj)
        {
            $traderid = $traderobj->trader_id;
            array_push($trader_arr,$traderid);
        }

        $fos = Trader::whereIn('id',$trader_arr)->get();
        return $fos;
    }
    //get FO farmers
    public function getFarmers($id)
    {
        $query=TraderMember::where('trader_id',$id)->pluck('user_id');
        $allfarmers = User::whereIn('id',$query)->with('farmer_profile')->get();
        return $allfarmers;
    }
    public function create(Request $request) {
        $event = new Events;
        $event->title = $request->title;
        $event->description = $request->description;
        $event->start = $request->start;
        $event->end = $request->end;
        $event->classNames = $request->classNames;
        $event->farmer_id = $request->farmer;
        $event->agent_id = Auth::user()->id;
        $event->save();
    }
    public function remove(Request $request) {
        $event = Events::findOrFail($request->id); 
        $event->delete();
    }
    public function update(Request $request) {
        $event = Events::findOrFail($request->id);
        $event->title = $request->title;
        $event->description = $request->description;
        $event->save();
    }
}
