<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Trader;
use App\User;
use App\TraderMember;
use App\Driver;
use Auth;

class DriverController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
	{
	    $this->middleware('auth');
	}
    public function index()
    {
        //
        $user_id = Auth::user()->id;
            $user = User::findOrFail($user_id);
            $trader = $user->getRelatedTrader();
        $drivers = Driver::where('trader_id',$trader->id)->get();
        return view('drivers.index', compact('drivers','trader'))->with('i');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        Driver::create($request->all());
        return redirect()->back()->
        with('success', 'Driver Added Successfully');
    }
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $driver = Driver::find($id);
        $driver->firstname = $request->get('firstname');
        $driver->lastname = $request->get('lastname');
        $driver->email = $request->get('email');
        $driver->phone = $request->get('phone');
        $driver->licence_no = $request->get('licence_no');
        $driver->driver_class = $request->get('driver_class');
        $driver->experience = $request->get('experience');
        $driver->status = $request->get('status');
        $driver->save();
        return redirect()->back()
        ->with('success','Driver Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $driver = Driver::find($id);
        $driver->delete();
            return redirect()->back()
        ->with("success","Driver Deleted Successfully!");
    }
}
