<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Trader;
use App\User;
use App\TraderMember;
use App\Vehicle;
use App\Driver;
use App\inputOrders;
use App\inputOrderItems;
use App\ProduceItem;
use App\ProduceOrder;
use App\ProduceOrderItem;
use App\Delivery;
use App\DeliveryRequests;
use Auth;

class DeliveryRequestsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
	{
	    $this->middleware('auth');
	}
    public function index()
    {
        //
        $user_id = Auth::user()->id;
            $user = User::findOrFail($user_id);
            $trader = $user->getRelatedTrader();

        $vehicles = Vehicle::where('trader_id',$trader->id)->get()->where('status', 0);
        $drivers = Driver::where('trader_id',$trader->id)->get()->where('status', 0);
        $requests = DeliveryRequests::where('transporter_id', $trader->id)->get();
        return view('my-delivery-requests.index', compact('requests','vehicles','drivers'))->with('i');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //

        Delivery::create($request->all());
        $did = $request->get('driver_id');
        $vid = $request->get('vehicle_id');
        $rid = $request->get('delivery_request_id');
        $vehicle = Vehicle::find($vid);
        $vehicle->status = "1";
        $vehicle->save();
        $driver = Driver::find($did);
        $driver->status = "1";
        $driver->save();
        $request = DeliveryRequests::find($rid);
        $request->status = "1";
        $request->save();
        return redirect()->back()->
        with('success', 'Delivery Accepted Successfully');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
