<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Trader;
use App\User;
use App\TraderMember;
use App\Vehicle;
use App\Driver;
use App\inputOrders;
use App\inputOrderItems;
use App\ProduceItem;
use App\ProduceOrder;
use App\ProduceOrderItem;
use App\Delivery;
use App\DeliveryRequests;
use Auth;
use App\DeliveryAcknowledgement;
use App\ProduceCollection; 

class DeliveryDoneController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
	{
	    $this->middleware('auth');
	}
    public function index()
    {
        //
        
        if(Auth::user()->isAdmin())
        {
            $vehicles = Vehicle::all();
            $drivers = Driver::all();
            $deliveries = Delivery::all();

        }
        else
        {
            $user_id = Auth::user()->id;
            $user = User::findOrFail($user_id);
            $trader = $user->getRelatedTrader();
            $trader_id=$trader->id;
            if(Auth::user()->getRelatedTrader()->isFarmerOrganisation()) {
                //
                $produce_collections = ProduceCollection::whereHas('contract_detail', function($query) use($trader_id) {
                        $query->whereHas('produce_item', function($query) use($trader_id) {
                            $query->where('trader_id', $trader_id);
                        });
                    })->pluck('id');
                    $vehicles = Vehicle::all();
                     $drivers = Driver::all();
                    $deliveries = Delivery::whereIn('produce_collection_id',$produce_collections)->get();
                
            } elseif(Auth::user()->getRelatedTrader()->isBulkBuyer()) {
                $produce_collections = ProduceCollection::whereHas('contract_detail', function($query) use($trader_id) {
                        $query->whereHas('contract', function($query) use($trader_id) {
                            $query->where('trader_id', $trader_id);
                        });
                    })->pluck('id');
                    
                    $deliveries = Delivery::whereIn('produce_collection_id',$produce_collections)->get();
                    $vehicles = Vehicle::all();
                    $drivers = Driver::all();
            } elseif(Auth::user()->getRelatedTrader()->isTransporter()) {
                $vehicles = Vehicle::where('trader_id',$trader->id)->get();
                $drivers = Driver::where('trader_id',$trader->id)->pluck('id');
                $deliveries = Delivery::whereIn('driver_id',$drivers)->get();
            }
            
            
        }
        
                
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('my-deliveries.index', compact('deliveries','vehicles','drivers','dashboard'))->with('i');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        if(isset($_POST['complete']))
        {
            $id = $request->get('id');

            $deliver = Delivery::find($id);
            $deliver->status = "2";
            $deliver->save();
            return redirect()->back()->
        with('success', 'Delivery Completed Successfully');

        } else
        if(isset($_POST['release']))
        {
            $id = $request->get('id');

            $deliver = Delivery::find($id);
            $deliver->status = "1";
            $deliver->save();
            return redirect()->back()->
        with('success', 'Produce Has Been Released for Delivery');
        }
        else if(isset($_POST['confirm-receipt']))
        {

         DeliveryAcknowledgement::create($request->all());
         $id = $request->get('delivery_id');

            $del = Delivery::find($id);
            $del->status = "3";
            $del->save();
         return redirect()->back()
            ->with('success','Acknowledged receive done succesfully.');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
