<?php

namespace App\Http\Controllers;
use Auth;
use App\CropSetting;
use App\FarmerBusinesPlan;
use Illuminate\Http\Request;

class CropSettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    //return view
    public function index()
    {
        return view('crop_setting.index');
    }
    //return settings data
    public function getSettings()
    {
        $settings = CropSetting::all();
        return $settings;
    }

    public function store(Request $request)
    {
        request()->validate([
            'crop'=>'required',
            'default_yield'=>'required',
            'variety'=>'required',
            'region'=>'required',
            'planting_method'=>'required'
        ]);
        $setting = new CropSetting();
        $setting->crop = $request->crop;
        $setting->default_yield = $request->default_yield;
        $setting->variety = $request->variety;
        $setting->region = $request->region;
        $setting->planting_method = $request->planting_method;
        $setting->cost_of_production = $request->cost_of_production;
        $setting->market_price = $request->market_price;
        // $setting->profit = $request->profit;
        $setting->save();
        return $setting;
        
    }
    public function assign(Request $request)
    {
        $plan = new FarmerBusinesPlan();
        $plan->crop = $request->crop;
        $plan->default_yield = $request->default_yield;
        $plan->variety = $request->variety;
        $plan->market_price = $request->market_price;
        $plan->profit = $request->market_price;
        $plan->farmer_id = $request->farmer['farmer_profile']['id'];
        $plan->save();
        return $plan;
        
    }

    
    public function update(Request $request)
    {
        request()->validate([
            'crop'=>'required',
            'default_yield'=>'required',
            'variety'=>'required',
        ]);
        $setting = CropSetting::findOrFail($request->id);
        $setting->crop = $request->crop;
        $setting->default_yield = $request->default_yield;
        $setting->variety = $request->variety;
        if($request->region!=''){
        $setting->region = $request->region;
        }
        if($request->planting_method!=''){
        $setting->planting_method = $request->planting_method;
        }
        $setting->cost_of_production = $request->cost_of_production;
        $setting->market_price = $request->market_price;
        $setting->profit = $request->profit;
        $setting->save();
        return $setting;
    }

    public function destroy($id)
    {
        $setting = CropSetting::findOrFail($id);
        $setting->delete();
        return $setting;
    }
}
