<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Exports\CreditRequestsExport;
use Maatwebsite\Excel\Facades\Excel;
use App\inputOrders;
use App\inputOrderItems;
use App\Trader;
use App\User;
use App\TraderMember;
use App\Input;
use App\Invoice;
use App\Credits;
use App\UserWallet;

class CreditRequestsController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    /*Print bank request for credit*/
    public function index()
    {
            //
        $id = Auth::user()->id;
        $user = User::find($id);
        $trader = $user->getRelatedTrader();
        if(Auth::user()->isAdmin()) {
            $creditwithorders = inputOrders::all()->where('approved',1);
            $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        } else {
            $creditwithorders = inputOrders::all()->where('trader_id',$trader->id)->where('approved',1);
            $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        }

        return view('credit_requests.index', compact('creditwithorders','dashboard'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $id = $request->get('id');

        if(isset($_POST['process']))
        {
            $approved = Credits::find($id);
            $approved->approved = "2";
            $approved->save();

        }
        elseif(isset($_POST['approve']))
        {
            $approved = Credits::find($id);
            $approved->approved = "3";
            $credited = $request->get('credited_amt');
            $requested = $request->get('requested_amt');
            $interest = $request->get('interest');
            $payable = ($credited +(($credited * $interest)/100));

            $approved->requested_amount = $request->get('requested_amt');
            $approved->credited_amount = $request->get('credited_amt');
            $approved->period = $request->get('period');
            $approved->payable_amount = $payable;
            $approved->balance = $payable;
            $approved->save();
            //approve item
            if($credited == $requested)
            {
            $input_order_item_id = $request->get('io_id');
            $input_order_item = inputOrderItems::find($input_order_item_id);
            $input_order_item->approved = "1";
            $input_order_item->save();
            }

            //add to wallet
            // $uid = $request->get('uid');
            // $userWallet = UserWallet::find($uid);
            // $userWallet->balance = $request->get('credited');
            // $userWallet->save();

        }
        elseif(isset($_POST['decline']))
        {
            $approved = Credits::find($id);
            $approved->approved = "1";
            $approved->save();

        }
        elseif(isset($_POST['accept']))
        {
            $approved = Credits::find($id);
            $approved->approved = "2";
            $approved->save();

        }

      return redirect()->back()
      ->with('success','Done successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function export(Request $request) {
        return new CreditRequestsExport($request);
    }

    public function show($id)
    {
        //
       

        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        $farmer = User::all();
        $order = inputOrders::find($id);        
        $items = inputOrderItems::where('financing', "credit")->where('order_id',$id)->pluck('id');
      
        $credit = Credits::all()->whereIn('input_order_item_id',$items)->sortByDesc('id');
       
        //
        $reqs = inputOrderItems::all()->where('approved' ,0)->where('financing', "credit")->where('order_id', $id)->sortByDesc('id');
        return view('credit_requests.details', compact('credit','dashboard','farmer','order','reqs'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
