<?php

namespace App\Http\Controllers;

use App\County;
use App\Trader;
use Illuminate\Http\Request;

class CountyController extends Controller {

    public function __construct()
	{
	    $this->middleware('auth');
	}
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
       // $this->authorize('viewAny', County::class);

       //return response()->json(County::all());
        $counties = County::all();//paginate(env('LIST_SIZE', 10));
        
                
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('counties.index', compact('counties','dashboard'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        //$this->authorize('create', County::class);
        return view('counties.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        //$this->authorize('create', County::class);
        $request->validate([
            'name' => 'required|unique:counties,name',
            'description' => 'required',
        ]);
        $record = new County();
        $record->fill($request->all());
        if ($record->save()) {
            return redirect()->route('counties.index')->with('success', 'County created.');
        } else {
            return redirect()->back()->with('failure', 'Create failed.');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\County  $county
     * @return \Illuminate\Http\Response
     */
    public function show(County $county) {
        //$this->authorize('view', $county);
        
        $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('counties.show', compact('county','dashboard'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\County  $county
     * @return \Illuminate\Http\Response
     */
    public function edit(County $county) {
       // $this->authorize('update', $county);
       
       $dashboard['verified_traders'] = Trader::where('status','=',0)->count();
        return view('counties.edit', compact('county','dashboard'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\County  $county
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, County $county) {
        //$this->authorize('update', $county);
        $request->validate([
            'name' => 'required|unique:counties,name,' . $county->id,
            'description' => 'required',
        ]);
        if ($county->update($request->all())) {
            return redirect()->route('counties.index')->with('success', 'County updated.');
        } else {
            return redirect()->back()->with('failure', 'Update failed.');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\County  $county
     * @return \Illuminate\Http\Response
     */
    public function destroy(County $county) {
        //$this->authorize('delete', $county);
        //attempt to delete
        if ($county->delete()) {
            Log::info("deleted");
            return redirect()->route('counties.index')->with('success', 'County deleted.');
        } else {
            Log::info("deletion failed");
            return redirect()->route('counties.index')->with('failure', 'Delete failed.');
        }
    }

    /**
     * Store a newly created resource in storage using AJAX.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeAjax(Request $request)
    {
        $county = County::updateOrCreate(
            ['id' => $request->id],
            ['name' => $request->name, 'code' => $request->code]
        );

        return response()->json($county);
    }

    /**
     * Show the form for editing the specified county.
     *
     * @param int $id
     *
     * @return Illuminate\View\View
     */
    public function editAjax($id)
    {
        $county = County::findOrFail($id);

        return response()->json($county);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroyAjax($id)
    {
        $county = County::where('id', $id)->delete();
        return response()->json($county);
    }

}
